/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.statesystem.backends.partial;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.backends.partial.PartialStateSystem;
import org.eclipse.tracecompass.statesystem.core.backend.IPartialStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class PartialHistoryBackend
implements IStateHistoryBackend {
    private final @NonNull String fSSID;
    private final @NonNull ITmfStateProvider fPartialInput;
    private final @NonNull PartialStateSystem fPartialSS;
    private final @NonNull IStateHistoryBackend fInnerHistory;
    private final @NonNull TreeMap<Long, Long> fCheckpoints = new TreeMap();
    private final @NonNull CountDownLatch fCheckpointsReady = new CountDownLatch(1);
    private final long fGranularity;
    private long fLatestTime;
    private final NavigableSet<@NonNull ITmfStateInterval> fCurrentIntervals;
    private final IPartialStateHistoryBackend fBackend;

    public PartialHistoryBackend(@NonNull String ssid, ITmfStateProvider partialInput, PartialStateSystem pss, IStateHistoryBackend realBackend, long granularity, @NonNull IPartialStateHistoryBackend backend) {
        if (granularity <= 0L || partialInput == null || pss == null || partialInput.getAssignedStateSystem() != pss) {
            throw new IllegalArgumentException();
        }
        long startTime = realBackend.getStartTime();
        this.fSSID = ssid;
        this.fPartialInput = partialInput;
        this.fPartialSS = pss;
        this.fInnerHistory = realBackend;
        this.fGranularity = granularity;
        this.fBackend = backend;
        this.fCurrentIntervals = new TreeSet<ITmfStateInterval>(Comparator.comparing(ITmfStateInterval::getEndTime).thenComparing(ITmfStateInterval::getAttribute));
        this.fLatestTime = startTime;
        this.registerCheckpoints();
    }

    private void registerCheckpoints() {
        CheckpointsRequest request = new CheckpointsRequest(this.fPartialInput, this.fCheckpoints);
        this.fPartialInput.getTrace().sendRequest(request);
    }

    public String getSSID() {
        return this.fSSID;
    }

    public long getStartTime() {
        return this.fInnerHistory.getStartTime();
    }

    public long getEndTime() {
        return this.fLatestTime;
    }

    public void insertPastState(long stateStartTime, long stateEndTime, int quark, Object value) throws TimeRangeException {
        this.waitForCheckpoints();
        if (stateEndTime > this.fLatestTime) {
            this.fLatestTime = stateEndTime;
        }
        if (stateStartTime <= this.fCheckpoints.floorKey(stateEndTime)) {
            this.fInnerHistory.insertPastState(stateStartTime, stateEndTime, quark, value);
        }
    }

    public void finishedBuilding(long endTime) throws TimeRangeException {
        this.fInnerHistory.finishedBuilding(endTime);
    }

    public FileInputStream supplyAttributeTreeReader() {
        return this.fInnerHistory.supplyAttributeTreeReader();
    }

    public File supplyAttributeTreeWriterFile() {
        return this.fInnerHistory.supplyAttributeTreeWriterFile();
    }

    public long supplyAttributeTreeWriterFilePosition() {
        return this.fInnerHistory.supplyAttributeTreeWriterFilePosition();
    }

    public void removeFiles() {
        this.fInnerHistory.removeFiles();
    }

    public void dispose() {
        this.fPartialInput.dispose();
        this.fPartialSS.dispose();
        this.fInnerHistory.dispose();
    }

    public void doQuery(List<@Nullable ITmfStateInterval> currentStateInfo, long t) throws TimeRangeException, StateSystemDisposedException {
        this.waitForCheckpoints();
        this.fPartialSS.getUpstreamSS().waitUntilBuilt();
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException("Invalid timestamp caused a TimeRangeException: " + this.fSSID + " Time:" + t + ", Start:" + this.getStartTime() + ", End:" + this.getEndTime());
        }
        long checkpointTime1 = this.fCheckpoints.floorKey(t);
        this.fInnerHistory.doQuery(currentStateInfo, checkpointTime1);
        if (checkpointTime1 == t) {
            return;
        }
        List<@NonNull Object> filledStateInfo = NonNullUtils.checkNotNullContents(currentStateInfo.stream()).collect(Collectors.toList());
        this.fPartialSS.takeQueryLock();
        this.fPartialSS.replaceOngoingState(filledStateInfo);
        long checkpointTime2 = 0L;
        checkpointTime2 = this.fCheckpoints.ceilingKey(t) != null ? this.fCheckpoints.ceilingKey(t).longValue() : this.fPartialInput.getTrace().getEndTime().toNanos();
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromNanos(checkpointTime1 + 1L), TmfTimestamp.fromNanos(checkpointTime2));
        PartialStateSystemRequest request = new PartialStateSystemRequest(this.fPartialInput, range);
        this.fPartialInput.getTrace().sendRequest(request);
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException interruptedException) {}
        List<ITmfStateInterval> intervalsList = this.fPartialSS.queryFullState(t);
        int i = 0;
        while (i < currentStateInfo.size()) {
            ITmfStateInterval interval = currentStateInfo.get(i);
            if (interval != null && interval.getEndTime() < intervalsList.get(i).getEndTime()) {
                currentStateInfo.set(i, intervalsList.get(i));
            }
            ++i;
        }
        if (this.fCheckpoints.ceilingKey(t) != null) {
            intervalsList = PartialHistoryBackend.prepareIntervalList(this.fPartialSS.getNbAttributes());
            filledStateInfo.clear();
            try {
                this.fInnerHistory.doQuery(intervalsList, checkpointTime2);
            }
            catch (StateSystemDisposedException e) {
                Activator.logError(e.getMessage(), e);
            }
            filledStateInfo = NonNullUtils.checkNotNullContents(intervalsList.stream()).collect(Collectors.toList());
            i = 0;
            while (i < currentStateInfo.size()) {
                ITmfStateInterval actualInterval = currentStateInfo.get(i);
                ITmfStateInterval newInterval = (ITmfStateInterval)filledStateInfo.get(i);
                if (actualInterval != null && actualInterval.getEndTime() < newInterval.getEndTime() && newInterval.intersects(t)) {
                    currentStateInfo.set(i, newInterval);
                }
                ++i;
            }
        }
        this.fPartialSS.releaseQueryLock();
    }

    private static List<@Nullable ITmfStateInterval> prepareIntervalList(int nbAttrib) {
        ArrayList<@Nullable Object> intervalsList = new ArrayList<Object>(Collections.nCopies(nbAttrib, null));
        return intervalsList;
    }

    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException, StateSystemDisposedException {
        this.waitForCheckpoints();
        this.fPartialSS.getUpstreamSS().waitUntilBuilt();
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException("Invalid timestamp caused a TimeRangeException: " + this.fSSID + " Time:" + t + ", Start:" + this.getStartTime() + ", End:" + this.getEndTime());
        }
        long checkpointTime = this.fCheckpoints.floorKey(t);
        int nbAtributes = this.fPartialSS.getNbAttributes();
        List<ITmfStateInterval> intervalsList = PartialHistoryBackend.prepareIntervalList(nbAtributes);
        this.fInnerHistory.doQuery(intervalsList, checkpointTime);
        ITmfStateInterval ret = intervalsList.get(attributeQuark);
        if (ret == null || !ret.intersects(t)) {
            intervalsList = PartialHistoryBackend.prepareIntervalList(nbAtributes);
            this.doQuery(intervalsList, t);
            ret = intervalsList.get(attributeQuark);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<@NonNull ITmfStateInterval> query2D(IntegerRangeCondition quarks, TimeRangeCondition times) throws TimeRangeException {
        IPartialStateHistoryBackend iPartialStateHistoryBackend;
        Iterator<Object> iterator;
        this.fCurrentIntervals.clear();
        this.waitForCheckpoints();
        this.fPartialSS.getUpstreamSS().waitUntilBuilt();
        IPartialStateHistoryBackend iPartialStateHistoryBackend2 = this.fBackend;
        synchronized (iPartialStateHistoryBackend2) {
            this.fBackend.updateRangeCondition(quarks);
            this.fBackend.updateTimeCondition(times);
            this.fBackend.updateQueryType(true);
        }
        long min = times.min();
        long max = times.max();
        long lowerCheckpoint = this.fCheckpoints.floorKey(min);
        long upperCheckpoint = max;
        if (this.fCheckpoints.ceilingKey(max) != null) {
            upperCheckpoint = this.fCheckpoints.ceilingKey(max);
        }
        List<@Nullable ITmfStateInterval> currentStateInfo = PartialHistoryBackend.prepareIntervalList(this.fPartialSS.getNbAttributes());
        try {
            this.fInnerHistory.doQuery(currentStateInfo, lowerCheckpoint);
        }
        catch (StateSystemDisposedException e) {
            Activator.logError(e.getMessage(), e);
        }
        List<@NonNull Object> filledStateInfo = NonNullUtils.checkNotNullContents(currentStateInfo.stream()).collect(Collectors.toList());
        for (ITmfStateInterval iTmfStateInterval : filledStateInfo) {
            if (!quarks.test(iTmfStateInterval.getAttribute()) || !times.intersects(iTmfStateInterval.getStartTime(), iTmfStateInterval.getEndTime())) continue;
            this.fCurrentIntervals.add(iTmfStateInterval);
        }
        try {
            this.fPartialSS.takeQueryLock();
            this.fPartialSS.replaceOngoingState(filledStateInfo);
            TmfTimeRange tmfTimeRange = new TmfTimeRange(TmfTimestamp.fromNanos(lowerCheckpoint), TmfTimestamp.fromNanos(upperCheckpoint));
            PartialStateSystemRequest request = new PartialStateSystemRequest(this.fPartialInput, tmfTimeRange);
            this.fPartialInput.getTrace().sendRequest(request);
            try {
                request.waitForCompletion();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            ArrayList<Integer> quarksColletion = new ArrayList<Integer>();
            int value = quarks.min();
            while (value <= quarks.max()) {
                if (quarks.test(value)) {
                    quarksColletion.add(value);
                }
                ++value;
            }
            Logger logger = Logger.getAnonymousLogger();
            try {
                PartialStateSystem partialStateSystem = this.fPartialSS;
                synchronized (partialStateSystem) {
                    for (ITmfStateInterval interval : this.fPartialSS.query2D(quarksColletion, min, max)) {
                        this.fCurrentIntervals.add(interval);
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                logger.log(Level.SEVERE, "An IndexOutOfBoundsException exception occurred", e);
            }
            catch (StateSystemDisposedException e) {
                logger.log(Level.SEVERE, "A StateSystemDisposedException exception occurred", e);
            }
        }
        finally {
            this.fPartialSS.releaseQueryLock();
        }
        if (this.fCheckpoints.ceilingKey(max) != null) {
            currentStateInfo.clear();
            filledStateInfo.clear();
            try {
                this.fInnerHistory.doQuery(currentStateInfo, upperCheckpoint);
            }
            catch (StateSystemDisposedException throwable) {
                Activator.logError(throwable.getMessage(), throwable);
            }
            filledStateInfo = NonNullUtils.checkNotNullContents(currentStateInfo.stream()).collect(Collectors.toList());
            for (ITmfStateInterval iTmfStateInterval : filledStateInfo) {
                if (!quarks.test(iTmfStateInterval.getAttribute()) || !times.intersects(iTmfStateInterval.getStartTime(), iTmfStateInterval.getEndTime())) continue;
                this.fCurrentIntervals.add(iTmfStateInterval);
            }
        }
        try {
            iterator = this.fCurrentIntervals;
            iPartialStateHistoryBackend = this.fBackend;
        }
        catch (Throwable throwable) {
            iPartialStateHistoryBackend = this.fBackend;
            synchronized (iPartialStateHistoryBackend) {
                this.fBackend.updateQueryType(false);
            }
            throw throwable;
        }
        synchronized (iPartialStateHistoryBackend) {
            this.fBackend.updateQueryType(false);
        }
        return iterator;
    }

    private boolean checkValidTime(long t) {
        return t >= this.getStartTime() && t <= this.getEndTime();
    }

    private void waitForCheckpoints() {
        try {
            this.fCheckpointsReady.await();
        }
        catch (InterruptedException interruptedException) {}
    }

    private class CheckpointsRequest
    extends TmfEventRequest {
        private final ITmfTrace trace;
        private final Map<Long, Long> checkpts;
        private long eventCount;
        private long lastCheckpointAt;

        public CheckpointsRequest(ITmfStateProvider input, Map<Long, Long> checkpoints) {
            super(ITmfEvent.class, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
            checkpoints.clear();
            this.trace = input.getTrace();
            this.checkpts = checkpoints;
            this.eventCount = 0L;
            this.lastCheckpointAt = 0L;
            checkpoints.put(input.getStartTime(), 0L);
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == this.trace) {
                ++this.eventCount;
                if (this.eventCount >= this.lastCheckpointAt + PartialHistoryBackend.this.fGranularity) {
                    this.checkpts.put(event.getTimestamp().getValue(), this.eventCount);
                    this.lastCheckpointAt = this.eventCount;
                }
            }
        }

        @Override
        public void handleCompleted() {
            super.handleCompleted();
            PartialHistoryBackend.this.fCheckpointsReady.countDown();
        }
    }

    private class PartialStateSystemRequest
    extends TmfEventRequest {
        private final ITmfStateProvider sci;
        private final ITmfTrace trace;

        PartialStateSystemRequest(ITmfStateProvider sci, TmfTimeRange range) {
            super(ITmfEvent.class, range, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.sci = sci;
            this.trace = sci.getTrace();
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == this.trace) {
                this.sci.processEvent(event);
            }
        }

        @Override
        public void handleCompleted() {
            if (PartialHistoryBackend.this.fPartialInput instanceof AbstractTmfStateProvider) {
                ((AbstractTmfStateProvider)PartialHistoryBackend.this.fPartialInput).waitForEmptyQueue();
            }
            super.handleCompleted();
        }
    }
}

