/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.AttributeUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.c.CBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.c.CParameter;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.PlatformObject;

public class CFunction
extends PlatformObject
implements IFunction,
ICInternalFunction {
    private IASTDeclarator[] declarators;
    private IASTFunctionDeclarator definition;
    private static final int FULLY_RESOLVED = 1;
    private static final int RESOLUTION_IN_PROGRESS = 2;
    private int bits;
    protected IFunctionType type;

    public CFunction(IASTDeclarator declarator) {
        this.storeDeclarator(declarator);
    }

    private void storeDeclarator(IASTDeclarator declarator) {
        if (declarator != null) {
            if (declarator instanceof ICASTKnRFunctionDeclarator) {
                this.definition = (IASTFunctionDeclarator)declarator;
            } else if (declarator instanceof IASTFunctionDeclarator && ASTQueries.findOutermostDeclarator(declarator).getParent() instanceof IASTFunctionDefinition) {
                this.definition = (IASTFunctionDeclarator)declarator;
            } else {
                this.declarators = ArrayUtil.append(IASTDeclarator.class, this.declarators, declarator);
            }
        }
    }

    @Override
    public IASTDeclarator getPhysicalNode() {
        if (this.definition != null) {
            return this.definition;
        }
        if (this.declarators != null && this.declarators.length > 0) {
            return this.declarators[0];
        }
        return null;
    }

    @Override
    public void addDeclarator(IASTDeclarator fnDeclarator) {
        if (!fnDeclarator.isActive()) {
            return;
        }
        if (fnDeclarator instanceof IASTFunctionDeclarator) {
            this.updateParameterBindings((IASTFunctionDeclarator)fnDeclarator);
        }
        this.storeDeclarator(fnDeclarator);
    }

    protected IASTTranslationUnit getTranslationUnit() {
        if (this.definition != null) {
            return this.definition.getTranslationUnit();
        }
        if (this.declarators != null) {
            return this.declarators[0].getTranslationUnit();
        }
        return null;
    }

    private void resolveAllDeclarations() {
        if ((this.bits & 3) == 0) {
            this.bits |= 2;
            IASTTranslationUnit tu = this.getTranslationUnit();
            if (tu != null) {
                CVisitor.getDeclarations(tu, this);
            }
            this.declarators = ArrayUtil.trim(IASTDeclarator.class, this.declarators);
            this.bits |= 1;
            this.bits &= 0xFFFFFFFD;
        }
    }

    @Override
    public IParameter[] getParameters() {
        int j = -1;
        int len = this.declarators != null ? this.declarators.length : 0;
        IASTDeclarator dtor = this.definition;
        while (j < len) {
            if (j >= 0) {
                dtor = this.declarators[j];
            }
            if (dtor instanceof IASTStandardFunctionDeclarator) {
                IASTParameterDeclaration[] params = ((IASTStandardFunctionDeclarator)dtor).getParameters();
                int size = params.length;
                IParameter[] result = new IParameter[size];
                if (size > 0) {
                    int i = 0;
                    while (i < size) {
                        IASTParameterDeclaration p = params[i];
                        result[i] = (IParameter)ASTQueries.findInnermostDeclarator(p.getDeclarator()).getName().resolveBinding();
                        ++i;
                    }
                    if (result.length == 1 && SemanticUtil.isVoidType(result[0].getType())) {
                        return IParameter.EMPTY_PARAMETER_ARRAY;
                    }
                }
                return result;
            }
            if (dtor instanceof ICASTKnRFunctionDeclarator) {
                IASTName[] names = ((ICASTKnRFunctionDeclarator)dtor).getParameterNames();
                IParameter[] result = new IParameter[names.length];
                if (names.length > 0) {
                    int i = 0;
                    while (i < names.length) {
                        IASTDeclarator decl = CVisitor.getKnRParameterDeclarator((ICASTKnRFunctionDeclarator)dtor, names[i]);
                        result[i] = decl != null ? (IParameter)decl.getName().resolveBinding() : new CParameter.CParameterProblem((IASTNode)names[i], 8, names[i].toCharArray());
                        ++i;
                    }
                }
                return result;
            }
            ++j;
        }
        if ((this.bits & 3) == 0) {
            this.resolveAllDeclarations();
            return this.getParameters();
        }
        return CBuiltinParameter.createParameterList(this.getType());
    }

    @Override
    public String getName() {
        return this.getASTName().toString();
    }

    @Override
    public char[] getNameCharArray() {
        return this.getASTName().toCharArray();
    }

    private IASTName getASTName() {
        return ASTQueries.findInnermostDeclarator(this.getPhysicalNode()).getName();
    }

    @Override
    public IScope getScope() {
        IASTDeclarator dtor = this.getPhysicalNode();
        if (dtor != null) {
            return CVisitor.getContainingScope(ASTQueries.findOutermostDeclarator(dtor).getParent());
        }
        return null;
    }

    @Override
    public IScope getFunctionScope() {
        if (this.definition != null) {
            IASTFunctionDefinition def = (IASTFunctionDefinition)this.definition.getParent();
            return def.getScope();
        }
        return null;
    }

    @Override
    public IFunctionType getType() {
        if (this.type == null) {
            this.type = this.createType();
        }
        return this.type;
    }

    protected IFunctionType createType() {
        IType tempType;
        IASTDeclarator declarator = this.getPhysicalNode();
        if (declarator == null && (this.bits & 1) == 0) {
            this.resolveAllDeclarations();
            declarator = this.getPhysicalNode();
        }
        if (declarator != null && (tempType = CVisitor.unwrapTypedefs(CVisitor.createType(declarator))) instanceof IFunctionType) {
            return (IFunctionType)tempType;
        }
        return null;
    }

    public IBinding resolveParameter(IASTName paramName) {
        IASTName[] ps;
        if (paramName.getBinding() != null) {
            return paramName.getBinding();
        }
        CParameter binding = null;
        int idx = 0;
        IASTNode parent = paramName.getParent();
        while (parent instanceof IASTDeclarator && !(parent instanceof ICASTKnRFunctionDeclarator)) {
            parent = parent.getParent();
        }
        ICASTKnRFunctionDeclarator fKnRDtor = null;
        IASTDeclarator knrParamDtor = null;
        if (parent instanceof IASTParameterDeclaration) {
            IASTStandardFunctionDeclarator fdtor = (IASTStandardFunctionDeclarator)parent.getParent();
            IASTParameterDeclaration[] ps2 = fdtor.getParameters();
            while (idx < ps2.length) {
                if (parent != ps2[idx]) {
                    ++idx;
                    continue;
                }
                break;
            }
        } else if (parent instanceof IASTSimpleDeclaration) {
            fKnRDtor = (ICASTKnRFunctionDeclarator)parent.getParent();
            ps = fKnRDtor.getParameterNames();
            char[] n = paramName.toCharArray();
            while (idx < ps.length) {
                if (!CharArrayUtils.equals(ps[idx].toCharArray(), n)) {
                    ++idx;
                    continue;
                }
                break;
            }
        } else {
            fKnRDtor = (ICASTKnRFunctionDeclarator)parent;
            ps = fKnRDtor.getParameterNames();
            while (idx < ps.length) {
                if (ps[idx] == paramName) break;
                ++idx;
            }
            knrParamDtor = CVisitor.getKnRParameterDeclarator(fKnRDtor, paramName);
            if (knrParamDtor != null) {
                paramName = knrParamDtor.getName();
            }
        }
        binding = new CParameter(paramName);
        IASTParameterDeclaration temp = null;
        if (this.definition != null) {
            IASTName[] parameterNames;
            if (this.definition instanceof IASTStandardFunctionDeclarator) {
                IASTParameterDeclaration[] parameters = ((IASTStandardFunctionDeclarator)this.definition).getParameters();
                if (parameters.length > idx) {
                    temp = parameters[idx];
                    ASTQueries.findInnermostDeclarator(temp.getDeclarator()).getName().setBinding(binding);
                }
            } else if (this.definition instanceof ICASTKnRFunctionDeclarator && (parameterNames = (fKnRDtor = (ICASTKnRFunctionDeclarator)this.definition).getParameterNames()).length > idx) {
                IASTName n = parameterNames[idx];
                n.setBinding(binding);
                IASTDeclarator dtor = CVisitor.getKnRParameterDeclarator(fKnRDtor, n);
                if (dtor != null) {
                    dtor.getName().setBinding(binding);
                }
            }
        }
        if (this.declarators != null) {
            IASTDeclarator[] iASTDeclaratorArray = this.declarators;
            int n = this.declarators.length;
            int n2 = 0;
            while (n2 < n) {
                IASTStandardFunctionDeclarator fdtor;
                IASTDeclarator dtor = iASTDeclaratorArray[n2];
                if (dtor instanceof IASTStandardFunctionDeclarator && (fdtor = (IASTStandardFunctionDeclarator)dtor).getParameters().length > idx) {
                    temp = fdtor.getParameters()[idx];
                    ASTQueries.findInnermostDeclarator(temp.getDeclarator()).getName().setBinding(binding);
                }
                ++n2;
            }
        }
        return binding;
    }

    protected void updateParameterBindings(IASTFunctionDeclarator fdtor) {
        IParameter[] params = this.getParameters();
        if (fdtor instanceof IASTStandardFunctionDeclarator) {
            IASTParameterDeclaration[] nps = ((IASTStandardFunctionDeclarator)fdtor).getParameters();
            if (params.length < nps.length) {
                return;
            }
            int i = 0;
            while (i < nps.length) {
                IASTName name = ASTQueries.findInnermostDeclarator(nps[i].getDeclarator()).getName();
                name.setBinding(params[i]);
                if (params[i] instanceof CParameter) {
                    ((CParameter)params[i]).addDeclaration(name);
                }
                ++i;
            }
        } else {
            IASTName[] ns = ((ICASTKnRFunctionDeclarator)fdtor).getParameterNames();
            if (params.length > 0 && params.length != ns.length) {
                return;
            }
            int i = 0;
            while (i < params.length) {
                IASTName name = ns[i];
                name.setBinding(params[i]);
                IASTDeclarator dtor = CVisitor.getKnRParameterDeclarator((ICASTKnRFunctionDeclarator)fdtor, name);
                if (dtor != null) {
                    dtor.getName().setBinding(params[i]);
                    if (params[i] instanceof CParameter) {
                        ((CParameter)params[i]).addDeclaration(dtor.getName());
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isStatic() {
        return this.isStatic(true);
    }

    @Override
    public boolean isStatic(boolean resolveAll) {
        if (resolveAll && (this.bits & 1) == 0) {
            this.resolveAllDeclarations();
        }
        return this.hasStorageClass(3);
    }

    public boolean hasStorageClass(int storage) {
        IASTDeclarator dtor = this.definition;
        IASTDeclarator[] ds = this.declarators;
        int i = -1;
        do {
            if (dtor == null) continue;
            IASTNode parent = dtor.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec == null || declSpec.getStorageClass() != storage) continue;
            return true;
        } while (ds != null && ++i < ds.length && (dtor = ds[i]) != null);
        return false;
    }

    @Override
    public boolean isExtern() {
        return this.isExtern(true);
    }

    public boolean isExtern(boolean resolveAll) {
        if (resolveAll && (this.bits & 1) == 0) {
            this.resolveAllDeclarations();
        }
        return this.hasStorageClass(2);
    }

    @Override
    public boolean isAuto() {
        if ((this.bits & 1) == 0) {
            this.resolveAllDeclarations();
        }
        return this.hasStorageClass(4);
    }

    @Override
    public boolean isRegister() {
        if ((this.bits & 1) == 0) {
            this.resolveAllDeclarations();
        }
        return this.hasStorageClass(5);
    }

    @Override
    public boolean isInline() {
        if ((this.bits & 1) == 0) {
            this.resolveAllDeclarations();
        }
        IASTDeclarator dtor = this.definition;
        IASTDeclarator[] ds = this.declarators;
        int i = -1;
        do {
            if (dtor == null) continue;
            IASTNode parent = dtor.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec == null || !declSpec.isInline()) continue;
            return true;
        } while (ds != null && ++i < ds.length && (dtor = ds[i]) != null);
        return false;
    }

    @Override
    public boolean takesVarArgs() {
        if ((this.bits & 1) == 0) {
            this.resolveAllDeclarations();
        }
        if (this.definition != null) {
            if (this.definition instanceof IASTStandardFunctionDeclarator) {
                return ((IASTStandardFunctionDeclarator)this.definition).takesVarArgs();
            }
            return false;
        }
        if (this.declarators != null) {
            IASTDeclarator[] iASTDeclaratorArray = this.declarators;
            int n = this.declarators.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator dtor = iASTDeclaratorArray[n2];
                if (dtor instanceof IASTStandardFunctionDeclarator) {
                    return ((IASTStandardFunctionDeclarator)dtor).takesVarArgs();
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public void setFullyResolved(boolean resolved) {
        this.bits = resolved ? (this.bits |= 1) : (this.bits &= 0xFFFFFFFE);
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }

    public IASTDeclarator[] getDeclarations() {
        return this.declarators;
    }

    @Override
    public IASTFunctionDeclarator getDefinition() {
        return this.definition;
    }

    @Override
    public IBinding getOwner() {
        return null;
    }

    @Override
    public boolean isNoReturn() {
        IASTFunctionDeclarator dtor = this.getPreferredDtor();
        return dtor != null && AttributeUtil.hasNoreturnAttribute(dtor);
    }

    protected IASTFunctionDeclarator getPreferredDtor() {
        IASTFunctionDeclarator dtor = this.getDefinition();
        if (dtor != null) {
            return dtor;
        }
        IASTDeclarator[] dtors = this.getDeclarations();
        if (dtors != null) {
            IASTDeclarator[] iASTDeclaratorArray = dtors;
            int n = dtors.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator declarator = iASTDeclaratorArray[n2];
                if (declarator instanceof IASTFunctionDeclarator) {
                    return (IASTFunctionDeclarator)declarator;
                }
                ++n2;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        IFunctionType t = this.getType();
        result.append(t != null ? ASTTypeUtil.getParameterTypeStringAndQualifiers(t) : "()");
        return result.toString();
    }
}

