/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vcpuview;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vcpuview.Messages;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vcpuview.VirtualMachineCommon;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vcpuview.VirtualMachineViewEntry;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

public class VirtualMachinePresentationProvider
extends TimeGraphPresentationProvider {
    private static final int ALPHA = 70;
    private static final List<StateItem> STATE_LIST = ImmutableList.of((Object)new StateItem(VCPUStyle.UNKNOWN.toMap()), (Object)new StateItem(VCPUStyle.IDLE.toMap()), (Object)new StateItem(VCPUStyle.USERMODE.toMap()), (Object)new StateItem(VCPUStyle.WAIT_VMM.toMap()), (Object)new StateItem(VCPUStyle.VCPU_PREEMPTED.toMap()), (Object)new StateItem(VCPUStyle.THREAD_UNKNOWN.toMap()), (Object)new StateItem(VCPUStyle.THREAD_WAIT_BLOCKED.toMap()), (Object)new StateItem(VCPUStyle.THREAD_WAIT_FOR_CPU.toMap()), (Object)new StateItem(VCPUStyle.THREAD_USERMODE.toMap()), (Object)new StateItem(VCPUStyle.THREAD_SYSCALL.toMap()), (Object)new StateItem(VCPUStyle.THREAD_INTERRUPTED.toMap()));
    private static final StateItem[] STATE_TABLE = STATE_LIST.toArray(new StateItem[STATE_LIST.size()]);

    private static VCPUStyle getStateForVcpu(int value) {
        if ((value & 0x100) > 0) {
            return VCPUStyle.VCPU_PREEMPTED;
        }
        if ((value & 0x80) > 0) {
            return VCPUStyle.WAIT_VMM;
        }
        if (value == 2) {
            return VCPUStyle.USERMODE;
        }
        if (value == 1) {
            return VCPUStyle.IDLE;
        }
        return VCPUStyle.UNKNOWN;
    }

    private static @Nullable VCPUStyle getStateForThread(int value) {
        if (value == 256) {
            return null;
        }
        switch (value) {
            case 2: {
                return VCPUStyle.THREAD_USERMODE;
            }
            case 3: {
                return VCPUStyle.THREAD_SYSCALL;
            }
            case 5: {
                return VCPUStyle.THREAD_WAIT_FOR_CPU;
            }
            case 1: {
                return VCPUStyle.THREAD_WAIT_BLOCKED;
            }
            case 4: {
                return VCPUStyle.THREAD_INTERRUPTED;
            }
            case 0: 
            case 6: {
                return VCPUStyle.THREAD_UNKNOWN;
            }
        }
        return null;
    }

    private static @Nullable VCPUStyle getEventState(TimeEvent event) {
        if (event.hasValue()) {
            VirtualMachineViewEntry entry = (VirtualMachineViewEntry)event.getEntry();
            int value = event.getValue();
            if (entry.getType() == VirtualMachineCommon.Type.VCPU) {
                return VirtualMachinePresentationProvider.getStateForVcpu(value);
            }
            if (entry.getType() == VirtualMachineCommon.Type.THREAD) {
                return VirtualMachinePresentationProvider.getStateForThread(value);
            }
        }
        return null;
    }

    public int getStateTableIndex(@Nullable ITimeEvent event) {
        if (event == null) {
            return -2;
        }
        VCPUStyle state = VirtualMachinePresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.ordinal();
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public @Nullable String getEventName(@Nullable ITimeEvent event) {
        if (event == null) {
            return null;
        }
        VCPUStyle state = VirtualMachinePresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.toString();
        }
        if (event instanceof NullTimeEvent) {
            return null;
        }
        return Messages.VmView_multipleStates;
    }

    public void postDrawEvent(@Nullable ITimeEvent event, @Nullable Rectangle bounds, @Nullable GC gc) {
        int value;
        VirtualMachineViewEntry entry;
        boolean visible;
        if (bounds == null || gc == null || !(event instanceof TimeEvent)) {
            return;
        }
        boolean bl = visible = bounds.width != 0;
        if (!visible) {
            return;
        }
        TimeEvent ev = (TimeEvent)event;
        if (ev.hasValue() && (entry = (VirtualMachineViewEntry)event.getEntry()).getType() == VirtualMachineCommon.Type.THREAD && ((value = ev.getValue()) & 0x100) != 0) {
            Color alphaColor = Display.getDefault().getSystemColor(3);
            int alpha = gc.getAlpha();
            Color background = gc.getBackground();
            gc.setBackground(alphaColor);
            gc.setAlpha(70);
            gc.fillRectangle(bounds);
            gc.setBackground(background);
            gc.setAlpha(alpha);
        }
    }

    static enum VCPUStyle {
        UNKNOWN(Messages.VcpuStyles_unknow, 83, 156, 83, 255, 1.0f),
        IDLE(Messages.VcpuStyles_idle, 200, 200, 200, 255, 0.66f),
        USERMODE(Messages.VcpuStyles_vcpuUsermode, 0, 200, 0, 255, 1.0f),
        WAIT_VMM(Messages.VcpuStyles_waitVmm, 179, 6, 6, 255, 0.66f),
        VCPU_PREEMPTED(Messages.VcpuStyles_vcpuPreempted, 207, 127, 47, 255, 0.5f),
        THREAD_UNKNOWN(Messages.VcpuStyles_wait, 200, 200, 200, 255, 0.5f),
        THREAD_WAIT_BLOCKED(Messages.VcpuStyles_waitBlocked, 200, 200, 0, 255, 0.5f),
        THREAD_WAIT_FOR_CPU(Messages.VcpuStyles_waitForCPU, 200, 100, 0, 255, 0.5f),
        THREAD_USERMODE(Messages.VcpuStyles_usermode, 0, 200, 0, 255, 1.0f),
        THREAD_SYSCALL(Messages.VcpuStyles_systemCall, 0, 0, 200, 255, 1.0f),
        THREAD_INTERRUPTED(Messages.VcpuStyles_Interrupt, 200, 0, 100, 255, 0.75f);

        private final Map<String, Object> fMap;

        private VCPUStyle(String label, int red, int green, int blue, int alpha, float heightFactor) {
            if (label == null) {
                throw new IllegalArgumentException("Label cannot be null");
            }
            if (red > 255 || red < 0) {
                throw new IllegalArgumentException("Red needs to be between 0 and 255");
            }
            if (green > 255 || green < 0) {
                throw new IllegalArgumentException("Green needs to be between 0 and 255");
            }
            if (blue > 255 || blue < 0) {
                throw new IllegalArgumentException("Blue needs to be between 0 and 255");
            }
            if (alpha > 255 || alpha < 0) {
                throw new IllegalArgumentException("alpha needs to be between 0 and 255");
            }
            if ((double)heightFactor > 1.0 || heightFactor < 0.0f) {
                throw new IllegalArgumentException("Height factor needs to be between 0 and 1.0, given hint : " + heightFactor);
            }
            this.fMap = ImmutableMap.of((Object)ITimeEventStyleStrings.label(), (Object)label, (Object)ITimeEventStyleStrings.fillStyle(), (Object)ITimeEventStyleStrings.solidColorFillStyle(), (Object)ITimeEventStyleStrings.fillColor(), (Object)new RGBAColor(red, green, blue, alpha).toInt(), (Object)ITimeEventStyleStrings.heightFactor(), (Object)Float.valueOf(heightFactor));
        }

        public String getLabel() {
            return (String)this.fMap.get(ITimeEventStyleStrings.label());
        }

        public Map<String, Object> toMap() {
            return this.fMap;
        }
    }
}

