/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.ConnectionEndpoint;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.NetworkConnection;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.RosMessagesTransportEventKey;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpLttngEventMatching;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfEventTypeCollectionHelper;

public class RosMessagesTransportEventMatching
extends TcpLttngEventMatching {
    private static final @NonNull String[] FIELD_PATH_TO_SADDR = new String[]{"network_header", "Any", "saddr"};
    private static final @NonNull String[] FIELD_PATH_TO_DADDR = new String[]{"network_header", "Any", "daddr"};
    private static final @NonNull String[] FIELD_PATH_TO_SOURCE_PORT = new String[]{"network_header", "Any", "transport_header", "tcp", "source_port"};
    private static final @NonNull String[] FIELD_PATH_TO_DEST_PORT = new String[]{"network_header", "Any", "transport_header", "tcp", "dest_port"};
    private static final Map<IKernelAnalysisEventLayout, Set<String>> REQUIRED_EVENTS = new HashMap<IKernelAnalysisEventLayout, Set<String>>();
    private static final Map<ITmfTrace, IKernelAnalysisEventLayout> TRACE_LAYOUTS = new WeakHashMap<ITmfTrace, IKernelAnalysisEventLayout>();

    public boolean canMatchTrace(ITmfTrace trace) {
        if (!(trace instanceof IKernelTrace)) {
            return false;
        }
        IKernelAnalysisEventLayout layout = ((IKernelTrace)trace).getKernelEventLayout();
        TRACE_LAYOUTS.put(trace, layout);
        Set<String> events = REQUIRED_EVENTS.get(layout);
        if (events == null) {
            events = new HashSet<String>();
            events.addAll(layout.eventsNetworkSend());
            events.addAll(layout.eventsNetworkReceive());
            REQUIRED_EVENTS.put(layout, events);
        }
        if (!(trace instanceof ITmfTraceWithPreDefinedEvents)) {
            return true;
        }
        ITmfTraceWithPreDefinedEvents ktrace = (ITmfTraceWithPreDefinedEvents)trace;
        Set traceEvents = TmfEventTypeCollectionHelper.getEventNames((Iterable)ktrace.getContainedEventTypes());
        traceEvents.retainAll(events);
        return !traceEvents.isEmpty();
    }

    public IEventMatchingKey getEventKey(ITmfEvent event) {
        IKernelAnalysisEventLayout layout = TRACE_LAYOUTS.get(event.getTrace());
        if (layout == null) {
            return null;
        }
        TmfEventField content = (TmfEventField)event.getContent();
        Long sequence = (Long)content.getFieldValue(Long.class, layout.fieldPathTcpSeq());
        Long ack = (Long)content.getFieldValue(Long.class, layout.fieldPathTcpAckSeq());
        Long flags = (Long)content.getFieldValue(Long.class, layout.fieldPathTcpFlags());
        long[] saddr = (long[])content.getFieldValue(long[].class, FIELD_PATH_TO_SADDR);
        Long sport = (Long)content.getFieldValue(Long.class, FIELD_PATH_TO_SOURCE_PORT);
        long[] daddr = (long[])content.getFieldValue(long[].class, FIELD_PATH_TO_DADDR);
        Long dport = (Long)content.getFieldValue(Long.class, FIELD_PATH_TO_DEST_PORT);
        if (sequence == null || ack == null || flags == null || saddr == null || sport == null || daddr == null || dport == null) {
            return null;
        }
        ConnectionEndpoint sourceEndpoint = new ConnectionEndpoint(saddr, sport);
        ConnectionEndpoint destinationEndpoint = new ConnectionEndpoint(daddr, dport);
        NetworkConnection connection = new NetworkConnection(sourceEndpoint, destinationEndpoint);
        return new RosMessagesTransportEventKey(sequence, ack, flags, connection);
    }
}

