/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.callstack.core.base;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.ITree;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackGroupDescriptor;

public class CallStackElement
implements ICallStackElement {
    public static final int DEFAULT_SYMBOL_KEY = -1;
    private final String fName;
    private final ICallStackGroupDescriptor fDescriptor;
    private final @Nullable ICallStackGroupDescriptor fNextDescriptor;
    private final Collection<ICallStackElement> fChildren = new ArrayList<ICallStackElement>();
    private final @Nullable ICallStackElement fParent;
    private @Nullable ICallStackElement fSymbolKeyElement = null;

    public CallStackElement(String name, ICallStackGroupDescriptor descriptor) {
        this(name, descriptor, null, null);
    }

    public CallStackElement(String name, ICallStackGroupDescriptor descriptor, @Nullable ICallStackGroupDescriptor nextGroup, @Nullable ICallStackElement parent) {
        this.fName = name;
        this.fDescriptor = descriptor;
        this.fParent = parent;
        this.fNextDescriptor = nextGroup;
        if (parent instanceof CallStackElement) {
            this.fSymbolKeyElement = ((CallStackElement)parent).fSymbolKeyElement;
        }
    }

    @Override
    public Collection<ICallStackElement> getChildrenElements() {
        return this.fChildren;
    }

    @Override
    public void addChild(ICallStackElement node) {
        this.fChildren.add(node);
    }

    @Override
    public ICallStackGroupDescriptor getGroup() {
        return this.fDescriptor;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public boolean isLeaf() {
        return this.fNextDescriptor == null;
    }

    @Override
    public @Nullable ICallStackGroupDescriptor getNextGroup() {
        return this.fNextDescriptor;
    }

    @Override
    public void setSymbolKeyElement(ICallStackElement element) {
        this.fSymbolKeyElement = element;
    }

    @Override
    public boolean isSymbolKeyElement() {
        return this.fSymbolKeyElement == this;
    }

    @Override
    public final int getSymbolKeyAt(long startTime) {
        int processId = -1;
        if (this.isSymbolKeyElement()) {
            return this.retrieveSymbolKeyAt(startTime);
        }
        ICallStackElement symbolKeyElement = this.fSymbolKeyElement;
        if (symbolKeyElement == null) {
            return processId;
        }
        return symbolKeyElement.getSymbolKeyAt(startTime);
    }

    protected int retrieveSymbolKeyAt(long time) {
        return -1;
    }

    @Override
    public @Nullable ICallStackElement getParentElement() {
        return this.fParent;
    }

    public String toString() {
        return this.getName();
    }

    public String getObject() {
        return this.getName();
    }

    public @Nullable ITree<String> getParent() {
        return this.fParent;
    }

    public Collection<ITree<String>> getChildren() {
        ArrayList<ITree<String>> list = new ArrayList<ITree<String>>();
        list.addAll(this.fChildren);
        return list;
    }
}

