/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.counter;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.Activator;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.event.TraceEventEvent;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.event.TraceEventField;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TraceEventCounterStateProvider
extends AbstractTmfStateProvider {
    private static final @NonNull String ID = "org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.counter";

    public static @NonNull ITmfStateProvider createTraceEventCounterStateProvider(@Nullable ITmfTrace trace) {
        return new TraceEventCounterStateProvider(Objects.requireNonNull(trace));
    }

    public TraceEventCounterStateProvider(@NonNull ITmfTrace trace) {
        super(trace, ID);
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        ITmfStateSystemBuilder ss = this.getStateSystemBuilder();
        if (ss == null || !(event instanceof TraceEventEvent)) {
            return;
        }
        TraceEventField fields = ((TraceEventEvent)event).getField();
        if (fields.getPhase() != 'C') {
            return;
        }
        Map<@NonNull String, @NonNull Object> data = fields.getArgs();
        if (data != null) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                try {
                    Double dbl;
                    String valueOf;
                    Object entryValue = Objects.requireNonNull(entry.getValue());
                    Long value = null;
                    if (entryValue instanceof Number) {
                        value = ((Number)entryValue).longValue();
                    }
                    if ((value = Longs.tryParse((String)(valueOf = String.valueOf(entryValue)))) == null && (dbl = Doubles.tryParse((String)valueOf)) != null) {
                        value = dbl.longValue();
                    }
                    if (value == null) continue;
                    int ungroupQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Ungrouped"});
                    int ungroupValQuark = ss.getQuarkRelativeAndAdd(ungroupQuark, new String[]{entry.getKey()});
                    StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ss, (long)event.getTimestamp().toNanos(), (int)ungroupValQuark, (long)value);
                    int groupQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Grouped"});
                    groupQuark = ss.getQuarkRelativeAndAdd(groupQuark, new String[]{"PID", String.valueOf(fields.getPid())});
                    groupQuark = ss.getQuarkRelativeAndAdd(groupQuark, new String[]{"TID", String.valueOf(fields.getTid())});
                    groupQuark = ss.getQuarkRelativeAndAdd(groupQuark, new String[]{"Name", String.valueOf(fields.getName())});
                    groupQuark = ss.getQuarkRelativeAndAdd(groupQuark, new String[]{entry.getKey()});
                    StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ss, (long)event.getTimestamp().toNanos(), (int)groupQuark, (long)value);
                }
                catch (AttributeNotFoundException | StateValueTypeException e) {
                    Activator.getInstance().logError("error in counters analysis", e);
                }
            }
        }
    }

    public int getVersion() {
        return 1;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return TraceEventCounterStateProvider.createTraceEventCounterStateProvider(this.getTrace());
    }
}

