/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.weighted.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTree;

public final class WeightedTreeUtils {
    private WeightedTreeUtils() {
    }

    public static <T> Collection<DifferentialWeightedTree<T>> diffTrees(Collection<WeightedTree<T>> first, Collection<WeightedTree<T>> second) {
        ArrayList<DifferentialWeightedTree<T>> diffTrees = new ArrayList<DifferentialWeightedTree<T>>();
        for (WeightedTree<T> base : second) {
            T object = base.getObject();
            WeightedTree<T> other = WeightedTreeUtils.findObject(first, object);
            double diffWeight = other == null ? Double.NaN : (double)(base.getWeight() - other.getWeight()) / (double)other.getWeight();
            DifferentialWeightedTree<@NonNull T> diffTree = new DifferentialWeightedTree<T>(base, object, base.getWeight(), diffWeight);
            diffTrees.add(diffTree);
            for (DifferentialWeightedTree<T> childTree : WeightedTreeUtils.diffTrees(other == null ? Collections.emptyList() : other.getChildren(), base.getChildren())) {
                diffTree.addChild(childTree);
            }
        }
        return diffTrees;
    }

    private static <T> @Nullable WeightedTree<T> findObject(Collection<WeightedTree<T>> tree, @NonNull T object) {
        for (WeightedTree<T> other : tree) {
            if (!other.getObject().equals(object)) continue;
            return other;
        }
        return null;
    }
}

