/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.contentmergeviewer.IFlushable;
import org.eclipse.compare.internal.BinaryCompareViewer;
import org.eclipse.compare.internal.ChangePropertyAction;
import org.eclipse.compare.internal.CompareContentViewerSwitchingPane;
import org.eclipse.compare.internal.CompareEditorInputNavigator;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareStructureViewerSwitchingPane;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.compare.internal.IFlushable2;
import org.eclipse.compare.internal.OutlineViewerCreator;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.ViewerDescriptor;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public abstract class CompareEditorInput
extends PlatformObject
implements IEditorInput,
IPropertyChangeNotifier,
IRunnableWithProgress,
ICompareContainer {
    private static final boolean DEBUG = false;
    public static final String DIRTY_STATE = "DIRTY_STATE";
    public static final String PROP_TITLE = ICompareUIConstants.PROP_TITLE;
    public static final String PROP_TITLE_IMAGE = ICompareUIConstants.PROP_TITLE_IMAGE;
    public static final String PROP_SELECTED_EDITION = ICompareUIConstants.PROP_SELECTED_EDITION;
    private static final String COMPARE_EDITOR_IMAGE_NAME = "eview16/compare_view.png";
    private static Image fgTitleImage;
    private Splitter fComposite;
    private CompareConfiguration fCompareConfiguration;
    private CompareViewerPane fStructureInputPane;
    private CompareViewerSwitchingPane fStructurePane1;
    private CompareViewerSwitchingPane fStructurePane2;
    private CompareViewerSwitchingPane fContentInputPane;
    private CompareViewerPane fFocusPane;
    private String fMessage;
    private Object fInput;
    private String fTitle;
    private ListenerList<IPropertyChangeListener> fListenerList = new ListenerList();
    private CompareNavigator fNavigator;
    private boolean fLeftDirty;
    private boolean fRightDirty;
    private IPropertyChangeListener fDirtyStateListener;
    boolean fStructureCompareOnSingleClick = true;
    private ICompareContainer fContainer;
    private boolean fContainerProvided;
    private String fHelpContextId;
    private InternalOutlineViewerCreator fOutlineView;
    private ViewerDescriptor fContentViewerDescriptor;
    private ViewerDescriptor fStructureViewerDescriptor;

    public CompareEditorInput(CompareConfiguration configuration) {
        this.fCompareConfiguration = configuration;
        Assert.isNotNull((Object)configuration);
        this.fDirtyStateListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getProperty();
                if (CompareEditorInput.DIRTY_STATE.equals(propertyName)) {
                    boolean changed = false;
                    Object newValue = e.getNewValue();
                    if (newValue instanceof Boolean) {
                        changed = (Boolean)newValue;
                    }
                    CompareEditorInput.this.setDirty(e.getSource(), changed);
                }
            }
        };
        IPreferenceStore ps = configuration.getPreferenceStore();
        if (ps != null) {
            this.fStructureCompareOnSingleClick = ps.getBoolean("org.eclipse.compare.OpenStructureCompare");
        }
        this.fContainer = configuration.getContainer();
        configuration.setContainer(this);
    }

    private boolean structureCompareOnSingleClick() {
        return this.fStructureCompareOnSingleClick;
    }

    private boolean isShowStructureInOutlineView() {
        Object object = this.getCompareConfiguration().getProperty("USE_OUTLINE_VIEW");
        return object instanceof Boolean && (Boolean)object != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAdapter(Class<T> adapter) {
        Viewer v;
        Object file;
        if (ICompareNavigator.class.equals(adapter) || CompareNavigator.class.equals(adapter)) {
            return (T)this.getNavigator();
        }
        if (adapter == IShowInSource.class && (file = (IFile)Adapters.adapt((Object)this, IFile.class)) != null) {
            return (T)new IShowInSource((IFile)file){
                private final /* synthetic */ IFile val$file;
                {
                    this.val$file = iFile;
                }

                public ShowInContext getShowInContext() {
                    return new ShowInContext((Object)new FileEditorInput(this.val$file), (ISelection)StructuredSelection.EMPTY);
                }
            };
        }
        if (adapter == OutlineViewerCreator.class) {
            file = this;
            synchronized (file) {
                if (this.fOutlineView == null) {
                    this.fOutlineView = new InternalOutlineViewerCreator();
                }
                return (T)this.fOutlineView;
            }
        }
        if (adapter == IFindReplaceTarget.class && this.fContentInputPane != null && (v = this.fContentInputPane.getViewer()) != null) {
            return (T)Adapters.adapt((Object)v, IFindReplaceTarget.class);
        }
        if (adapter == IEditorInput.class && this.fContentInputPane != null && (v = this.fContentInputPane.getViewer()) != null) {
            return (T)Adapters.adapt((Object)v, IEditorInput.class);
        }
        if (adapter == ITextEditorExtension3.class && this.fContentInputPane != null && (v = this.fContentInputPane.getViewer()) != null) {
            return (T)Adapters.adapt((Object)v, ITextEditorExtension3.class);
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public synchronized ICompareNavigator getNavigator() {
        if (this.fNavigator == null) {
            this.fNavigator = new CompareEditorInputNavigator(new Object[]{this.fStructureInputPane, this.fStructurePane1, this.fStructurePane2, this.fContentInputPane});
        }
        return this.fNavigator;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getToolTipText() {
        return this.getTitle();
    }

    public String getName() {
        return this.getTitle();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public boolean exists() {
        return false;
    }

    protected void setMessage(String message) {
        this.fMessage = message;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public String getTitle() {
        if (this.fTitle == null) {
            return Utilities.getString("CompareEditorInput.defaultTitle");
        }
        return this.fTitle;
    }

    public void setTitle(String title) {
        String oldTitle = this.fTitle;
        this.fTitle = title;
        Utilities.firePropertyChange(this.fListenerList, this, PROP_TITLE, oldTitle, title);
    }

    public Image getTitleImage() {
        if (fgTitleImage == null) {
            fgTitleImage = CompareUIPlugin.getImageDescriptor(COMPARE_EDITOR_IMAGE_NAME).createImage();
            CompareUI.disposeOnShutdown(fgTitleImage);
        }
        return fgTitleImage;
    }

    public CompareConfiguration getCompareConfiguration() {
        return this.fCompareConfiguration;
    }

    public void contributeToToolBar(ToolBarManager toolBarManager) {
        ResourceBundle bundle = CompareUI.getResourceBundle();
        ChangePropertyAction ignoreWhitespace = ChangePropertyAction.createIgnoreWhiteSpaceAction(bundle, this.getCompareConfiguration());
        toolBarManager.getControl().addDisposeListener((DisposeListener)ignoreWhitespace);
        ChangePropertyAction showPseudoConflicts = ChangePropertyAction.createShowPseudoConflictsAction(bundle, this.getCompareConfiguration());
        toolBarManager.getControl().addDisposeListener((DisposeListener)showPseudoConflicts);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)ignoreWhitespace);
        toolBarManager.add((IAction)showPseudoConflicts);
    }

    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        this.fInput = this.prepareInput(monitor);
    }

    protected abstract Object prepareInput(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    public Object getCompareResult() {
        return this.fInput;
    }

    public Control createContents(Composite parent) {
        this.fComposite = new Splitter(parent, 512);
        this.fComposite.setData(this);
        Control outline = this.createOutlineContents((Composite)this.fComposite, 256);
        this.fContentInputPane = this.createContentViewerSwitchingPane(this.fComposite, 0x800800, this);
        if (this.fFocusPane == null) {
            this.fFocusPane = this.fContentInputPane;
        }
        if (outline != null) {
            this.fComposite.setVisible(outline, false);
        }
        this.fComposite.setVisible((Control)this.fContentInputPane, true);
        if (this.fStructureInputPane != null && this.fComposite.getChildren().length == 2) {
            this.fComposite.setWeights(new int[]{30, 70});
        }
        this.feedInput();
        parent.requestLayout();
        this.fComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Composite composite;
                Composite control = composite = (Composite)e.widget;
                while (composite.getChildren().length > 0) {
                    control = composite.getChildren()[composite.getChildren().length - 1];
                    if (!(control instanceof Composite)) break;
                    composite = control;
                }
                control.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent ev) {
                        CompareEditorInput.this.handleDispose();
                    }
                });
            }
        });
        if (this.fHelpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fComposite, this.fHelpContextId);
        }
        this.contentsCreated();
        return this.fComposite;
    }

    protected CompareViewerSwitchingPane createContentViewerSwitchingPane(Splitter parent, int style, CompareEditorInput cei) {
        return new CompareContentViewerSwitchingPane(parent, style, cei);
    }

    protected void handleDispose() {
        this.fContainerProvided = false;
        this.fContainer = null;
        this.fComposite = null;
        this.fStructureInputPane = null;
        this.fStructurePane1 = null;
        this.fStructurePane2 = null;
        this.fContentInputPane = null;
        this.fFocusPane = null;
        this.fNavigator = null;
        this.fCompareConfiguration.dispose();
    }

    protected void contentsCreated() {
    }

    public Control createOutlineContents(Composite parent, int direction) {
        Splitter h = new Splitter(parent, direction);
        this.fStructureInputPane = this.createStructureInputPane((Composite)h);
        if (this.hasChildren(this.getCompareResult())) {
            this.fFocusPane = this.fStructureInputPane;
        }
        this.fStructurePane1 = new CompareStructureViewerSwitchingPane((Composite)h, 0x800800, true, this);
        h.setVisible((Control)this.fStructurePane1, false);
        this.fStructurePane2 = new CompareStructureViewerSwitchingPane((Composite)h, 0x800800, true, this);
        h.setVisible((Control)this.fStructurePane2, false);
        this.fStructureInputPane.addOpenListener(new IOpenListener(){

            public void open(OpenEvent oe) {
                CompareEditorInput.this.feed1(oe.getSelection());
            }
        });
        this.fStructureInputPane.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ISelection s = e.getSelection();
                if (s == null || s.isEmpty()) {
                    CompareEditorInput.this.feed1(s);
                }
                if (CompareEditorInput.this.isEditionSelectionDialog()) {
                    CompareEditorInput.this.firePropertyChange(new PropertyChangeEvent((Object)this, PROP_SELECTED_EDITION, null, CompareEditorInput.this.getSelectedEdition()));
                }
            }
        });
        this.fStructureInputPane.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CompareEditorInput.this.feedDefault1(event.getSelection());
            }
        });
        this.fStructurePane1.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CompareEditorInput.this.feed2(e.getSelection());
            }
        });
        this.fStructurePane2.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CompareEditorInput.this.feed3(e.getSelection());
            }
        });
        return h;
    }

    protected CompareViewerPane createStructureInputPane(Composite parent) {
        return new CompareStructureViewerSwitchingPane(parent, 0x800800, true, this){

            @Override
            protected Viewer getViewer(Viewer oldViewer, Object input) {
                if (CompareEditorInput.this.hasChildren(input)) {
                    return CompareEditorInput.this.createDiffViewer((Composite)this);
                }
                return super.getViewer(oldViewer, input);
            }
        };
    }

    boolean hasChildren(Object input) {
        if (input instanceof IDiffContainer) {
            IDiffContainer dn = (IDiffContainer)input;
            return dn.hasChildren();
        }
        return false;
    }

    private void feedInput() {
        if (this.fStructureInputPane != null && (this.fInput instanceof ICompareInput || this.isCustomStructureInputPane())) {
            if (this.hasChildren(this.fInput) || this.isCustomStructureInputPane()) {
                this.fStructureInputPane.setInput(this.fInput);
            } else if (!this.structureCompareOnSingleClick() || this.isShowStructureInOutlineView()) {
                this.internalSetContentPaneInput(this.fInput);
                if (this.hasUnusableContentViewer() || this.structureCompareOnSingleClick() && this.isShowStructureInOutlineView() && !this.hasOutlineViewer(this.fInput)) {
                    this.fStructureInputPane.setInput(this.fInput);
                }
            } else {
                this.fStructureInputPane.setInput(this.fInput);
            }
            ISelection sel = this.fStructureInputPane.getSelection();
            if (sel == null || sel.isEmpty()) {
                this.feed1(sel);
            }
        }
    }

    private boolean hasOutlineViewer(Object input) {
        if (!this.isShowStructureInOutlineView()) {
            return false;
        }
        OutlineViewerCreator creator = this.getAdapter(OutlineViewerCreator.class);
        if (creator != null) {
            return creator.hasViewerFor(input);
        }
        return false;
    }

    private boolean hasUnusableContentViewer() {
        return this.fContentInputPane.isEmpty() || this.fContentInputPane.getViewer() instanceof BinaryCompareViewer;
    }

    private boolean isCustomStructureInputPane() {
        return !(this.fStructureInputPane instanceof CompareViewerSwitchingPane);
    }

    private void feed1(final ISelection selection) {
        BusyIndicator.showWhile((Display)this.fComposite.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (selection == null || selection.isEmpty()) {
                    Object input = CompareEditorInput.this.fStructureInputPane.getInput();
                    if (input != null) {
                        CompareEditorInput.this.internalSetContentPaneInput(input);
                    }
                    if (!Utilities.okToUse((Widget)CompareEditorInput.this.fStructurePane1) || !Utilities.okToUse((Widget)CompareEditorInput.this.fStructurePane2)) {
                        return;
                    }
                    CompareEditorInput.this.fStructurePane2.setInput(null);
                    CompareEditorInput.this.fStructurePane1.setInput(null);
                } else {
                    Object input = CompareEditorInput.getElement(selection);
                    CompareEditorInput.this.internalSetContentPaneInput(input);
                    if (!Utilities.okToUse((Widget)CompareEditorInput.this.fStructurePane1) || !Utilities.okToUse((Widget)CompareEditorInput.this.fStructurePane2)) {
                        return;
                    }
                    if (CompareEditorInput.this.structureCompareOnSingleClick() || CompareEditorInput.this.hasUnusableContentViewer()) {
                        CompareEditorInput.this.fStructurePane1.setInput(input);
                    }
                    CompareEditorInput.this.fStructurePane2.setInput(null);
                    if (CompareEditorInput.this.fStructurePane1.getInput() != input) {
                        CompareEditorInput.this.fStructurePane1.setInput(null);
                    }
                }
            }
        });
    }

    private void feedDefault1(final ISelection selection) {
        BusyIndicator.showWhile((Display)this.fComposite.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!selection.isEmpty()) {
                    CompareEditorInput.this.fStructurePane1.setInput(CompareEditorInput.getElement(selection));
                }
            }
        });
    }

    private void feed2(final ISelection selection) {
        BusyIndicator.showWhile((Display)this.fComposite.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (selection.isEmpty()) {
                    Object input = CompareEditorInput.this.fStructurePane1.getInput();
                    CompareEditorInput.this.internalSetContentPaneInput(input);
                    CompareEditorInput.this.fStructurePane2.setInput(null);
                } else {
                    Object input = CompareEditorInput.getElement(selection);
                    CompareEditorInput.this.internalSetContentPaneInput(input);
                    CompareEditorInput.this.fStructurePane2.setInput(input);
                }
            }
        });
    }

    private void feed3(final ISelection selection) {
        BusyIndicator.showWhile((Display)this.fComposite.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (selection.isEmpty()) {
                    CompareEditorInput.this.internalSetContentPaneInput(CompareEditorInput.this.fStructurePane2.getInput());
                } else {
                    CompareEditorInput.this.internalSetContentPaneInput(CompareEditorInput.getElement(selection));
                }
            }
        });
    }

    private void internalSetContentPaneInput(Object input) {
        Object oldInput = this.fContentInputPane.getInput();
        this.fContentInputPane.setInput(input);
        if (this.fOutlineView != null) {
            this.fOutlineView.fireInputChange(oldInput, input);
        }
    }

    private static Object getElement(ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            return ss.getFirstElement();
        }
        return null;
    }

    @Deprecated
    public void setFocus() {
        this.setFocus2();
    }

    public boolean setFocus2() {
        if (this.fFocusPane != null) {
            return this.fFocusPane.setFocus();
        }
        if (this.fComposite != null) {
            return this.fComposite.setFocus();
        }
        return false;
    }

    public Viewer createDiffViewer(Composite parent) {
        return new DiffTreeViewer(parent, this.fCompareConfiguration);
    }

    public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        return this.fStructureViewerDescriptor != null ? this.fStructureViewerDescriptor.createViewer(oldViewer, parent, this.fCompareConfiguration) : CompareUI.findStructureViewer(oldViewer, input, parent, this.fCompareConfiguration);
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        boolean isNewViewer;
        Viewer newViewer = this.fContentViewerDescriptor != null ? this.fContentViewerDescriptor.createViewer(oldViewer, parent, this.fCompareConfiguration) : CompareUI.findContentViewer(oldViewer, input, parent, this.fCompareConfiguration);
        boolean bl = isNewViewer = newViewer != oldViewer;
        if (isNewViewer && newViewer instanceof IPropertyChangeNotifier) {
            final IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)newViewer;
            dsp.addPropertyChangeListener(this.fDirtyStateListener);
            Control c = newViewer.getControl();
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dsp.removePropertyChangeListener(CompareEditorInput.this.fDirtyStateListener);
                }
            });
        }
        return newViewer;
    }

    public void setContentViewerDescriptor(ViewerDescriptor vd) {
        this.fContentViewerDescriptor = vd;
    }

    public ViewerDescriptor getContentViewerDescriptor() {
        return this.fContentViewerDescriptor;
    }

    public void setStructureViewerDescriptor(ViewerDescriptor vd) {
        this.fStructureViewerDescriptor = vd;
    }

    public ViewerDescriptor getStructureViewerDescriptor() {
        return this.fStructureViewerDescriptor;
    }

    public boolean isSaveNeeded() {
        return this.isLeftSaveNeeded() || this.isRightSaveNeeded();
    }

    protected boolean isLeftSaveNeeded() {
        return this.fLeftDirty;
    }

    protected boolean isRightSaveNeeded() {
        return this.fRightDirty;
    }

    public boolean isDirty() {
        return this.isSaveNeeded();
    }

    public void setDirty(boolean dirty) {
        boolean oldDirty = this.isSaveNeeded();
        this.fLeftDirty = dirty;
        this.fRightDirty = dirty;
        if (oldDirty != this.isSaveNeeded()) {
            Utilities.firePropertyChange(this.fListenerList, this, DIRTY_STATE, oldDirty, this.isSaveNeeded());
        }
    }

    protected void setLeftDirty(boolean dirty) {
        boolean oldDirty = this.isSaveNeeded();
        this.fLeftDirty = dirty;
        if (oldDirty != this.isSaveNeeded()) {
            Utilities.firePropertyChange(this.fListenerList, this, DIRTY_STATE, oldDirty, this.isSaveNeeded());
        }
    }

    protected void setRightDirty(boolean dirty) {
        boolean oldDirty = this.isSaveNeeded();
        this.fRightDirty = dirty;
        if (oldDirty != this.isSaveNeeded()) {
            Utilities.firePropertyChange(this.fListenerList, this, DIRTY_STATE, oldDirty, this.isSaveNeeded());
        }
    }

    private void setDirty(Object source, boolean dirty) {
        boolean newDirty;
        Assert.isNotNull((Object)source);
        boolean oldDirty = this.isSaveNeeded();
        if (source instanceof ContentMergeViewer) {
            ContentMergeViewer cmv = (ContentMergeViewer)source;
            if (dirty == cmv.internalIsLeftDirty()) {
                this.fLeftDirty = cmv.internalIsLeftDirty();
            }
            if (dirty == cmv.internalIsRightDirty()) {
                this.fRightDirty = cmv.internalIsRightDirty();
            }
        } else {
            this.fLeftDirty = dirty;
        }
        if (oldDirty != (newDirty = this.isSaveNeeded())) {
            Utilities.firePropertyChange(this.fListenerList, this, DIRTY_STATE, oldDirty, newDirty);
        }
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.fListenerList.add((Object)listener);
        }
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fListenerList != null) {
            this.fListenerList.remove((Object)listener);
        }
    }

    @Deprecated
    public void save(IProgressMonitor pm) {
    }

    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        this.flushViewers(monitor);
        this.save(monitor);
    }

    protected void flushViewers(IProgressMonitor monitor) {
        CompareEditorInput.flushViewer(this.fStructureInputPane, monitor);
        CompareEditorInput.flushViewer(this.fStructurePane1, monitor);
        CompareEditorInput.flushViewer(this.fStructurePane2, monitor);
        CompareEditorInput.flushViewer(this.fContentInputPane, monitor);
    }

    protected void flushLeftViewers(IProgressMonitor monitor) {
        CompareEditorInput.flushViewer(this.fStructureInputPane, monitor);
        CompareEditorInput.flushViewer(this.fStructurePane1, monitor);
        CompareEditorInput.flushViewer(this.fStructurePane2, monitor);
        CompareEditorInput.flushLeftViewer(this.fContentInputPane, monitor);
    }

    protected void flushRightViewers(IProgressMonitor monitor) {
        CompareEditorInput.flushViewer(this.fStructureInputPane, monitor);
        CompareEditorInput.flushViewer(this.fStructurePane1, monitor);
        CompareEditorInput.flushViewer(this.fStructurePane2, monitor);
        CompareEditorInput.flushRightViewer(this.fContentInputPane, monitor);
    }

    private static void flushViewer(CompareViewerPane pane, IProgressMonitor pm) {
        IFlushable flushable;
        if (pane != null && (flushable = (IFlushable)Adapters.adapt((Object)((Object)pane), IFlushable.class)) != null) {
            flushable.flush(pm);
        }
    }

    private static void flushLeftViewer(CompareViewerPane pane, IProgressMonitor pm) {
        IFlushable2 flushable;
        if (pane != null && (flushable = (IFlushable2)Adapters.adapt((Object)((Object)pane), IFlushable2.class)) != null) {
            flushable.flushLeft(pm);
        }
    }

    private static void flushRightViewer(CompareViewerPane pane, IProgressMonitor pm) {
        IFlushable2 flushable;
        if (pane != null && (flushable = (IFlushable2)Adapters.adapt((Object)((Object)pane), IFlushable2.class)) != null) {
            flushable.flushRight(pm);
        }
    }

    @Override
    public void addCompareInputChangeListener(ICompareInput input, ICompareInputChangeListener listener) {
        if (this.fContainer == null) {
            input.addCompareInputChangeListener(listener);
        } else {
            this.fContainer.addCompareInputChangeListener(input, listener);
        }
    }

    @Override
    public void removeCompareInputChangeListener(ICompareInput input, ICompareInputChangeListener listener) {
        if (this.fContainer == null) {
            input.removeCompareInputChangeListener(listener);
        } else {
            this.fContainer.removeCompareInputChangeListener(input, listener);
        }
    }

    @Override
    public void registerContextMenu(MenuManager menu, ISelectionProvider selectionProvider) {
        if (this.fContainer != null) {
            this.fContainer.registerContextMenu(menu, selectionProvider);
        }
    }

    @Override
    public void setStatusMessage(String message) {
        if (!this.fContainerProvided) {
            IStatusLineManager slm;
            IActionBars actionBars = this.getActionBars();
            if (actionBars != null && (slm = actionBars.getStatusLineManager()) != null) {
                slm.setMessage(message);
            }
        } else if (this.fContainer != null) {
            this.fContainer.setStatusMessage(message);
        }
    }

    @Override
    public IActionBars getActionBars() {
        if (this.fContainer != null) {
            IActionBars actionBars = this.fContainer.getActionBars();
            if (actionBars == null && !this.fContainerProvided) {
                return Utilities.findActionBars((Control)this.fComposite);
            }
            return actionBars;
        }
        return null;
    }

    @Override
    public IServiceLocator getServiceLocator() {
        IServiceLocator serviceLocator = this.fContainer.getServiceLocator();
        if (serviceLocator == null && !this.fContainerProvided) {
            return Utilities.findSite((Control)this.fComposite);
        }
        return serviceLocator;
    }

    @Override
    public IWorkbenchPart getWorkbenchPart() {
        if (this.fContainer != null) {
            return this.fContainer.getWorkbenchPart();
        }
        return null;
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.fContainer != null) {
            this.fContainer.run(fork, cancelable, runnable);
        }
    }

    @Override
    public void runAsynchronously(IRunnableWithProgress runnable) {
        if (this.fContainer != null) {
            this.fContainer.runAsynchronously(runnable);
        }
    }

    public void setContainer(ICompareContainer container) {
        Assert.isNotNull((Object)container);
        this.fContainer = container;
        this.fContainerProvided = true;
    }

    public final ICompareContainer getContainer() {
        return this.fContainer;
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        Utilities.firePropertyChange(this.fListenerList, event);
    }

    public boolean canRunAsJob() {
        return false;
    }

    public boolean belongsTo(Object family) {
        return family == this;
    }

    public boolean isEditionSelectionDialog() {
        return false;
    }

    public String getOKButtonLabel() {
        if (this.isEditable()) {
            return CompareMessages.CompareDialog_commit_button;
        }
        if (this.isEditionSelectionDialog()) {
            return CompareMessages.CompareEditorInput_0;
        }
        return IDialogConstants.OK_LABEL;
    }

    public String getCancelButtonLabel() {
        return IDialogConstants.CANCEL_LABEL;
    }

    private boolean isEditable() {
        return this.getCompareConfiguration().isLeftEditable() || this.getCompareConfiguration().isRightEditable();
    }

    public boolean okPressed() {
        return !this.isEditable() || this.saveChanges();
    }

    public void cancelPressed() {
    }

    private boolean saveChanges() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CompareEditorInput.this.saveChanges(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InvocationTargetException x) {
            ErrorDialog.openError((Shell)this.fComposite.getShell(), (String)CompareMessages.CompareDialog_error_title, null, (IStatus)new Status(4, "org.eclipse.compare", 0, NLS.bind((String)CompareMessages.CompareDialog_error_message, (Object)x.getTargetException().getMessage()), x.getTargetException()));
        }
        return false;
    }

    public Object getSelectedEdition() {
        IStructuredSelection ss;
        ISelection selection;
        if (this.fStructureInputPane != null && (selection = this.fStructureInputPane.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            return ss.getFirstElement();
        }
        return null;
    }

    public void setHelpContextId(String helpContextId) {
        this.fHelpContextId = helpContextId;
    }

    private class InternalOutlineViewerCreator
    extends OutlineViewerCreator {
        private InternalOutlineViewerCreator() {
        }

        private OutlineViewerCreator getWrappedCreator() {
            Viewer v;
            if (CompareEditorInput.this.fContentInputPane != null && (v = CompareEditorInput.this.fContentInputPane.getViewer()) != null) {
                return (OutlineViewerCreator)Adapters.adapt((Object)v, OutlineViewerCreator.class);
            }
            return null;
        }

        @Override
        public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent, CompareConfiguration configuration) {
            OutlineViewerCreator creator = this.getWrappedCreator();
            if (creator != null) {
                return creator.findStructureViewer(oldViewer, input, parent, configuration);
            }
            return null;
        }

        @Override
        public boolean hasViewerFor(Object input) {
            OutlineViewerCreator creator = this.getWrappedCreator();
            return creator != null;
        }

        @Override
        public Object getInput() {
            OutlineViewerCreator creator = this.getWrappedCreator();
            if (creator != null) {
                return creator.getInput();
            }
            return null;
        }
    }
}

