/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.ui.actions;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow.TargetMessageInfo;
import org.eclipse.tracecompass.incubator.internal.ros.core.signals.RosMessageSelectedSignal;
import org.eclipse.tracecompass.incubator.internal.ros.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.ui.actions.Messages;
import org.eclipse.tracecompass.incubator.internal.ros.ui.views.queues.RosQueuesView;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class RosFollowMessageAction
extends Action {
    private static final @NonNull String IMG_UI = "icons/elcl16/follow_message.gif";
    private final TmfView fView;
    private final TimeGraphViewer fTimeGraphViewer;

    public RosFollowMessageAction(TmfView source, TimeGraphViewer timeGraphViewer) {
        this.fTimeGraphViewer = timeGraphViewer;
        this.fView = source;
        this.setText(Messages.FollowMessageAction_NameText);
        this.setToolTipText(Messages.FollowMessageAction_ToolTipText);
        this.setImageDescriptor(Objects.requireNonNull(Activator.getDefault()).getImageDescripterFromPath(IMG_UI));
    }

    public void run() {
        long selectionBegin = this.fTimeGraphViewer.getSelectionBegin();
        ITimeGraphEntry selection = this.fTimeGraphViewer.getSelection();
        if (selection == null) {
            return;
        }
        ITimeEvent msgRefEvent = RosQueuesView.getMessageReferenceEvent(selection, selectionBegin);
        String msgRef = msgRefEvent.getLabel();
        if (msgRef != null) {
            TargetMessageInfo.RosQueueType queueType = RosFollowMessageAction.getQueueTypeFromName(selection.getParent().getParent().getParent().getName());
            if (queueType == null) {
                System.err.println("Invalid queue type!");
                return;
            }
            String node = selection.getParent().getParent().getParent().getParent().getName();
            String topic = selection.getParent().getParent().getName();
            int position = Integer.parseInt(selection.getName());
            long msgBegin = msgRefEvent.getTime();
            TargetMessageInfo target = new TargetMessageInfo(node, topic, queueType, position, msgRef, selectionBegin, msgBegin);
            this.fView.broadcast((TmfSignal)new RosMessageSelectedSignal((Object)this.fView, target));
            super.run();
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable TargetMessageInfo.RosQueueType getQueueTypeFromName(String queueTypeName) {
        if (queueTypeName.equals("Publishers")) {
            return TargetMessageInfo.RosQueueType.PUB;
        }
        if (queueTypeName.equals("Subscribers")) {
            return TargetMessageInfo.RosQueueType.SUB;
        }
        return null;
    }
}

