/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.otf2.core.trace;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.Location;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.LocationGroup;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.SystemTreeNode;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2ClusterAspect;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2NodeAspect;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2PhysicalNodeAspect;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2ProcessAspect;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2ThreadAspect;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class Otf2SystemTree {
    private Map<Long, SystemTreeNode> fSystemTreeNodes = new HashMap<Long, SystemTreeNode>();
    private Map<Long, LocationGroup> fLocationGroups = new HashMap<Long, LocationGroup>();
    private Map<Long, Location> fLocations = new HashMap<Long, Location>();

    public void addSystemTreeNode(ITmfEvent event) {
        SystemTreeNode systemTreeNode = new SystemTreeNode(event);
        this.fSystemTreeNodes.put(systemTreeNode.getId(), systemTreeNode);
    }

    public void addLocationGroup(ITmfEvent event) {
        LocationGroup locationGroup = new LocationGroup(event);
        this.fLocationGroups.put(locationGroup.getId(), locationGroup);
    }

    public void addLocation(ITmfEvent event) {
        Location location = new Location(event);
        this.fLocations.put(location.getId(), location);
    }

    public Iterator<Otf2NodeAspect> getSystemAspects(Map<Integer, String> stringIds) {
        Otf2ClusterAspect clusterAspect = new Otf2ClusterAspect();
        Otf2PhysicalNodeAspect physicalNodeAspect = new Otf2PhysicalNodeAspect();
        Otf2ProcessAspect processAspect = new Otf2ProcessAspect();
        Otf2ThreadAspect threadAspect = new Otf2ThreadAspect();
        for (Location location : this.fLocations.values()) {
            Long locationId = location.getId();
            threadAspect.addNodeName(locationId, location.getName(stringIds));
            Long processId = location.getLocationGroupId();
            LocationGroup process = this.fLocationGroups.get(processId);
            if (process == null) continue;
            processAspect.addNodeName(locationId, process.getFullName(stringIds));
            SystemTreeNode physicalNode = this.fSystemTreeNodes.get(process.getParentId());
            if (physicalNode == null) continue;
            physicalNodeAspect.addNodeName(locationId, physicalNode.getFullName(stringIds));
            SystemTreeNode cluster = this.fSystemTreeNodes.get(physicalNode.getParentId());
            if (cluster == null) continue;
            clusterAspect.addNodeName(locationId, cluster.getFullName(stringIds));
        }
        Otf2NodeAspect[] systemAspects = new Otf2NodeAspect[]{clusterAspect, physicalNodeAspect, processAspect, threadAspect};
        return Arrays.asList(systemAspects).iterator();
    }
}

