/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.executor;

import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.AbstractRos2StateSystemAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.executor.Ros2ExecutorStateProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class Ros2ExecutorAnalysis
extends AbstractRos2StateSystemAnalysis {
    private static final @NonNull String ID_SUFFIX = ".executor";

    public Ros2ExecutorAnalysis() {
        super(Ros2ExecutorAnalysis.getFullAnalysisId());
    }

    public static @NonNull String getFullAnalysisId() {
        return AbstractRos2StateSystemAnalysis.getAnalysisIdFromSuffix(ID_SUFFIX);
    }

    protected @NonNull ITmfStateProvider createStateProvider() {
        @NonNull ITmfTrace trace = Objects.requireNonNull(this.getTrace());
        ITmfStateSystem ss = Ros2ExecutorAnalysis.getStateSystem((ITmfTrace)trace, (String)Ros2ObjectsAnalysis.getFullAnalysisId());
        return new Ros2ExecutorStateProvider(trace, Objects.requireNonNull(ss));
    }

    protected @NonNull Iterable<@NonNull IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptySet();
        }
        Ros2ObjectsAnalysis objectsAnalysis = (Ros2ObjectsAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, Ros2ObjectsAnalysis.class, (String)Ros2ObjectsAnalysis.getFullAnalysisId());
        if (objectsAnalysis == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(objectsAnalysis);
    }
}

