/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceCPUDataPage;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceEventFormat;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFormatField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceHeaderInfo;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceValueSign;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceCPUPageIterator;

public class BinaryFTraceIteratorHelper {
    private final BinaryFTraceHeaderInfo fHeader;
    private static final int TYPE_LENGTH_SHIFT_BIG = 27;
    private static final int TIME_DELTA_SHIFT_LITTLE = 5;
    private static final int DATALOC_SHIFT = 16;
    private static final int TYPE_LENGTH_MASK_LITTLE = 31;
    private static final int TYPE_LENGTH_MASK_BIG = -134217728;
    private static final int TIME_DELTA_MASK_LITTLE = -32;
    private static final int TIME_DELTA_MASK_BIG = -1;
    private static final int DATA_LOC_OFFSET = 65535;
    private static final String hexPrefix = "0x";

    public BinaryFTraceIteratorHelper(BinaryFTraceHeaderInfo header) {
        this.fHeader = header;
    }

    public int getEventTypeLength(int value) {
        if (this.fHeader.getEndianess() == ByteOrder.LITTLE_ENDIAN) {
            return value & 0x1F;
        }
        return (value & 0xF8000000) >> 27;
    }

    public int getDeltaTime(int value) {
        if (this.fHeader.getEndianess() == ByteOrder.LITTLE_ENDIAN) {
            return (value & 0xFFFFFFE0) >> 5;
        }
        return value & 0xFFFFFFFF;
    }

    public static @Nullable BinaryFTraceCPUPageIterator getPageIterator(BinaryFTraceCPUDataPage page, BinaryFTraceHeaderInfo headerInfo) {
        if (headerInfo != null && page != null) {
            return new BinaryFTraceCPUPageIterator(page, headerInfo);
        }
        return null;
    }

    public Map<String, Object> parseEventData(BinaryFTraceEventFormat eventFormat, byte[] data) {
        Object value;
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        eventProperties.put("name", eventFormat.getEventName());
        for (Map.Entry<String, BinaryFTraceFormatField> fieldEntry : eventFormat.getCommonFields().entrySet()) {
            value = this.getFieldValue(fieldEntry.getValue(), data);
            eventProperties.put(fieldEntry.getKey(), value);
        }
        for (Map.Entry<String, BinaryFTraceFormatField> fieldEntry : eventFormat.getCustomFields().entrySet()) {
            value = this.getFieldValue(fieldEntry.getValue(), data);
            eventProperties.put(fieldEntry.getKey(), value);
        }
        return eventProperties;
    }

    public Object getFieldValue(BinaryFTraceFormatField formatField, byte[] data) {
        if (formatField.isPointer()) {
            byte[] fieldData = BinaryFTraceIteratorHelper.extractValue(formatField, data);
            return this.readStringPointerField(fieldData);
        }
        if (formatField.isString()) {
            byte[] fieldData = new byte[]{};
            fieldData = formatField.isDataLoc() ? this.extractDataLocValue(formatField, data) : BinaryFTraceIteratorHelper.extractValue(formatField, data);
            return BinaryFTraceIteratorHelper.readStringField(fieldData);
        }
        if (formatField.getArrayLength() == 0) {
            byte[] fieldData = BinaryFTraceIteratorHelper.extractValue(formatField, data);
            return this.readStringPointerField(fieldData);
        }
        byte[] fieldData = BinaryFTraceIteratorHelper.extractValue(formatField, data);
        return this.getPrimitiveDataValue(formatField, fieldData);
    }

    public BinaryFTraceEventFormat getEventFormat(byte[] data) {
        BinaryFTraceFormatField commonTypeField = this.fHeader.getEventCommonFields().get("common_type");
        Long eventId = (Long)this.getFieldValue(commonTypeField, data);
        if (eventId == null) {
            return null;
        }
        return this.fHeader.getEventFormatByID(eventId.intValue());
    }

    private Object getPrimitiveDataValue(BinaryFTraceFormatField formatField, byte[] data) {
        Object value = null;
        switch (formatField.getFieldType()) {
            case CHAR: {
                value = BinaryFTraceIteratorHelper.readCharField(formatField, data);
                break;
            }
            case SHORT: {
                value = this.readShortField(formatField, data);
                break;
            }
            case INT: {
                value = this.readIntField(formatField, data);
                break;
            }
            case LONG: {
                value = this.readLongField(formatField, data);
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
        return value;
    }

    private static String readStringField(byte[] fieldData) {
        int i = 0;
        while (i < fieldData.length) {
            if (fieldData[i] == 0) {
                return new String(fieldData, 0, i);
            }
            ++i;
        }
        return new String(fieldData);
    }

    private static Long readCharField(BinaryFTraceFormatField formatField, byte[] fieldData) {
        if (fieldData.length == 1) {
            Byte byteValue = fieldData[0];
            if (formatField.getSigned() == BinaryFTraceValueSign.SIGNED || BinaryFTraceIteratorHelper.canBeSignedByte(byteValue)) {
                return (long)byteValue;
            }
            return Byte.toUnsignedLong(byteValue);
        }
        return null;
    }

    private static boolean canBeSignedByte(Byte byteValue) {
        return Byte.toUnsignedInt(byteValue) - Byte.toUnsignedInt((byte)127) <= 0;
    }

    private Object readShortField(BinaryFTraceFormatField formatField, byte[] fieldData) {
        Short shortValue = ByteBuffer.wrap(fieldData).order(this.fHeader.getEndianess()).getShort();
        if (formatField.getSigned() == BinaryFTraceValueSign.SIGNED || BinaryFTraceIteratorHelper.canBeSignedShort(shortValue)) {
            return (long)shortValue.shortValue();
        }
        return Short.toUnsignedLong(shortValue);
    }

    private static boolean canBeSignedShort(Short shortValue) {
        return Short.toUnsignedInt(shortValue) - Short.toUnsignedInt((short)Short.MAX_VALUE) <= 0;
    }

    private Object readIntField(BinaryFTraceFormatField formatField, byte[] fieldData) {
        Integer intValue = ByteBuffer.wrap(fieldData).order(this.fHeader.getEndianess()).getInt();
        if (formatField.getSigned() == BinaryFTraceValueSign.SIGNED || BinaryFTraceIteratorHelper.canBeSignedInt(intValue)) {
            return (long)intValue.intValue();
        }
        return Integer.toUnsignedLong(intValue);
    }

    private static boolean canBeSignedInt(Integer byteValue) {
        return Integer.compareUnsigned(byteValue, Integer.MAX_VALUE) <= 0;
    }

    private Object readLongField(BinaryFTraceFormatField formatField, byte[] fieldData) {
        Long longValue = ByteBuffer.wrap(fieldData).order(this.fHeader.getEndianess()).getLong();
        if (formatField.getSigned() == BinaryFTraceValueSign.UNSIGNED && !BinaryFTraceIteratorHelper.canBeSignedLong(longValue)) {
            return Long.toUnsignedString(longValue);
        }
        return longValue;
    }

    private static boolean canBeSignedLong(Long longValue) {
        return Long.compareUnsigned(longValue, Long.MAX_VALUE) <= 0;
    }

    private static byte[] extractValue(BinaryFTraceFormatField field, byte[] data) {
        int size = field.getSize();
        int offset = field.getOffset();
        byte[] valueInBytes = Arrays.copyOfRange(data, offset, size + offset);
        return valueInBytes;
    }

    private byte[] extractDataLocValue(BinaryFTraceFormatField field, byte[] data) {
        if (field.getSize() != 4) {
            return null;
        }
        byte[] dataLocationInBytes = Arrays.copyOfRange(data, field.getOffset(), field.getOffset() + field.getSize());
        int dataLocation = ByteBuffer.wrap(dataLocationInBytes).order(this.fHeader.getEndianess()).getInt();
        int length = BinaryFTraceIteratorHelper.getDataLocLength(dataLocation);
        int offset = BinaryFTraceIteratorHelper.getDataLocOffset(dataLocation);
        if (offset + length <= data.length) {
            byte[] valueInBytes = Arrays.copyOfRange(data, offset, offset + length);
            return valueInBytes;
        }
        return new byte[0];
    }

    private String readStringPointerField(byte[] fieldData) {
        long pointerAddress = ByteBuffer.wrap(fieldData).order(this.fHeader.getEndianess()).getLong();
        String hexAddress = hexPrefix + Long.toHexString(pointerAddress);
        if (this.fHeader.getPrintKPointerStringMapping().containsKey(hexAddress)) {
            return this.fHeader.getPrintKPointerStringMapping().get(hexAddress);
        }
        return hexAddress;
    }

    private static int getDataLocLength(int dataLoc) {
        return dataLoc >> 16;
    }

    private static int getDataLocOffset(int value) {
        return value & 0xFFFF;
    }
}

