/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.trace.layout;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.incubator.internal.ros.core.trace.layout.Ros021EventLayout;

@NonNullByDefault
public interface IRosEventLayout {
    public static final String PROVIDER_NAME = "roscpp:";

    public static IRosEventLayout getDefault() {
        return Ros021EventLayout.getInstance();
    }

    default public Collection<String> getEventNames() {
        ArrayList eventNames = Lists.newArrayList();
        Iterables.filter(Arrays.asList(IRosEventLayout.class.getMethods()), method -> method.getName().startsWith("event")).forEach(eventMethod -> {
            try {
                eventNames.add((String)NonNullUtils.checkNotNull((Object)((String)eventMethod.invoke((Object)this, new Object[0]))));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        });
        return ImmutableList.copyOf((Collection)((Collection)NonNullUtils.checkNotNull((Object)eventNames)));
    }

    public String eventInitNode();

    public String eventShutdownNode();

    public String eventNewConnection();

    public String eventSubCallbackAdded();

    public String eventPubMsgQueued();

    public String eventSubLinkMsgWrite();

    public String eventSubLinkMsgDropped();

    public String eventPubLinkHandleMsg();

    public String eventSubMsgQueued();

    public String eventSubMsgDropped();

    public String eventCallbackStart();

    public String eventSubCallbackStart();

    public String eventSubCallbackEnd();

    public String eventCallbackEnd();

    public String eventTaskStart();

    public String eventTimerAdded();

    public String eventTimerScheduled();

    public String fieldNodeName();

    public String fieldRosCppVersion();

    public String fieldQueueRef();

    public String fieldCallbackRef();

    public String fieldTypeInfo();

    public String fieldDataType();

    public String fieldSourceName();

    public String fieldQueueSize();

    public String fieldTopic();

    public String fieldBufferRef();

    public String fieldDataRef();

    public String fieldTracingId();

    public String fieldMsgRef();

    public String fieldReceiptTimeSec();

    public String fieldReceiptTimeNsec();

    public String fieldIsLatchedMsg();

    public String fieldTaskName();

    public String fieldFunctionName();

    public String fieldPeriodSec();

    public String fieldPeriodNsec();

    public String fieldCallbackQueueCbRef();

    public String fieldLocalHostport();

    public String fieldRemoteHostport();

    public String fieldChannelRef();

    public String fieldChannelType();

    public String fieldName();

    public String contextVpid();

    public String contextVtid();

    public String contextProcname();
}

