/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.scripting;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringContribution;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public final class InlineMethodRefactoringContribution
extends JDTRefactoringContribution {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Refactoring createRefactoring(RefactoringDescriptor descriptor) throws CoreException {
        String handle;
        int selectionStart = -1;
        int selectionLength = -1;
        IJavaScriptUnit unit = null;
        JavaScriptUnit node = null;
        JavaRefactoringArguments arguments = null;
        if (descriptor instanceof JDTRefactoringDescriptor) {
            JDTRefactoringDescriptor jDTRefactoringDescriptor = (JDTRefactoringDescriptor)descriptor;
            arguments = jDTRefactoringDescriptor.createArguments();
        }
        if (!(arguments instanceof JavaRefactoringArguments)) throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments, null));
        JavaRefactoringArguments javaRefactoringArguments = arguments;
        String selection = javaRefactoringArguments.getAttribute("selection");
        if (selection != null) {
            int offset = -1;
            int length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}), null));
            selectionStart = offset;
            selectionLength = length;
        }
        if ((handle = javaRefactoringArguments.getAttribute("input")) == null) throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"), null));
        IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), handle, false);
        if (element == null || !element.exists()) {
            throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_inputs_do_not_exist, new String[]{RefactoringCoreMessages.InlineMethodRefactoring_name, "org.eclipse.wst.jsdt.ui.inline.method"}), null));
        }
        if (element instanceof IJavaScriptUnit) {
            unit = (IJavaScriptUnit)element;
            if (selection == null) {
                throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"), null));
            }
        } else {
            if (!(element instanceof IFunction)) throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{handle, "input"}), null));
            IFunction method = (IFunction)element;
            try {
                ISourceRange range = method.getNameRange();
                if (range == null) {
                    throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{handle, "input"}), null));
                }
                selectionStart = range.getOffset();
                selectionLength = range.getLength();
            }
            catch (JavaScriptModelException exception) {
                throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, Messages.format(RefactoringCoreMessages.InitializableRefactoring_inputs_do_not_exist, new String[]{RefactoringCoreMessages.InlineMethodRefactoring_name, "org.eclipse.wst.jsdt.ui.inline.method"}), (Throwable)exception));
            }
            unit = method.getJavaScriptUnit();
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(unit);
        node = (JavaScriptUnit)parser.createAST(null);
        return InlineMethodRefactoring.create((ITypeRoot)unit, node, selectionStart, selectionLength);
    }
}

