/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.model.IScriptResolver;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.Messages;
import org.eclipse.wst.jsdt.debug.internal.core.launching.SourceLookup;
import org.eclipse.wst.jsdt.debug.internal.core.model.ScriptResolverExtension;

public final class ScriptResolutionManager {
    static IScriptResolver[] NO_RESOLVERS = new IScriptResolver[0];
    ListenerList resolvers = null;

    public boolean matches(ScriptReference script, IPath path) {
        IScriptResolver[] res = this.getResolvers();
        int i = 0;
        while (i < res.length) {
            if (res[i].matches(script, path)) {
                return true;
            }
            ++i;
        }
        return this.isMatch(script, path);
    }

    boolean isMatch(ScriptReference script, IPath path) {
        IPath uripath;
        IPath spath;
        if (this.guessScriptMatches(script, path)) {
            return true;
        }
        URI sourceURI = script.sourceURI();
        if (URIUtil.isFileURI((URI)sourceURI)) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            URI workspaceURI = workspaceRoot.getRawLocationURI();
            sourceURI = workspaceURI.relativize(sourceURI);
        }
        if ((spath = path).segmentCount() > 0 && spath.segment(0).equals(Messages.external_javascript_source)) {
            spath = spath.removeFirstSegments(1).makeAbsolute();
        }
        if ((uripath = SourceLookup.getSourcePath(sourceURI)) != null) {
            uripath = uripath.makeAbsolute();
        }
        return spath.equals((Object)uripath);
    }

    boolean guessScriptMatches(ScriptReference script, IPath path) {
        IPath newpath = path.makeAbsolute();
        Path uri = new Path(script.sourceURI().getPath());
        if (SourceLookup.TOP_LEVEL_PATH.equals((Object)newpath) && SourceLookup.TOP_LEVEL_PATH.equals((Object)uri)) {
            return true;
        }
        uri = uri.makeAbsolute();
        int matched_segments = 0;
        int last = uri.segmentCount() - 1;
        int i = newpath.segmentCount() - 1;
        while (i > -1) {
            if (last < 0) break;
            if (newpath.segment(i).equals(uri.segment(last))) {
                ++matched_segments;
                --last;
            }
            --i;
        }
        if (newpath.segmentCount() == 2 && matched_segments > 0) {
            return true;
        }
        return matched_segments > 1;
    }

    public IFile getFile(ScriptReference script) {
        IScriptResolver[] resolvers = this.getResolvers();
        ArrayList<IFile> files = new ArrayList<IFile>();
        IFile file = null;
        int i = 0;
        while (i < resolvers.length) {
            file = resolvers[i].getFile(script);
            if (file != null) {
                if (files.contains(file)) {
                    return file;
                }
                files.add(file);
            }
            ++i;
        }
        file = null;
        IPath p = SourceLookup.getSourcePath(script.sourceURI());
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(p.makeAbsolute());
        if (res == null) {
            IProject pj = JavaScriptDebugPlugin.getExternalSourceProject(true);
            res = pj.findMember(p);
        }
        if (res != null && res.getType() == 1) {
            file = (IFile)res;
        }
        if (files.size() > 0) {
            if (files.contains(file)) {
                return file;
            }
            return (IFile)files.get(0);
        }
        return file;
    }

    public IScriptResolver[] getResolvers() {
        this.loadResolvers();
        if (this.resolvers.size() < 1) {
            return NO_RESOLVERS;
        }
        List<Object> res = Arrays.asList(this.resolvers.getListeners());
        return res.toArray(new IScriptResolver[res.size()]);
    }

    void loadResolvers() {
        if (this.resolvers == null) {
            this.resolvers = new ListenerList();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.jsdt.debug.core", "scriptResolvers");
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.resolvers.add((Object)new ScriptResolverExtension(elements[i]));
                ++i;
            }
        }
    }

    public void dispose() {
        if (this.resolvers != null) {
            this.resolvers.clear();
            this.resolvers = null;
        }
    }
}

