/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.swslatency;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.AbstractSegmentStoreAnalysisEventBasedModule;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.incubator.internal.kernel.core.swslatency.Messages;
import org.eclipse.tracecompass.incubator.internal.kernel.core.swslatency.SchedWS;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;

public class SWSLatencyAnalysis
extends AbstractSegmentStoreAnalysisEventBasedModule {
    public static final String ID = "org.eclipse.tracecompass.incubator.internal.kernel.core.swslatency.sws";
    private static final int VERSION = 1;
    private static final Collection<ISegmentAspect> BASE_ASPECTS = ImmutableList.of((Object)SWSThreadAspect.INSTANCE, (Object)SWSTidAspect.INSTANCE, (Object)SWSPriorityAspect.INSTANCE);

    public String getId() {
        return ID;
    }

    public Iterable<ISegmentAspect> getSegmentAspects() {
        return BASE_ASPECTS;
    }

    protected int getVersion() {
        return 1;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SegmentStoreFactory.SegmentStoreType getSegmentStoreType() {
        return SegmentStoreFactory.SegmentStoreType.OnDisk;
    }

    protected AbstractSegmentStoreAnalysisEventBasedModule.AbstractSegmentStoreAnalysisRequest createAnalysisRequest(ISegmentStore<@NonNull ISegment> swsSegment, IProgressMonitor monitor) {
        return new SWSLatencyAnalysisRequest(swsSegment, monitor);
    }

    protected @NonNull IHTIntervalReader<@NonNull ISegment> getSegmentReader() {
        return SchedWS.READER;
    }

    private class SWSLatencyAnalysisRequest
    extends AbstractSegmentStoreAnalysisEventBasedModule.AbstractSegmentStoreAnalysisRequest {
        private final Map<Integer, SchedWS.InitialInfo> fOngoingSWS;
        private @Nullable IKernelAnalysisEventLayout fLayout;
        private final IProgressMonitor fMonitor;

        public SWSLatencyAnalysisRequest(ISegmentStore<ISegment> swsSegment, IProgressMonitor monitor) {
            super((AbstractSegmentStoreAnalysisEventBasedModule)SWSLatencyAnalysis.this, swsSegment);
            this.fOngoingSWS = new HashMap<Integer, SchedWS.InitialInfo>();
            this.fMonitor = monitor;
        }

        public void handleData(ITmfEvent event) {
            String eventName;
            super.handleData(event);
            IKernelAnalysisEventLayout layout = this.fLayout;
            if (layout == null) {
                IKernelTrace trace = (IKernelTrace)event.getTrace();
                this.fLayout = layout = trace.getKernelEventLayout();
            }
            if ((eventName = event.getName()).equals(layout.eventSchedProcessWakeup()) || eventName.equals(layout.eventSchedProcessWakeupNew())) {
                Integer tid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{layout.fieldTid()});
                if (tid == null) {
                    return;
                }
                long startTime = event.getTimestamp().toNanos();
                String threadName = (String)event.getContent().getFieldValue(String.class, new String[]{layout.fieldComm()});
                if (threadName == null) {
                    threadName = "";
                }
                SchedWS.InitialInfo newSchedWS = new SchedWS.InitialInfo(startTime, threadName.intern(), tid);
                this.fOngoingSWS.put(tid, newSchedWS);
            } else if (eventName.equals(layout.eventSchedSwitch())) {
                Integer tid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{layout.fieldNextTid()});
                if (tid == null) {
                    return;
                }
                SchedWS.InitialInfo info = this.fOngoingSWS.remove(tid);
                if (info == null) {
                    return;
                }
                long endTime = event.getTimestamp().toNanos();
                Integer priority = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{layout.fieldNextPrio()});
                SchedWS swscall = new SchedWS(info, endTime, priority == null ? -1 : priority);
                this.getSegmentStore().add((Object)swscall);
            }
        }

        public void handleCompleted() {
            this.fOngoingSWS.clear();
            super.handleCompleted();
        }

        public void handleCancel() {
            this.fMonitor.setCanceled(true);
            super.handleCancel();
        }
    }

    private static final class SWSPriorityAspect
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new SWSPriorityAspect();

        private SWSPriorityAspect() {
        }

        public String getHelpText() {
            return Messages.getMessage(Messages.SegmentAspectHelpText_SWSPrio);
        }

        public String getName() {
            return Messages.getMessage(Messages.SegmentAspectName_SWSPrio);
        }

        public @Nullable Object resolve(ISegment segment) {
            if (segment instanceof SchedWS) {
                return ((SchedWS)segment).getPriority();
            }
            return "";
        }

        public @Nullable Comparator<?> getComparator() {
            return (segment1, segment2) -> {
                if (segment1 == null) {
                    return 1;
                }
                if (segment2 == null) {
                    return -1;
                }
                if (segment1 instanceof SchedWS && segment2 instanceof SchedWS) {
                    int res = Integer.compare(((SchedWS)segment1).getPriority(), ((SchedWS)segment2).getPriority());
                    return res != 0 ? res : SegmentComparators.INTERVAL_START_COMPARATOR.thenComparing(SegmentComparators.INTERVAL_END_COMPARATOR).compare((ISegment)segment1, (ISegment)segment2);
                }
                return 1;
            };
        }
    }

    private static final class SWSThreadAspect
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new SWSThreadAspect();

        private SWSThreadAspect() {
        }

        public String getHelpText() {
            return Messages.getMessage(Messages.SegmentAspectHelpText_SWSTid);
        }

        public String getName() {
            return OsStrings.execName();
        }

        public @Nullable Comparator<?> getComparator() {
            return (segment1, segment2) -> {
                if (segment1 == null) {
                    return 1;
                }
                if (segment2 == null) {
                    return -1;
                }
                if (segment1 instanceof SchedWS && segment2 instanceof SchedWS) {
                    int res = ((SchedWS)segment1).getName().compareToIgnoreCase(((SchedWS)segment2).getName());
                    return res != 0 ? res : SegmentComparators.INTERVAL_START_COMPARATOR.thenComparing(SegmentComparators.INTERVAL_END_COMPARATOR).compare((ISegment)segment1, (ISegment)segment2);
                }
                return 1;
            };
        }

        public @Nullable String resolve(ISegment segment) {
            if (segment instanceof SchedWS) {
                return ((SchedWS)segment).getName();
            }
            return null;
        }
    }

    private static final class SWSTidAspect
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new SWSTidAspect();

        private SWSTidAspect() {
        }

        public String getHelpText() {
            return Messages.getMessage(Messages.SegmentAspectHelpText_SWSTid);
        }

        public String getName() {
            return OsStrings.tid();
        }

        public @Nullable Comparator<?> getComparator() {
            return (segment1, segment2) -> {
                if (segment1 == null) {
                    return 1;
                }
                if (segment2 == null) {
                    return -1;
                }
                if (segment1 instanceof SchedWS && segment2 instanceof SchedWS) {
                    int res = Integer.compare(((SchedWS)segment1).getTid(), ((SchedWS)segment2).getTid());
                    return res != 0 ? res : SegmentComparators.INTERVAL_START_COMPARATOR.thenComparing(SegmentComparators.INTERVAL_END_COMPARATOR).compare((ISegment)segment1, (ISegment)segment2);
                }
                return 0;
            };
        }

        public @Nullable Integer resolve(ISegment segment) {
            if (segment instanceof SchedWS) {
                return ((SchedWS)segment).getTid();
            }
            return -1;
        }
    }
}

