/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.overhead;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.CallStackHostUtils;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.CallStackSeries;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.InstrumentedCallStackAnalysis;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.InstrumentedCallStackElement;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.FusedVMInformationProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.FusedVirtualMachineAnalysis;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.analysis.VirtualMachineModelAnalysis;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.overhead.VmOverheadStateProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.virtual.resources.VirtualResourcesAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class VmOverheadAnalysis
extends InstrumentedCallStackAnalysis {
    public static final String ID = "org.eclipse.tracecompass.incubator.virtual.machine.analysis.core.overhead.analysis";
    public static final String HOST_CPU_TID = "hostTid";
    private static final String[] HOST_CPU_TID_PATH = new String[]{"hostTid"};
    private static final String[] DEFAULT_TRACES_PATTERN = new String[]{"Traces", "*"};
    private static final String[] DEFAULT_THREADS_PATTERN = new String[]{"Threads", "*"};
    private static final List<String[]> PATTERNS = ImmutableList.of((Object)DEFAULT_TRACES_PATTERN, (Object)DEFAULT_THREADS_PATTERN);

    private @Nullable VirtualResourcesAnalysis getDependentAnalysis() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return null;
        }
        return (VirtualResourcesAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, VirtualResourcesAnalysis.class, (String)"org.eclipse.tracecompass.incubator.virtual.machine.analysis.core.VirtualResourcesAnalysis");
    }

    protected @NonNull Iterable<@NonNull IAnalysisModule> getDependentAnalyses() {
        VirtualResourcesAnalysis dependentAnalysis = this.getDependentAnalysis();
        if (dependentAnalysis == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(dependentAnalysis);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.FULL;
    }

    protected ITmfStateProvider createStateProvider() {
        ITmfTrace trace = this.getTrace();
        if (!(trace instanceof TmfExperiment)) {
            throw new IllegalStateException();
        }
        VirtualMachineModelAnalysis model = (VirtualMachineModelAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, VirtualMachineModelAnalysis.class, (String)"org.eclipse.tracecompass.incubator.virtual.machine.analysis.core.model.analysis");
        if (model == null) {
            throw new IllegalStateException("There should be a model analysis for this class");
        }
        model.schedule();
        if (!model.waitForInitialization()) {
            throw new IllegalStateException("Problem initializing the model analysis");
        }
        return new VmOverheadStateProvider((TmfExperiment)trace, model.getVirtualEnvironmentModel());
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CallStackSeries.IThreadIdResolver getCallStackTidResolver() {
        return new VirtualCpuTidResolver(HOST_CPU_TID_PATH);
    }

    protected CallStackHostUtils.TraceHostIdResolver getCallStackHostResolver(ITmfTrace trace) {
        FusedVirtualMachineAnalysis analysisModule = (FusedVirtualMachineAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, FusedVirtualMachineAnalysis.class, (String)"org.eclipse.tracecompass.incubator.virtual.machine.analysis.FusedVirtualMachineAnalysis");
        if (analysisModule == null) {
            return super.getCallStackHostResolver(trace);
        }
        analysisModule.schedule();
        analysisModule.waitForCompletion();
        ITmfStateSystem stateSystem = analysisModule.getStateSystem();
        if (stateSystem == null) {
            return super.getCallStackHostResolver(trace);
        }
        Optional<ITmfTrace> hostTrace = TmfTraceManager.getTraceSet((ITmfTrace)trace).stream().filter(t -> FusedVMInformationProvider.getParentMachineHostId(stateSystem, t.getHostId()).isEmpty()).findFirst();
        if (hostTrace.isPresent()) {
            return new CallStackHostUtils.TraceHostIdResolver(hostTrace.get());
        }
        return super.getCallStackHostResolver(trace);
    }

    public @NonNull String getHostId() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return super.getHostId();
        }
        FusedVirtualMachineAnalysis analysisModule = (FusedVirtualMachineAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, FusedVirtualMachineAnalysis.class, (String)"org.eclipse.tracecompass.incubator.virtual.machine.analysis.FusedVirtualMachineAnalysis");
        if (analysisModule == null) {
            return super.getHostId();
        }
        analysisModule.schedule();
        analysisModule.waitForCompletion();
        ITmfStateSystem stateSystem = analysisModule.getStateSystem();
        if (stateSystem == null) {
            return super.getHostId();
        }
        Optional<ITmfTrace> hostTrace = TmfTraceManager.getTraceSet((ITmfTrace)trace).stream().filter(t -> FusedVMInformationProvider.getParentMachineHostId(stateSystem, t.getHostId()).isEmpty()).findFirst();
        if (hostTrace.isPresent()) {
            return hostTrace.get().getHostId();
        }
        return super.getHostId();
    }

    protected List<String[]> getPatterns() {
        return PATTERNS;
    }

    private static final class VirtualCpuThreadProvider
    implements CallStackSeries.IThreadIdProvider {
        private final ITmfStateSystem fSs;
        private final int fCpuQuark;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public VirtualCpuThreadProvider(ITmfStateSystem ss, int quark, String[] path) {
            this.fSs = ss;
            @NonNull List quarks = ss.getQuarks(quark, path);
            this.fCpuQuark = quarks.isEmpty() ? -2 : (Integer)quarks.get(0);
        }

        public int getThreadId(long time) {
            ITmfStateInterval querySingleState;
            block4: {
                if (this.fCpuQuark == -2) {
                    return -1;
                }
                try {
                    querySingleState = this.fSs.querySingleState(time, this.fCpuQuark);
                    if (!querySingleState.getStateValue().isNull()) break block4;
                    return -1;
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    return -1;
                }
            }
            return querySingleState.getStateValue().unboxInt();
        }

        public boolean variesInTime() {
            return true;
        }
    }

    public static final class VirtualCpuTidResolver
    implements CallStackSeries.IThreadIdResolver {
        private String[] fPath;

        public VirtualCpuTidResolver(String[] path) {
            this.fPath = path;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable CallStackSeries.IThreadIdProvider resolve(CallStackHostUtils.IHostIdProvider hostProvider, ICallStackElement element) {
            if (!(element instanceof InstrumentedCallStackElement)) {
                throw new IllegalArgumentException();
            }
            InstrumentedCallStackElement insElement = (InstrumentedCallStackElement)element;
            return new VirtualCpuThreadProvider(insElement.getStateSystem(), insElement.getQuark(), this.fPath);
        }
    }
}

