/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.markers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IllegalFormatException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.CustomAnnotationProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.PeriodicAnnotationSource;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSegment;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSet;
import org.eclipse.tracecompass.internal.tmf.core.markers.SubMarker;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.markers.MarkerUtils;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfMarkerEventSourceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.AbstractTmfTraceAdapterFactory;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.model.StyleManager;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;

public class ConfigurableMarkerEventSource
implements IMarkerEventSource,
AbstractTmfTraceAdapterFactory.IDisposableAdapter {
    private static final int MIN_PERIOD = 5;
    private static final Pattern INDEX_EXTRACTOR = Pattern.compile("(%d+).*");
    private final ITmfTrace fTrace;
    private List<IConfigurableMarkerEventSource> fMarkerEventSources;
    private CustomAnnotationProvider fProvider;

    public ConfigurableMarkerEventSource(ITmfTrace trace) {
        this.fTrace = trace;
        this.updateMarkerSet();
        TmfSignalManager.register((Object)this);
    }

    public void dispose() {
        TmfSignalManager.deregister((Object)this);
    }

    public List<IConfigurableMarkerEventSource> configure(MarkerSet markerSet) {
        this.fProvider.configure(markerSet);
        List<@NonNull IConfigurableMarkerEventSource> singletonList = Objects.requireNonNull(Collections.singletonList(new ConfigurableMarkerSource((IOutputAnnotationProvider)this.fProvider)));
        this.fMarkerEventSources = singletonList;
        return singletonList;
    }

    @Override
    public List<String> getMarkerCategories() {
        LinkedHashSet<String> categories = new LinkedHashSet<String>();
        for (IConfigurableMarkerEventSource source : this.fMarkerEventSources) {
            categories.addAll(source.getMarkerCategories());
            this.getSubMarkerCategories(categories, source.getSubMarkers());
        }
        return (List)NonNullUtils.checkNotNull((Object)Lists.newArrayList(categories));
    }

    private void getSubMarkerCategories(Set<String> categories, List<SubMarker> subMarkers) {
        for (SubMarker subMarker : subMarkers) {
            categories.add(subMarker.getName());
            this.getSubMarkerCategories(categories, subMarker.getSubMarkers());
            if (!(subMarker instanceof SubMarker.WeightedMarker)) continue;
            for (MarkerSegment segment : ((SubMarker.WeightedMarker)subMarker).getSegments()) {
                this.getSubMarkerCategories(categories, segment.getSubMarkers());
            }
        }
    }

    @Override
    public List<IMarkerEvent> getMarkerList(String category, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        ArrayList<@NonNull IMarkerEvent> markerList = new ArrayList<IMarkerEvent>();
        for (IConfigurableMarkerEventSource source : this.fMarkerEventSources) {
            long minDuration = resolution * 5L;
            List<@NonNull IMarkerEvent> list = source.getMarkerList(category, startTime, endTime, resolution, monitor);
            for (IMarkerEvent markerEvent : list) {
                if (markerEvent.getDuration() <= minDuration) continue;
                markerList.add(markerEvent);
            }
        }
        markerList.sort(Comparator.comparingLong(ITimeEvent::getTime));
        return markerList;
    }

    @Override
    public List<IMarkerEvent> getMarkerList(long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        ArrayList<@NonNull IMarkerEvent> markerList = new ArrayList<IMarkerEvent>();
        for (IConfigurableMarkerEventSource source : this.fMarkerEventSources) {
            long minDuration = resolution * 5L;
            List<@NonNull IMarkerEvent> list = source.getMarkerList(startTime, endTime, resolution, monitor);
            for (IMarkerEvent markerEvent : list) {
                if (markerEvent.getDuration() <= minDuration) continue;
                markerList.add(markerEvent);
            }
        }
        markerList.sort(Comparator.comparingLong(ITimeEvent::getTime));
        return markerList;
    }

    @TmfSignalHandler
    public void markerEventSourceUpdated(TmfMarkerEventSourceUpdatedSignal signal) {
        this.updateMarkerSet();
    }

    private final void updateMarkerSet() {
        MarkerSet defaultMarkerSet = MarkerUtils.getDefaultMarkerSet();
        this.fProvider = new CustomAnnotationProvider(Objects.requireNonNull(this.fTrace), defaultMarkerSet);
        this.fMarkerEventSources = this.configure(defaultMarkerSet);
    }

    private class ConfigurableMarkerSource
    implements IConfigurableMarkerEventSource {
        private final IOutputAnnotationProvider fAnnotationProvider;
        private boolean fHasError = false;

        public ConfigurableMarkerSource(IOutputAnnotationProvider provider) {
            this.fAnnotationProvider = provider;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @NonNull List<@NonNull String> getMarkerCategories() {
            TimeQueryFilter timeQueryFilter = new TimeQueryFilter(0L, Long.MAX_VALUE, 2);
            ArrayList<@NonNull String> categories = new ArrayList<String>();
            @NonNull @NonNull Map fetchParameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)timeQueryFilter);
            @NonNull TmfModelResponse response = this.fAnnotationProvider.fetchAnnotationCategories(fetchParameters, (IProgressMonitor)new NullProgressMonitor());
            AnnotationCategoriesModel model = (AnnotationCategoriesModel)response.getModel();
            if (model != null) {
                categories.addAll(model.getAnnotationCategories());
            }
            return categories;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @NonNull List<@NonNull IMarkerEvent> getMarkerList(@NonNull String category, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
            if (startTime >= endTime) {
                return Collections.emptyList();
            }
            TimeQueryFilter filter = new TimeQueryFilter(StateSystemUtils.getTimes((long)startTime, (long)endTime, (long)resolution));
            @NonNull TmfModelResponse response = this.fAnnotationProvider.fetchAnnotations(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter), monitor);
            AnnotationModel model = (AnnotationModel)response.getModel();
            if (model == null) {
                return Collections.emptyList();
            }
            @NonNull @NonNull @NonNull Map annotationsMap = model.getAnnotations();
            ArrayList<@NonNull IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
            Collection collection = (Collection)annotationsMap.get(category);
            if (collection != null) {
                StyleManager sm = StyleManager.empty();
                for (Annotation annotation : collection) {
                    OutputElementStyle style = annotation.getStyle();
                    if (style == null) continue;
                    String indexStr = annotation.getLabel();
                    Matcher matcher = INDEX_EXTRACTOR.matcher(indexStr);
                    long index = annotation.getStartTime();
                    if (matcher.matches()) {
                        index = Long.parseLong(matcher.group(1));
                    }
                    boolean isApplicable = true;
                    String label = indexStr;
                    if (this.fAnnotationProvider instanceof PeriodicAnnotationSource) {
                        PeriodicAnnotationSource source = (PeriodicAnnotationSource)this.fAnnotationProvider;
                        isApplicable = source.isApplicable(index);
                        if (!this.fHasError) {
                            try {
                                label = String.format(indexStr, source.getBaseIndex() + index);
                            }
                            catch (IllegalFormatException e) {
                                Activator.getDefault().logError("Cannot format label for periodic marker ", e);
                                this.fHasError = true;
                            }
                        }
                    }
                    if (this.fAnnotationProvider instanceof CustomAnnotationProvider) {
                        CustomAnnotationProvider customAnnotationProvider = (CustomAnnotationProvider)this.fAnnotationProvider;
                        Map formatters = customAnnotationProvider.getLabel();
                        String format = (String)formatters.get(category);
                        if (!this.fHasError && format != null) {
                            try {
                                long val = Long.decode(indexStr);
                                label = String.format(format, val);
                            }
                            catch (NumberFormatException | IllegalFormatException e) {
                                Activator.getDefault().logError("Cannot format label for custom marker ", e);
                                this.fHasError = true;
                            }
                        }
                    }
                    if (!isApplicable) continue;
                    annotation = new Annotation(annotation.getTime(), annotation.getDuration(), annotation.getEntryId(), label, style);
                    RGBAColor rgbaColor = sm.getColorStyle(style, "color");
                    if (rgbaColor == null) continue;
                    RGBA color = RGBAUtil.fromRGBAColor(rgbaColor);
                    MarkerEvent marker = new MarkerEvent(null, annotation.getTime(), annotation.getDuration(), category, color, label, false);
                    markers.add(marker);
                }
            }
            return markers;
        }

        @Override
        public List<SubMarker> getSubMarkers() {
            if (this.fAnnotationProvider instanceof PeriodicAnnotationSource) {
                return ((PeriodicAnnotationSource)this.fAnnotationProvider).getMarker().getSubMarkers();
            }
            return Collections.emptyList();
        }
    }

    private static interface IConfigurableMarkerEventSource
    extends IMarkerEventSource {
        public List<SubMarker> getSubMarkers();
    }
}

