/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.base;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.Messages;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;

public class TmfEdge {
    private final TmfVertex fVertexFrom;
    private final TmfVertex fVertexTo;
    private EdgeType fType;
    private @Nullable String fQualifier = null;

    public TmfEdge(TmfVertex from, TmfVertex to) {
        this.fVertexFrom = from;
        this.fVertexTo = to;
        this.fType = EdgeType.DEFAULT;
    }

    public TmfVertex getVertexFrom() {
        return this.fVertexFrom;
    }

    public TmfVertex getVertexTo() {
        return this.fVertexTo;
    }

    public EdgeType getType() {
        return this.fType;
    }

    public void setType(EdgeType type) {
        this.fType = type;
    }

    public void setType(EdgeType type, @Nullable String linkQualifier) {
        this.fType = type;
        this.fQualifier = linkQualifier;
    }

    public @Nullable String getLinkQualifier() {
        return this.fQualifier;
    }

    public long getDuration() {
        return this.fVertexTo.getTs() - this.fVertexFrom.getTs();
    }

    public String toString() {
        return "[" + this.fVertexFrom + "--" + (Object)((Object)this.fType) + "->" + this.fVertexTo + "]";
    }

    public static enum EdgeType {
        EPS(String.valueOf(Messages.TmfEdge_Unknown), 64, 59, 51, 255, 1.0f, String.valueOf(Messages.TmfEdge_GroupBlocked)),
        UNKNOWN(String.valueOf(Messages.TmfEdge_Unknown), 64, 59, 51, 255, 1.0f, String.valueOf(Messages.TmfEdge_GroupBlocked)),
        DEFAULT(String.valueOf(Messages.TmfEdge_Unknown), 64, 59, 51, 255, 1.0f, String.valueOf(Messages.TmfEdge_GroupBlocked)),
        RUNNING(String.valueOf(Messages.TmfEdge_Running), 51, 153, 0, 255, 1.0f, String.valueOf(Messages.TmfEdge_GroupRunning)),
        BLOCKED(String.valueOf(Messages.TmfEdge_Blocked), 220, 20, 60, 255, 1.0f, String.valueOf(Messages.TmfEdge_GroupBlocked)),
        INTERRUPTED(String.valueOf(Messages.TmfEdge_Interrupted), 255, 220, 0, 255, 1.0f, String.valueOf(Messages.TmfEdge_GroupBlocked)),
        PREEMPTED(String.valueOf(Messages.TmfEdge_Preempted), 200, 100, 0, 255, 1.0f, String.valueOf(Messages.TmfEdge_GroupBlocked)),
        TIMER(String.valueOf(Messages.TmfEdge_Timer), 51, 102, 153, 255, 1.0f, String.valueOf(Messages.TmfEdge_GroupBlocked)),
        NETWORK(String.valueOf(Messages.TmfEdge_Network), 255, 155, 255, 255, 1.0f, String.valueOf(Messages.TmfEdge_GroupBlocked)),
        USER_INPUT(String.valueOf(Messages.TmfEdge_UserInput), 90, 1, 1, 255, 1.0f, String.valueOf(Messages.TmfEdge_GroupBlocked)),
        BLOCK_DEVICE(String.valueOf(Messages.TmfEdge_BlockDevice), 102, 0, 204, 255, 1.0f, String.valueOf(Messages.TmfEdge_GroupBlocked)),
        IPI(String.valueOf(Messages.TmfEdge_IPI), 102, 102, 204, 255, 1.0f, String.valueOf(Messages.TmfEdge_GroupBlocked));

        private final Map<String, Object> fMap;

        private EdgeType(String label, int red, int green, int blue, int alpha, float heightFactor, String group) {
            if (red > 255 || red < 0) {
                throw new IllegalArgumentException("Red needs to be between 0 and 255");
            }
            if (green > 255 || green < 0) {
                throw new IllegalArgumentException("Green needs to be between 0 and 255");
            }
            if (blue > 255 || blue < 0) {
                throw new IllegalArgumentException("Blue needs to be between 0 and 255");
            }
            if (alpha > 255 || alpha < 0) {
                throw new IllegalArgumentException("alpha needs to be between 0 and 255");
            }
            if ((double)heightFactor > 1.0 || heightFactor < 0.0f) {
                throw new IllegalArgumentException("Height factor needs to be between 0 and 1.0, given hint : " + heightFactor);
            }
            this.fMap = ImmutableMap.of((Object)"style-name", (Object)label, (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)red, (int)green, (int)blue), (Object)"height", (Object)Float.valueOf(heightFactor), (Object)"opacity", (Object)Float.valueOf((float)alpha / 255.0f), (Object)"style-group", (Object)group);
        }

        public Map<String, Object> toMap() {
            return this.fMap;
        }
    }
}

