/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.types;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ArrayDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ByteArrayDefinition;

public class SequenceDeclaration
extends CompoundDeclaration {
    private final IDeclaration fElemType;
    private final String fLengthName;
    private final transient Multimap<String, String> fPaths = ArrayListMultimap.create();

    public SequenceDeclaration(@Nullable String lengthName, IDeclaration elemType) {
        this.fElemType = elemType;
        this.fLengthName = lengthName;
    }

    @Override
    public IDeclaration getElementType() {
        return this.fElemType;
    }

    public String getLengthName() {
        return this.fLengthName;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public AbstractArrayDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        IDefinition lenDef = null;
        if (definitionScope != null) {
            lenDef = definitionScope.lookupDefinition(this.getLengthName());
        }
        if (lenDef == null) {
            throw new CTFException("Sequence length field not found");
        }
        if (!(lenDef instanceof IntegerDefinition)) {
            throw new CTFException("Sequence length field not integer");
        }
        IntegerDefinition lengthDefinition = (IntegerDefinition)lenDef;
        if (lengthDefinition.getDeclaration().isSigned()) {
            throw new CTFException("Sequence length must not be signed");
        }
        long length = lengthDefinition.getValue();
        long maxBits = length * (long)this.fElemType.getMaximumSize();
        if (length > Integer.MAX_VALUE || maxBits > Integer.MAX_VALUE || !input.canRead((int)maxBits)) {
            throw new CTFException("Sequence length too long " + length);
        }
        if (this.isAlignedBytes()) {
            byte[] data = new byte[(int)length];
            input.get(data);
            return new ByteArrayDefinition(this, definitionScope, fieldName, data);
        }
        Collection collection = this.fPaths.get((Object)fieldName);
        while ((long)collection.size() < length) {
            this.fPaths.put((Object)fieldName, (Object)(String.valueOf(fieldName) + '[' + collection.size() + ']'));
        }
        List paths = (List)this.fPaths.get((Object)fieldName);
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ImmutableList.Builder definitions = new ImmutableList.Builder();
        int i = 0;
        while ((long)i < length) {
            String elemName = (String)NonNullUtils.checkNotNull((Object)((String)paths.get(i)));
            definitions.add((Object)this.fElemType.createDefinition(definitionScope, elemName, input));
            ++i;
        }
        @NonNull ImmutableList list = definitions.build();
        return new ArrayDefinition(this, definitionScope, fieldName, (List<Definition>)list);
    }

    public String toString() {
        return "[declaration] sequence[" + Integer.toHexString(this.hashCode()) + ']';
    }

    @Override
    public int getMaximumSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fElemType.hashCode();
        result = 31 * result + this.fLengthName.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceDeclaration other = (SequenceDeclaration)obj;
        if (!this.fElemType.equals(other.fElemType)) {
            return false;
        }
        return this.fLengthName.equals(other.fLengthName);
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceDeclaration other = (SequenceDeclaration)obj;
        if (!this.fElemType.isBinaryEquivalent(other.fElemType)) {
            return false;
        }
        return this.fLengthName.equals(other.fLengthName);
    }
}

