/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.TraceManagerService;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

@Path(value="/experiments")
public class ExperimentManagerService {
    private static final String EXPERIMENTS = "experiments";

    @GET
    @Produces(value={"application/json"})
    public Response getExperiments() {
        return Response.ok((Object)Collections2.filter((Collection)TmfTraceManager.getInstance().getOpenedTraces(), TmfExperiment.class::isInstance)).build();
    }

    @GET
    @Path(value="/{uuid}")
    @Produces(value={"application/json"})
    public Response getExperiment(@PathParam(value="uuid") UUID uuid) {
        ITmfTrace experiment = TraceManagerService.getTraceByUUID(uuid);
        if (experiment instanceof TmfExperiment) {
            return Response.ok((Object)experiment).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{uuid}/outputs")
    @Produces(value={"application/json"})
    public Response getOutputs(@PathParam(value="uuid") UUID uuid) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)("Not implemented for " + uuid)).build();
    }

    @DELETE
    @Path(value="/{uuid}")
    @Produces(value={"application/json"})
    public Response deleteExperiment(@PathParam(value="uuid") UUID uuid) {
        ITmfTrace experiment = TraceManagerService.getTraceByUUID(uuid);
        if (experiment instanceof TmfExperiment) {
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceClosedSignal((Object)this, experiment));
            experiment.dispose();
            return Response.ok((Object)experiment).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response postExperiment(@FormParam(value="name") String name, @FormParam(value="traces") List<UUID> traceUUIDs) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath ipath = root.getLocation().append(EXPERIMENTS).append(name);
        IResource resource = root.findMember(ipath);
        if (Iterables.any((Iterable)TmfTraceManager.getInstance().getOpenedTraces(), t -> t.getPath().equals(ipath.toOSString()))) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("There is already an experiment named: " + name)).build();
        }
        ITmfTrace[] array = new ITmfTrace[traceUUIDs.size()];
        int i = 0;
        for (UUID uuid : traceUUIDs) {
            ITmfTrace trace = TraceManagerService.getTraceByUUID(uuid);
            if (trace == null) {
                return Response.noContent().build();
            }
            try {
                ITmfTrace clone = (ITmfTrace)trace.getClass().newInstance();
                clone.initTrace(trace.getResource(), trace.getPath(), ITmfEvent.class, trace.getName(), trace.getTraceTypeId());
                array[i++] = clone;
            }
            catch (IllegalAccessException | InstantiationException | TmfTraceException e) {
                return Response.serverError().entity((Object)e.getMessage()).build();
            }
        }
        TmfExperiment experiment = new TmfExperiment(ITmfEvent.class, ipath.toOSString(), array, 5000, resource);
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal((Object)this, (ITmfTrace)experiment, null));
        return Response.ok((Object)experiment).build();
    }
}

