/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;

public abstract class GuavaCollectionDeserializer<T>
extends StdDeserializer<T>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final CollectionType _containerType;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _typeDeserializerForValue;

    protected GuavaCollectionDeserializer(CollectionType type, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        super((JavaType)type);
        this._containerType = type;
        this._typeDeserializerForValue = typeDeser;
        this._valueDeserializer = deser;
    }

    public abstract GuavaCollectionDeserializer<T> withResolved(TypeDeserializer var1, JsonDeserializer<?> var2);

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._typeDeserializerForValue;
        if (deser == null) {
            deser = ctxt.findContextualValueDeserializer(this._containerType.getContentType(), property);
        }
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        if (deser == this._valueDeserializer && typeDeser == this._typeDeserializerForValue) {
            return this;
        }
        return this.withResolved(typeDeser, deser);
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromArray(jp, ctxt);
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.isExpectedStartArrayToken()) {
            return this._deserializeContents(jp, ctxt);
        }
        if (ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            return this._deserializeFromSingleValue(jp, ctxt);
        }
        throw ctxt.mappingException(this._containerType.getRawClass());
    }

    protected abstract T _deserializeContents(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    protected abstract T _deserializeFromSingleValue(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;
}

