/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TraceSerializer
extends StdSerializer<ITmfTrace> {
    private static final long serialVersionUID = 9170252203750031947L;

    public TraceSerializer() {
        super(ITmfTrace.class);
    }

    public void serialize(ITmfTrace value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("name", value.getName());
        gen.writeStringField("path", value.getPath());
        gen.writeStringField("UUID", Objects.requireNonNull(value.getUUID()).toString());
        gen.writeNumberField("nbEvents", value.getNbEvents());
        gen.writeNumberField("start", value.getStartTime().toNanos());
        gen.writeNumberField("end", value.getEndTime().toNanos());
        String indexingStatus = value.isIndexing() ? "RUNNING" : "COMPLETED";
        gen.writeStringField("indexingStatus", indexingStatus);
        gen.writeEndObject();
    }
}

