/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.interval.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Base64;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.internal.statesystem.core.interval.json.TmfIntervalStrings;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public class TmfIntervalDeserializer
implements JsonDeserializer<ITmfStateInterval> {
    public ITmfStateInterval deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        JsonObject object = json.getAsJsonObject();
        long start = object.get("start").getAsLong();
        long end = object.get("end").getAsLong();
        int quark = object.get("quark").getAsInt();
        String type = object.get("type").getAsString();
        if (type.equals(TmfIntervalStrings.NULL)) {
            return new TmfStateInterval(start, end, quark, null);
        }
        JsonElement value = object.get("value");
        try {
            Class<Object> typeClass = Class.forName(type);
            if (typeClass.isAssignableFrom(CustomStateValue.class)) {
                String encoded = value.getAsString();
                byte[] serialized = Base64.getDecoder().decode(encoded);
                ByteBuffer buffer = ByteBuffer.wrap(serialized);
                ISafeByteBufferReader sbbr = SafeByteBufferFactory.wrapReader((ByteBuffer)buffer, (int)serialized.length);
                TmfStateValue sv = CustomStateValue.readSerializedValue(sbbr);
                return new TmfStateInterval(start, end, quark, sv.unboxValue());
            }
            if (typeClass.isAssignableFrom(Integer.class)) {
                return new TmfStateInterval(start, end, quark, value.getAsInt());
            }
            if (typeClass.isAssignableFrom(Long.class)) {
                return new TmfStateInterval(start, end, quark, value.getAsLong());
            }
            if (typeClass.isAssignableFrom(Double.class)) {
                return new TmfStateInterval(start, end, quark, value.getAsDouble());
            }
            if (typeClass.isAssignableFrom(String.class)) {
                return new TmfStateInterval(start, end, quark, value.getAsString());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new TmfStateInterval(start, end, quark, value.toString());
    }
}

