/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.settings.model.util.Comparator;

public class ListComparator {
    private static Comparator fDefaultComparator;

    public static Comparator getDefaultComparator() {
        if (fDefaultComparator == null) {
            fDefaultComparator = new Comparator();
        }
        return fDefaultComparator;
    }

    public static List[] compare(Object[] a1, Object[] a2) {
        return ListComparator.compare(a1, a2, ListComparator.getDefaultComparator());
    }

    public static List[] compare(Object[] a1, Object[] a2, Comparator c) {
        List added = ListComparator.getAdded(a1, a2, c);
        List removed = ListComparator.getAdded(a2, a1, c);
        if (added == null && removed == null) {
            return null;
        }
        return new List[]{added, removed};
    }

    public static List getAdded(Object[] a1, Object[] a2) {
        return ListComparator.getAdded(a1, a2, ListComparator.getDefaultComparator());
    }

    public static List getAdded(Object[] a1, Object[] a2, Comparator c) {
        if (a1 == null || a1.length == 0) {
            return null;
        }
        if (a2 == null || a2.length == 0) {
            ArrayList<Object> list = new ArrayList<Object>(a1.length);
            int i = 0;
            while (i < a1.length) {
                list.add(a1[i]);
                ++i;
            }
            return list;
        }
        ArrayList<Object> list = new ArrayList<Object>(a1.length);
        int i = 0;
        while (i < a1.length) {
            Object o1 = a1[i];
            int j = 0;
            while (j < a2.length) {
                if (!c.equal(o1, a2[j])) {
                    list.add(o1);
                }
                ++j;
            }
            ++i;
        }
        return list.size() != 0 ? list : null;
    }

    public static boolean match(Object[] a1, Object[] a2, Comparator c) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        int size = a1.length;
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(a1));
        ArrayList<Object> otherList = new ArrayList<Object>(Arrays.asList(a2));
        int i = size - 1;
        while (i >= 0) {
            Object o1 = list.remove(i);
            int j = i;
            while (j >= 0) {
                if (c.equal(o1, otherList.get(j))) {
                    otherList.remove(j);
                    break;
                }
                --j;
            }
            if (j < 0) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static int indexOf(Object o, Object[] a) {
        return ListComparator.indexOf(o, a, ListComparator.getDefaultComparator());
    }

    public static int indexOf(Object o, Object[] a, Comparator c) {
        int i = 0;
        while (i < a.length) {
            if (c.equal(a[i], o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean haveMatches(Object[] a1, Object[] a2) {
        return ListComparator.haveMatches(a1, a2, ListComparator.getDefaultComparator());
    }

    public static boolean haveMatches(Object[] a1, Object[] a2, Comparator c) {
        int i = 0;
        while (i < a1.length) {
            if (ListComparator.indexOf(a1[i], a2, c) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

