/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup.containers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class DirectorySourceContainer
extends CompositeSourceContainer {
    private final File fDirectory;
    private boolean fSubfolders = false;
    public static final String TYPE_ID = DebugPlugin.getUniqueIdentifier() + ".containerType.directory";

    public DirectorySourceContainer(IPath dirPath, boolean subfolders) {
        this(dirPath.toFile(), subfolders);
    }

    public DirectorySourceContainer(File dir, boolean subfolders) {
        this.fDirectory = dir;
        this.fSubfolders = subfolders;
    }

    @Override
    public String getName() {
        return this.fDirectory.getName();
    }

    public File getDirectory() {
        return this.fDirectory;
    }

    @Override
    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    @Override
    public Object[] findSourceElements(String name) throws CoreException {
        ArrayList<Object> sources = new ArrayList<Object>();
        File directory = this.getDirectory();
        File file = new File(directory, name);
        if (file.exists() && file.isFile()) {
            sources.add((Object)new LocalFileStorage(file));
        }
        if (this.isFindDuplicates() && this.fSubfolders || sources.isEmpty() && this.fSubfolders) {
            ISourceContainer[] containers;
            ISourceContainer[] iSourceContainerArray = containers = this.getSourceContainers();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer container = iSourceContainerArray[n2];
                Object[] objects = container.findSourceElements(name);
                if (objects != null && objects.length != 0) {
                    if (this.isFindDuplicates()) {
                        Collections.addAll(sources, objects);
                    } else {
                        sources.add(objects[0]);
                        break;
                    }
                }
                ++n2;
            }
        }
        if (sources.isEmpty()) {
            return EMPTY;
        }
        return sources.toArray();
    }

    @Override
    public boolean isComposite() {
        return this.fSubfolders;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DirectorySourceContainer) {
            DirectorySourceContainer container = (DirectorySourceContainer)obj;
            return container.getDirectory().equals(this.getDirectory());
        }
        return false;
    }

    public int hashCode() {
        return this.getDirectory().hashCode();
    }

    @Override
    protected ISourceContainer[] createSourceContainers() throws CoreException {
        String[] files;
        if (this.isComposite() && (files = this.fDirectory.list()) != null) {
            ISourceContainer[] containers;
            ArrayList<DirectorySourceContainer> dirs = new ArrayList<DirectorySourceContainer>();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                File file = new File(this.getDirectory(), name);
                if (file.exists() && file.isDirectory()) {
                    dirs.add(new DirectorySourceContainer(file, true));
                }
                ++n2;
            }
            ISourceContainer[] iSourceContainerArray = containers = dirs.toArray(new ISourceContainer[dirs.size()]);
            int n3 = containers.length;
            n = 0;
            while (n < n3) {
                ISourceContainer container = iSourceContainerArray[n];
                container.init(this.getDirector());
                ++n;
            }
            return containers;
        }
        return new ISourceContainer[0];
    }
}

