/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeChunkyOutputStream;
import org.eclipse.core.internal.resources.BuildConfiguration;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.ModelObjectWriter;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class LocalMetaArea
implements ICoreConstants {
    static final String F_BACKUP_FILE_EXTENSION = ".bak";
    static final String F_DESCRIPTION = ".workspace";
    static final String F_HISTORY_STORE = ".history";
    static final String F_MARKERS = ".markers";
    static final String F_OLD_PROJECT = ".prj";
    static final String F_PROJECT_LOCATION = ".location";
    static final String F_PROJECTS = ".projects";
    static final String F_PROPERTIES = ".properties";
    static final String F_REFRESH = ".refresh";
    static final String F_ROOT = ".root";
    static final String F_SAFE_TABLE = ".safetable";
    static final String F_SNAP = ".snap";
    static final String F_SNAP_EXTENSION = "snap";
    static final String F_SYNCINFO = ".syncinfo";
    static final String F_TREE = ".tree";
    static final String URI_PREFIX = "URI//";
    static final String F_METADATA = ".metadata";
    protected final IPath metaAreaLocation;
    protected final IPath projectMetaLocation;
    private final Workspace workspace;

    public LocalMetaArea(Workspace workspace) {
        this.workspace = workspace;
        this.metaAreaLocation = ResourcesPlugin.getPlugin().getStateLocation();
        this.projectMetaLocation = this.metaAreaLocation.append(F_PROJECTS);
    }

    public void clearOldDescription(IProject target) {
        Workspace.clear(this.getOldDescriptionLocationFor(target).toFile());
    }

    public void clearRefresh(IProject target) {
        Workspace.clear(this.getRefreshLocationFor(target).toFile());
    }

    public void create(IProject target) {
        File file = this.locationFor(target).toFile();
        Workspace.clear(file);
        file.mkdirs();
    }

    public synchronized void createMetaArea() throws CoreException {
        File workspaceLocation = this.metaAreaLocation.toFile();
        Workspace.clear(workspaceLocation);
        if (!workspaceLocation.mkdirs()) {
            String message = NLS.bind((String)Messages.resources_writeWorkspaceMeta, (Object)workspaceLocation);
            throw new ResourceException(568, null, message, null);
        }
    }

    public void delete(IProject target) throws CoreException {
        IPath path = this.locationFor(target);
        if (!Workspace.clear(path.toFile()) && path.toFile().exists()) {
            String message = NLS.bind((String)Messages.resources_deleteMeta, (Object)target.getFullPath());
            throw new ResourceException(569, target.getFullPath(), message, null);
        }
    }

    public IPath getBackupLocationFor(IPath file) {
        return file.removeLastSegments(1).append(file.lastSegment() + F_BACKUP_FILE_EXTENSION);
    }

    public IPath getHistoryStoreLocation() {
        return this.metaAreaLocation.append(F_HISTORY_STORE);
    }

    public IPath getLocation() {
        return this.metaAreaLocation;
    }

    public IPath getMarkersLocationFor(IResource resource) {
        Assert.isNotNull((Object)resource);
        Assert.isLegal((resource.getType() == 8 || resource.getType() == 4 ? 1 : 0) != 0);
        return this.locationFor(resource).append(F_MARKERS);
    }

    public IPath getMarkersSnapshotLocationFor(IResource resource) {
        return this.getMarkersLocationFor(resource).addFileExtension(F_SNAP_EXTENSION);
    }

    public IPath getOldDescriptionLocationFor(IProject target) {
        return this.locationFor(target).append(F_OLD_PROJECT);
    }

    public IPath getPropertyStoreLocation(IResource resource) {
        int type = resource.getType();
        Assert.isTrue((type != 1 && type != 2 ? 1 : 0) != 0);
        return this.locationFor(resource).append(F_PROPERTIES);
    }

    public IPath getRefreshLocationFor(IProject project) {
        Assert.isNotNull((Object)project);
        return this.locationFor(project).append(F_REFRESH);
    }

    public IPath getSafeTableLocationFor(String pluginId) {
        IPath prefix = this.metaAreaLocation.append(F_SAFE_TABLE);
        if (pluginId.equals("org.eclipse.core.resources")) {
            return prefix.append(pluginId);
        }
        int saveNumber = this.getWorkspace().getSaveManager().getSaveNumber(pluginId);
        return prefix.append(pluginId + "." + saveNumber);
    }

    public IPath getSnapshotLocationFor(IResource resource) {
        Assert.isNotNull((Object)resource);
        Assert.isLegal((resource.getType() == 8 ? 1 : 0) != 0);
        IPath key = resource.getFullPath().append(F_TREE);
        String sequenceNumber = this.getWorkspace().getSaveManager().getMasterTable().getProperty(key.toString());
        if (sequenceNumber == null) {
            sequenceNumber = "0";
        }
        return this.metaAreaLocation.append(sequenceNumber + F_SNAP);
    }

    public IPath getLegacySnapshotLocationFor(IResource resource) {
        Assert.isNotNull((Object)resource);
        Assert.isLegal((resource.getType() == 8 ? 1 : 0) != 0);
        return this.metaAreaLocation.append(F_SNAP);
    }

    public IPath getSyncInfoLocationFor(IResource resource) {
        Assert.isNotNull((Object)resource);
        Assert.isLegal((resource.getType() == 8 || resource.getType() == 4 ? 1 : 0) != 0);
        return this.locationFor(resource).append(F_SYNCINFO);
    }

    public IPath getSyncInfoSnapshotLocationFor(IResource resource) {
        return this.getSyncInfoLocationFor(resource).addFileExtension(F_SNAP_EXTENSION);
    }

    public IPath getTreeLocationFor(IResource target, boolean updateSequenceNumber) {
        IPath key = target.getFullPath().append(F_TREE);
        String sequenceNumber = this.getWorkspace().getSaveManager().getMasterTable().getProperty(key.toString());
        if (sequenceNumber == null) {
            sequenceNumber = "0";
        }
        if (updateSequenceNumber) {
            int n = Integer.parseInt(sequenceNumber) + 1;
            n = n < 0 ? 1 : n;
            sequenceNumber = Integer.toString(n);
            this.getWorkspace().getSaveManager().getMasterTable().setProperty(key.toString(), sequenceNumber);
        }
        return this.locationFor(target).append(sequenceNumber + F_TREE);
    }

    public IPath getWorkingLocation(IResource resource, String id) {
        return this.locationFor(resource).append(id);
    }

    protected Workspace getWorkspace() {
        return this.workspace;
    }

    public boolean hasSavedProject(IProject project) {
        return this.getOldDescriptionLocationFor(project).toFile().exists() || this.locationFor(project).append(F_PROJECT_LOCATION).toFile().exists();
    }

    public boolean hasSavedWorkspace() {
        return this.metaAreaLocation.toFile().exists() || this.getBackupLocationFor(this.metaAreaLocation).toFile().exists();
    }

    public boolean hasSavedProjects() {
        return this.projectMetaLocation.toFile().exists();
    }

    public IPath locationFor(IPath resourcePath) {
        if (IPath.ROOT.equals((Object)resourcePath)) {
            return this.metaAreaLocation.append(F_ROOT);
        }
        return this.projectMetaLocation.append(resourcePath.segment(0));
    }

    public IPath locationFor(IResource resource) {
        if (resource.getType() == 8) {
            return this.metaAreaLocation.append(F_ROOT);
        }
        return this.projectMetaLocation.append(resource.getProject().getName());
    }

    public ProjectDescription readOldDescription(IProject project) throws CoreException {
        IPath path = this.getOldDescriptionLocationFor(project);
        if (!path.toFile().exists()) {
            return null;
        }
        IPath tempPath = this.getBackupLocationFor(path);
        ProjectDescription description = null;
        try {
            description = new ProjectDescriptionReader(project).read(path, tempPath);
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.resources_readMeta, (Object)project.getName());
            throw new ResourceException(567, project.getFullPath(), msg, e);
        }
        if (description == null) {
            String msg = NLS.bind((String)Messages.resources_readMeta, (Object)project.getName());
            throw new ResourceException(567, project.getFullPath(), msg, null);
        }
        return description;
    }

    public void readPrivateDescription(IProject target, ProjectDescription description) {
        IPath locationFile = this.locationFor(target).append(F_PROJECT_LOCATION);
        File file = locationFile.toFile();
        if (!file.exists() && !(file = (locationFile = this.getBackupLocationFor(locationFile)).toFile()).exists()) {
            return;
        }
        try {
            this.readFromFile(target, description, file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readFromFile(IProject target, ProjectDescription description, File file) throws IOException {
        description.setName(target.getName());
        Throwable throwable = null;
        Object var5_6 = null;
        try (DataInputStream dataIn = new DataInputStream(new SafeChunkyInputStream(file, 500));){
            try {
                String location = dataIn.readUTF();
                if (location.length() > 0) {
                    if (location.startsWith(URI_PREFIX)) {
                        description.setLocationURI(URI.create(location.substring(URI_PREFIX.length())));
                    } else {
                        description.setLocationURI(URIUtil.toURI((IPath)IPath.fromOSString((String)location)));
                    }
                }
            }
            catch (Exception e) {
                String msg = NLS.bind((String)Messages.resources_exReadProjectLocation, (Object)target.getName());
                Policy.log(new ResourceStatus(4, 567, target.getFullPath(), msg, e));
            }
            int numRefs = dataIn.readInt();
            IProject[] references = new IProject[numRefs];
            IWorkspaceRoot root = this.getWorkspace().getRoot();
            int i = 0;
            while (i < numRefs) {
                references[i] = root.getProject(dataIn.readUTF());
                ++i;
            }
            description.setDynamicReferences(references);
            String[] configs = new String[dataIn.readInt()];
            int i2 = 0;
            while (i2 < configs.length) {
                configs[i2] = dataIn.readUTF();
                ++i2;
            }
            if (configs.length > 0) {
                description.setBuildConfigs(configs);
            }
            description.setActiveBuildConfig(dataIn.readUTF());
            int numBuildConifgsWithRefs = dataIn.readInt();
            HashMap<String, IBuildConfiguration[]> m = new HashMap<String, IBuildConfiguration[]>(numBuildConifgsWithRefs);
            int i3 = 0;
            while (i3 < numBuildConifgsWithRefs) {
                String configName = dataIn.readUTF();
                numRefs = dataIn.readInt();
                IBuildConfiguration[] refs = new IBuildConfiguration[numRefs];
                int j = 0;
                while (j < numRefs) {
                    String projName = dataIn.readUTF();
                    refs[j] = dataIn.readBoolean() ? new BuildConfiguration(root.getProject(projName), dataIn.readUTF()) : new BuildConfiguration(root.getProject(projName), null);
                    ++j;
                }
                m.put(configName, refs);
                ++i3;
            }
            description.setBuildConfigReferences(m);
            int natures = dataIn.readInt();
            String[] natureIds = new String[natures];
            int i4 = 0;
            while (i4 < natures) {
                natureIds[i4] = dataIn.readUTF();
                ++i4;
            }
            description.setNatureIds(natureIds);
            int buildspecs = dataIn.readInt();
            ICommand[] buildSpecData = new ICommand[buildspecs];
            int i5 = 0;
            while (i5 < buildspecs) {
                BuildCommand command = new BuildCommand();
                buildSpecData[i5] = command;
                int type = dataIn.read();
                if (type == 1) {
                    command.setName(dataIn.readUTF());
                    int args = dataIn.readInt();
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    int j = 0;
                    while (j < args) {
                        map.put(dataIn.readUTF(), dataIn.readUTF());
                        ++j;
                    }
                    command.setArguments(map);
                    String trigger = dataIn.readUTF();
                    if (!trigger.isEmpty()) {
                        ProjectDescriptionReader.parseBuildTriggers(command, trigger);
                    }
                }
                ++i5;
            }
            description.setBuildSpec(buildSpecData);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void writePrivateDescription(IProject target) throws CoreException {
        IPath location = this.locationFor(target).append(F_PROJECT_LOCATION);
        File file = location.toFile();
        Workspace.clear(file);
        ProjectDescription desc = ((Project)target).internalGetDescription();
        try {
            this.writeToFile(desc, file);
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.resources_exSaveProjectLocation, (Object)target.getName());
            throw new ResourceException(566, null, message, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeToFile(ProjectDescription desc, File file) throws IOException {
        if (desc == null) {
            return;
        }
        URI projectLocation = desc.getLocationURI();
        IProject[] prjRefs = desc.getDynamicReferences(false);
        String[] buildConfigs = desc.configNames;
        Map<String, IBuildConfiguration[]> configRefs = desc.getBuildConfigReferences(false);
        String[] natureIds = desc.getNatureIds();
        ICommand[] buildSpec = desc.getBuildSpec(false);
        if (projectLocation == null && prjRefs.length == 0 && buildConfigs.length == 0 && configRefs.isEmpty() && natureIds.length == 0 && buildSpec.length == 0) {
            return;
        }
        Throwable throwable = null;
        Object var10_11 = null;
        try {
            SafeChunkyOutputStream output = new SafeChunkyOutputStream(file);
            try {
                try (DataOutputStream dataOut = new DataOutputStream(output);){
                    if (projectLocation == null) {
                        dataOut.writeUTF("");
                    } else {
                        dataOut.writeUTF(URI_PREFIX + String.valueOf(projectLocation));
                    }
                    dataOut.writeInt(prjRefs.length);
                    Object[] objectArray = prjRefs;
                    int n = prjRefs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject prjRef = objectArray[n2];
                        dataOut.writeUTF(prjRef.getName());
                        ++n2;
                    }
                    dataOut.writeInt(buildConfigs.length);
                    objectArray = buildConfigs;
                    n = buildConfigs.length;
                    n2 = 0;
                    while (n2 < n) {
                        Object buildConfig = objectArray[n2];
                        dataOut.writeUTF((String)buildConfig);
                        ++n2;
                    }
                    dataOut.writeUTF(desc.getActiveBuildConfig());
                    dataOut.writeInt(configRefs.size());
                    for (Map.Entry<String, IBuildConfiguration[]> e : configRefs.entrySet()) {
                        String refdName = e.getKey();
                        IBuildConfiguration[] refs = e.getValue();
                        dataOut.writeUTF(refdName);
                        dataOut.writeInt(refs.length);
                        IBuildConfiguration[] iBuildConfigurationArray = refs;
                        int n3 = refs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IBuildConfiguration ref = iBuildConfigurationArray[n4];
                            dataOut.writeUTF(ref.getProject().getName());
                            if (ref.getName() == null) {
                                dataOut.writeBoolean(false);
                            } else {
                                dataOut.writeBoolean(true);
                                dataOut.writeUTF(ref.getName());
                            }
                            ++n4;
                        }
                    }
                    dataOut.writeInt(natureIds.length);
                    objectArray = natureIds;
                    int n5 = natureIds.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Object id = objectArray[n6];
                        dataOut.writeUTF((String)id);
                        ++n6;
                    }
                    dataOut.writeInt(buildSpec.length);
                    objectArray = buildSpec;
                    n5 = buildSpec.length;
                    n6 = 0;
                    while (n6 < n5) {
                        Object command = objectArray[n6];
                        if (command instanceof BuildCommand) {
                            BuildCommand b = (BuildCommand)command;
                            dataOut.write(1);
                            dataOut.writeUTF(b.getName());
                            Map<String, String> arguments = b.getArguments();
                            dataOut.writeInt(arguments.size());
                            for (Map.Entry entry : arguments.entrySet()) {
                                dataOut.writeUTF((String)entry.getKey());
                                dataOut.writeUTF((String)entry.getValue());
                            }
                            if (ModelObjectWriter.shouldWriteTriggers(b)) {
                                dataOut.writeUTF(ModelObjectWriter.triggerString(b));
                            } else {
                                dataOut.writeUTF("");
                            }
                        } else {
                            dataOut.write(0);
                        }
                        ++n6;
                    }
                    dataOut.flush();
                    output.succeed();
                }
                if (output == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (output == null) throw throwable;
                output.close();
                throw throwable;
            }
            output.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

