/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.structuremergeviewer;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.DiffViewerComparator;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class DiffTreeViewer
extends TreeViewer {
    private ResourceBundle fBundle;
    private CompareConfiguration fCompareConfiguration;
    private IPropertyChangeListener fPropertyChangeListener;
    private DiffViewerLabelProvider diffViewerLabelProvider = new DiffViewerLabelProvider();
    private Action fEmptyMenuAction;
    private Action fExpandAllAction;

    public DiffTreeViewer(Tree tree, CompareConfiguration configuration) {
        super(tree);
        this.initialize(configuration == null ? new CompareConfiguration() : configuration);
    }

    public DiffTreeViewer(Composite parent, CompareConfiguration configuration) {
        super(new Tree(parent, 2));
        this.initialize(configuration == null ? new CompareConfiguration() : configuration);
    }

    private void initialize(CompareConfiguration configuration) {
        Control tree = this.getControl();
        INavigatable nav = new INavigatable(){

            @Override
            public boolean selectChange(int flag) {
                if (flag == 3) {
                    DiffTreeViewer.this.setSelection((ISelection)StructuredSelection.EMPTY);
                    flag = 1;
                } else if (flag == 4) {
                    DiffTreeViewer.this.setSelection((ISelection)StructuredSelection.EMPTY);
                    flag = 2;
                }
                return DiffTreeViewer.this.internalNavigate(flag == 1, true);
            }

            @Override
            public Object getInput() {
                return DiffTreeViewer.this.getInput();
            }

            @Override
            public boolean openSelectedChange() {
                return DiffTreeViewer.this.internalOpen();
            }

            @Override
            public boolean hasChange(int changeFlag) {
                return DiffTreeViewer.this.getNextItem(changeFlag == 1, false) != null;
            }
        };
        tree.setData("org.eclipse.compare.internal.Navigator", (Object)nav);
        tree.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)this.getTitle());
        Composite parent = tree.getParent();
        this.fBundle = ResourceBundle.getBundle("org.eclipse.compare.structuremergeviewer.DiffTreeViewerResources");
        this.fCompareConfiguration = configuration;
        if (this.fCompareConfiguration != null) {
            this.fPropertyChangeListener = this::propertyChange;
            this.fCompareConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
        }
        this.setContentProvider((IContentProvider)new DiffViewerContentProvider());
        this.setLabelProvider((IBaseLabelProvider)this.diffViewerLabelProvider);
        this.addSelectionChangedListener(event -> this.updateActions());
        this.setComparator((ViewerComparator)new DiffViewerComparator());
        ToolBarManager tbm = CompareViewerPane.getToolBarManager(parent);
        if (tbm != null) {
            tbm.removeAll();
            tbm.add((IContributionItem)new Separator("merge"));
            tbm.add((IContributionItem)new Separator("modes"));
            tbm.add((IContributionItem)new Separator("navigation"));
            this.createToolItems(tbm);
            this.updateActions();
            tbm.update(true);
        }
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(mm2 -> {
            this.fillContextMenu(mm2);
            if (mm2.isEmpty()) {
                if (this.fEmptyMenuAction == null) {
                    this.fEmptyMenuAction = new Action(Utilities.getString(this.fBundle, "emptyMenuItem")){};
                    this.fEmptyMenuAction.setEnabled(false);
                }
                mm2.add((IAction)this.fEmptyMenuAction);
            }
        });
        tree.setMenu(mm.createContextMenu(tree));
    }

    public String getTitle() {
        String title = Utilities.getString(this.fBundle, "title", null);
        if (title == null) {
            title = Utilities.getString("DiffTreeViewer.title");
        }
        return title;
    }

    protected ResourceBundle getBundle() {
        return this.fBundle;
    }

    public CompareConfiguration getCompareConfiguration() {
        return this.fCompareConfiguration;
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.fCompareConfiguration != null) {
            if (this.fPropertyChangeListener != null) {
                this.fCompareConfiguration.removePropertyChangeListener(this.fPropertyChangeListener);
            }
            this.fCompareConfiguration = null;
        }
        this.fPropertyChangeListener = null;
        super.handleDispose(event);
    }

    protected void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("MIRRORED")) {
            this.diffViewerLabelProvider.fireLabelProviderChanged();
        }
    }

    protected void inputChanged(Object in, Object oldInput) {
        super.inputChanged(in, oldInput);
        if (in != oldInput) {
            this.initialSelection();
            this.updateActions();
        }
    }

    protected void initialSelection() {
        this.navigate(true);
    }

    protected void internalExpandToLevel(Widget node, int level) {
        Object data = node.getData();
        if (this.dontExpand(data)) {
            return;
        }
        super.internalExpandToLevel(node, level);
    }

    protected boolean dontExpand(Object o) {
        return o instanceof DiffNode && ((DiffNode)o).dontExpand();
    }

    protected void createToolItems(ToolBarManager toolbarManager) {
    }

    protected void fillContextMenu(IMenuManager manager) {
        if (this.fExpandAllAction == null) {
            this.fExpandAllAction = new Action(){

                public void run() {
                    DiffTreeViewer.this.expandSelection();
                }
            };
            Utilities.initAction((IAction)this.fExpandAllAction, this.fBundle, "action.ExpandAll.");
        }
        boolean enable = false;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                if (!(element instanceof IDiffContainer) || !((IDiffContainer)element).hasChildren()) continue;
                enable = true;
                break;
            }
        }
        this.fExpandAllAction.setEnabled(enable);
        manager.add((IAction)this.fExpandAllAction);
    }

    protected void expandSelection() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object next : (IStructuredSelection)selection) {
                this.expandToLevel(next, -1);
            }
        }
    }

    protected void copySelected(boolean leftToRight) {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                if (!(element instanceof ICompareInput)) continue;
                this.copyOne((ICompareInput)element, leftToRight);
            }
        }
    }

    protected void copyOne(ICompareInput node, boolean leftToRight) {
        node.copy(leftToRight);
        this.update(new Object[]{node}, null);
    }

    protected void navigate(boolean next) {
        this.internalNavigate(next, false);
    }

    private boolean internalNavigate(boolean next, boolean fireOpen) {
        Control c = this.getControl();
        if (!(c instanceof Tree) || c.isDisposed()) {
            return false;
        }
        TreeItem item = this.getNextItem(next, true);
        if (item != null) {
            this.internalSetSelection(item, fireOpen);
        }
        return item == null;
    }

    private TreeItem getNextItem(boolean next, boolean expand) {
        Control c = this.getControl();
        if (!(c instanceof Tree) || c.isDisposed()) {
            return null;
        }
        Tree tree = (Tree)c;
        TreeItem item = null;
        TreeItem[] children = tree.getSelection();
        if (children != null && children.length != 0) {
            item = children[0];
        }
        if (item == null && (children = tree.getItems()) != null && children.length != 0 && (item = children[0]) != null && item.getItemCount() <= 0) {
            return item;
        }
        while ((item = this.findNextPrev(item, next, expand)) != null && item.getItemCount() > 0) {
        }
        return item;
    }

    /*
     * Unable to fully structure code
     */
    private TreeItem findNextPrev(TreeItem item, boolean next, boolean expand) {
        block12: {
            block11: {
                if (item == null) {
                    return null;
                }
                children = null;
                if (next) break block11;
                parent = item.getParentItem();
                children = parent != null ? parent.getItems() : item.getParent().getItems();
                if (children != null && children.length > 0) {
                    index = 0;
                    while (index < children.length) {
                        if (children[index] == item) break;
                        ++index;
                    }
                    if (index > 0) {
                        item = children[index - 1];
                        while (true) {
                            this.createChildren((Widget)item);
                            n = item.getItemCount();
                            if (n <= 0) break;
                            if (expand) {
                                item.setExpanded(true);
                            }
                            item = item.getItems()[n - 1];
                        }
                        return item;
                    }
                }
                item = parent;
                break block12;
            }
            if (expand) {
                item.setExpanded(true);
            }
            this.createChildren((Widget)item);
            if (item.getItemCount() <= 0) ** GOTO lbl45
            children = item.getItems();
            return children[0];
lbl-1000:
            // 1 sources

            {
                children = null;
                parent = item.getParentItem();
                children = parent != null ? parent.getItems() : item.getParent().getItems();
                if (children != null && children.length > 0) {
                    index = 0;
                    while (index < children.length) {
                        if (children[index] == item) break;
                        ++index;
                    }
                    if (index < children.length - 1) {
                        return children[index + 1];
                    }
                }
                item = parent;
lbl45:
                // 2 sources

                ** while (item != null)
            }
        }
        return item;
    }

    private void internalSetSelection(TreeItem ti, boolean fireOpen) {
        Object data;
        if (ti != null && (data = ti.getData()) != null) {
            StructuredSelection selection = new StructuredSelection(data);
            this.setSelection((ISelection)selection, true);
            ISelection currentSelection = this.getSelection();
            if (fireOpen && currentSelection != null && selection.equals(currentSelection)) {
                this.fireOpen(new OpenEvent((Viewer)this, (ISelection)selection));
            }
        }
    }

    private void updateActions() {
        if (this.fExpandAllAction != null) {
            this.fExpandAllAction.setEnabled(this.getSelection().isEmpty());
        }
    }

    private boolean internalOpen() {
        ISelection selection = this.getSelection();
        if (selection != null && !selection.isEmpty()) {
            this.fireOpen(new OpenEvent((Viewer)this, selection));
            return true;
        }
        return false;
    }

    class DiffViewerContentProvider
    implements ITreeContentProvider {
        DiffViewerContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public void dispose() {
            this.inputChanged((Viewer)DiffTreeViewer.this, DiffTreeViewer.this.getInput(), null);
        }

        public Object getParent(Object element) {
            if (element instanceof IDiffElement) {
                return ((IDiffElement)element).getParent();
            }
            return null;
        }

        public final boolean hasChildren(Object element) {
            if (element instanceof IDiffContainer) {
                return ((IDiffContainer)element).hasChildren();
            }
            return false;
        }

        public final Object[] getChildren(Object element) {
            if (element instanceof IDiffContainer) {
                return ((IDiffContainer)element).getChildren();
            }
            return new Object[0];
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }
    }

    class DiffViewerLabelProvider
    extends LabelProvider {
        DiffViewerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IDiffElement) {
                return ((IDiffElement)element).getName();
            }
            return Utilities.getString(DiffTreeViewer.this.fBundle, "defaultLabel");
        }

        public Image getImage(Object element) {
            if (element instanceof IDiffElement) {
                IDiffElement input = (IDiffElement)element;
                int kind = input.getKind();
                block0 : switch (kind & 0xC) {
                    case 4: {
                        kind = kind & 0xFFFFFFFB | 8;
                        break;
                    }
                    case 8: {
                        kind = kind & 0xFFFFFFF7 | 4;
                        break;
                    }
                    case 0: {
                        switch (kind & 3) {
                            case 1: {
                                kind = kind & 0xFFFFFFFE | 2;
                                break block0;
                            }
                            case 2: {
                                kind = kind & 0xFFFFFFFD | 1;
                            }
                        }
                    }
                }
                return DiffTreeViewer.this.fCompareConfiguration.getImage(input.getImage(), kind);
            }
            return null;
        }

        public void fireLabelProviderChanged() {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    static class FilterSame
    extends ViewerFilter {
        FilterSame() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IDiffElement) {
                return (((IDiffElement)element).getKind() & 0x10) == 0;
            }
            return true;
        }

        public boolean isFilterProperty(Object element, Object property) {
            return false;
        }
    }
}

