/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.format;

import com.google.common.annotations.VisibleForTesting;
import java.text.FieldPosition;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.ChartRangeMap;

public class ChartDecimalUnitFormat
extends DecimalUnitFormat {
    private static final long serialVersionUID = -4288059349658845257L;
    private final @Nullable ChartRangeMap fRangeMap;

    public ChartDecimalUnitFormat(@Nullable ChartRangeMap map) {
        this.fRangeMap = map;
    }

    public ChartDecimalUnitFormat(double factor, @Nullable ChartRangeMap map) {
        super(factor);
        this.fRangeMap = map;
    }

    @VisibleForTesting
    public @Nullable ChartRangeMap getRangeMap() {
        return this.fRangeMap;
    }

    public StringBuffer format(@Nullable Object obj, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
        if (!(obj instanceof Number) || toAppendTo == null) {
            throw new IllegalArgumentException("Cannot format given Object as a Number: " + obj);
        }
        Number number = (Number)obj;
        ChartRangeMap rangeMap = this.fRangeMap;
        if (rangeMap == null) {
            StringBuffer buffer = super.format((Object)number, toAppendTo, pos);
            return buffer == null ? new StringBuffer() : buffer;
        }
        Double externalValue = ((ChartRangeMap)NonNullUtils.checkNotNull((Object)this.fRangeMap)).getExternalValue(number).doubleValue();
        StringBuffer buffer = super.format((Object)externalValue, toAppendTo, pos);
        return buffer == null ? new StringBuffer() : buffer;
    }
}

