/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.internal.statesystem.core.StateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class StateSystemTest {
    @Rule
    public TestRule globalTimeout = new Timeout(1L, TimeUnit.MINUTES);
    private ITmfStateSystemBuilder fSs;

    @Before
    public void setup() {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createNullBackend((String)"Test");
        this.fSs = new StateSystem(backend);
    }

    @Test
    public void testWaitUntilBuilt() {
        ITmfStateSystemBuilder ss = this.fSs;
        Assert.assertNotNull((Object)ss);
        long timeout = 500L;
        long begin = System.currentTimeMillis();
        Assert.assertFalse((boolean)ss.waitUntilBuilt(timeout));
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - begin >= timeout ? 1 : 0) != 0);
        Assert.assertFalse((boolean)ss.waitUntilBuilt(0L));
        ss.closeHistory(timeout);
        Assert.assertTrue((boolean)ss.waitUntilBuilt(timeout));
        Assert.assertTrue((boolean)ss.waitUntilBuilt(0L));
    }

    @Test
    public void testSetAndQueryOngoing() {
        ITmfStateSystemBuilder ss = this.fSs;
        Assert.assertNotNull((Object)ss);
        long time = 10L;
        int quark = ss.getQuarkAbsoluteAndAdd(new String[]{"Test"});
        long val = 10L;
        ss.modifyAttribute(time, (Object)val, quark);
        ITmfStateValue ongoingState = ss.queryOngoingState(quark);
        Assert.assertTrue((ongoingState.getType() == ITmfStateValue.Type.LONG ? 1 : 0) != 0);
        Assert.assertEquals((long)val, (long)ongoingState.unboxLong());
        Object ongoing = ss.queryOngoing(quark);
        Assert.assertTrue((boolean)(ongoing instanceof Long));
        Assert.assertEquals((Object)val, (Object)ongoing);
        val = 12L;
        ss.modifyAttribute(time + 1L, (Object)val, quark);
        ongoingState = ss.queryOngoingState(quark);
        Assert.assertTrue((ongoingState.getType() == ITmfStateValue.Type.LONG ? 1 : 0) != 0);
        Assert.assertEquals((long)val, (long)ongoingState.unboxLong());
        ongoing = ss.queryOngoing(quark);
        Assert.assertTrue((boolean)(ongoing instanceof Long));
        Assert.assertEquals((Object)val, (Object)ongoing);
        val = 14L;
        ss.updateOngoingState(TmfStateValue.newValue((Object)val), quark);
        ongoingState = ss.queryOngoingState(quark);
        Assert.assertTrue((ongoingState.getType() == ITmfStateValue.Type.LONG ? 1 : 0) != 0);
        Assert.assertEquals((long)val, (long)ongoingState.unboxLong());
        ongoing = ss.queryOngoing(quark);
        Assert.assertTrue((boolean)(ongoing instanceof Long));
        Assert.assertEquals((Object)val, (Object)ongoing);
        val = 16L;
        ss.updateOngoingState((Object)val, quark);
        ongoingState = ss.queryOngoingState(quark);
        Assert.assertTrue((ongoingState.getType() == ITmfStateValue.Type.LONG ? 1 : 0) != 0);
        Assert.assertEquals((long)val, (long)ongoingState.unboxLong());
        ongoing = ss.queryOngoing(quark);
        Assert.assertTrue((boolean)(ongoing instanceof Long));
        Assert.assertEquals((Object)val, (Object)ongoing);
    }

    @Test
    public void testAttributes() {
        String searchPattern = "abc";
        String attribute1 = "Test";
        String attribute2 = attribute1 + searchPattern;
        String attribute3 = attribute1 + "\n" + searchPattern;
        String search = "(.*)" + searchPattern + "(.*)";
        ITmfStateSystemBuilder ss = this.fSs;
        Assert.assertNotNull((Object)ss);
        int quark1 = ss.getQuarkAbsoluteAndAdd(new String[]{attribute1});
        int quark2 = ss.getQuarkAbsoluteAndAdd(new String[]{attribute2});
        int quark3 = ss.getQuarkAbsoluteAndAdd(new String[]{attribute3});
        int quark11 = ss.getQuarkRelativeAndAdd(quark1, new String[]{attribute1});
        int quark12 = ss.getQuarkRelativeAndAdd(quark1, new String[]{attribute2});
        int quark132 = ss.getQuarkRelativeAndAdd(quark1, new String[]{attribute3, attribute2});
        int quark13 = ss.getQuarkRelativeAndAdd(quark1, new String[]{attribute3});
        List subAttributes = ss.getSubAttributes(-1, false);
        List<Integer> expected = Arrays.asList(quark1, quark2, quark3);
        StateSystemTest.assertArrayContent(expected, subAttributes);
        subAttributes = ss.getSubAttributes(-1, true);
        expected = Arrays.asList(quark1, quark11, quark12, quark13, quark132, quark2, quark3);
        StateSystemTest.assertArrayContent(expected, subAttributes);
        subAttributes = ss.getSubAttributes(-1, false, attribute1);
        expected = Arrays.asList(quark1);
        StateSystemTest.assertArrayContent(expected, subAttributes);
        subAttributes = ss.getSubAttributes(-1, true, attribute1);
        expected = Arrays.asList(quark1, quark11);
        StateSystemTest.assertArrayContent(expected, subAttributes);
        subAttributes = ss.getSubAttributes(-1, false, search);
        expected = Arrays.asList(quark2, quark3);
        StateSystemTest.assertArrayContent(expected, subAttributes);
        subAttributes = ss.getSubAttributes(-1, true, search);
        expected = Arrays.asList(quark2, quark3, quark12, quark13, quark132);
        StateSystemTest.assertArrayContent(expected, subAttributes);
        subAttributes = ss.getSubAttributes(quark1, false);
        expected = Arrays.asList(quark11, quark12, quark13);
        StateSystemTest.assertArrayContent(expected, subAttributes);
        subAttributes = ss.getSubAttributes(quark1, false, search);
        expected = Arrays.asList(quark12, quark13);
        StateSystemTest.assertArrayContent(expected, subAttributes);
        Assert.assertEquals((Object)attribute1, (Object)ss.getAttributeName(quark1));
        Assert.assertEquals((Object)attribute2, (Object)ss.getAttributeName(quark2));
        Assert.assertEquals((Object)attribute3, (Object)ss.getAttributeName(quark3));
    }

    private static void assertArrayContent(List<Integer> expected, List<Integer> actual) {
        ArrayList<Integer> list = new ArrayList<Integer>(actual);
        for (Integer expectedInt : expected) {
            Assert.assertTrue((String)("Missing value " + String.valueOf(expectedInt)), (boolean)list.contains(expectedInt));
            list.remove(expectedInt);
        }
        Assert.assertEquals((long)expected.size(), (long)actual.size());
    }
}

