/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stubs.ExternalAnalysisModuleStub;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XmlSchemaParserTest {
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace4.xml";
    private static final @NonNull String MY_MODULE = "extended.my";
    private static final @NonNull String ABC_MODULE = "extended.abc";

    private static void emptyXmlFolder() {
        File fFolder = XmlUtils.getXmlFilesPath().toFile();
        if (!fFolder.isDirectory() || !fFolder.exists()) {
            return;
        }
        File[] fileArray = fFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File xmlFile = fileArray[n2];
            xmlFile.delete();
            ++n2;
        }
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    @Before
    public void setUp() {
        XmlSchemaParserTest.emptyXmlFolder();
    }

    @After
    public void cleanUp() {
        XmlSchemaParserTest.emptyXmlFolder();
    }

    @Test
    public void testGettingSchemaParser() {
        Collection parsers = XmlUtils.getExtraSchemaParsers();
        Assert.assertTrue((!parsers.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testPopulateExtendedModules() {
        XmlAnalysisModuleSource source = new XmlAnalysisModuleSource();
        Iterable modules = source.getAnalysisModules();
        Assert.assertNull((String)"Module not present", (Object)XmlSchemaParserTest.findModule(modules, MY_MODULE));
        File testXmlFile = TmfXmlTestFiles.VALID_FILE_EXTENDED.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        XmlUtils.addXmlFile((File)testXmlFile);
        XmlAnalysisModuleSource.notifyModuleChange();
        modules = source.getAnalysisModules();
        Assert.assertTrue((String)"Modules available from source", (boolean)modules.iterator().hasNext());
        Assert.assertNotNull((String)"'My' module present", (Object)XmlSchemaParserTest.findModule(modules, MY_MODULE));
        Assert.assertNotNull((String)"'abc' module present", (Object)XmlSchemaParserTest.findModule(modules, ABC_MODULE));
    }

    private static @Nullable IAnalysisModuleHelper findModule(Iterable<IAnalysisModuleHelper> modules, String moduleName) {
        return (IAnalysisModuleHelper)Iterables.tryFind(modules, helper -> moduleName.equals(helper.getId())).orNull();
    }

    @Test
    public void testExtendedModuleCreated() throws TmfAnalysisException {
        XmlAnalysisModuleSource source = new XmlAnalysisModuleSource();
        File testXmlFile = TmfXmlTestFiles.VALID_FILE_EXTENDED.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        XmlUtils.addXmlFile((File)testXmlFile);
        XmlAnalysisModuleSource.notifyModuleChange();
        Iterable modules = source.getAnalysisModules();
        ITmfTrace trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
        try {
            IAnalysisModuleHelper helper = XmlSchemaParserTest.findModule(modules, MY_MODULE);
            Assert.assertNotNull((Object)helper);
            IAnalysisModule newModule = helper.newModule(trace);
            try {
                Assert.assertTrue((String)"Extended module class", (boolean)(newModule instanceof ExternalAnalysisModuleStub));
                Assert.assertEquals((String)"Extended module ID", (Object)MY_MODULE, (Object)newModule.getId());
            }
            finally {
                if (newModule != null) {
                    newModule.dispose();
                }
            }
            helper = XmlSchemaParserTest.findModule(modules, ABC_MODULE);
            Assert.assertNotNull((Object)helper);
            newModule = helper.newModule(trace);
            try {
                Assert.assertTrue((String)"Extended module class", (boolean)(newModule instanceof ExternalAnalysisModuleStub));
                Assert.assertEquals((String)"Extended module ID", (Object)ABC_MODULE, (Object)newModule.getId());
            }
            finally {
                if (newModule != null) {
                    newModule.dispose();
                }
            }
        }
        finally {
            trace.dispose();
        }
    }
}

