/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.internal.intro.universal.BaseData;
import org.eclipse.ui.internal.intro.universal.ExtensionData;
import org.eclipse.ui.internal.intro.universal.SeparatorData;

public class ExtensionDataTransfer
extends ByteArrayTransfer {
    private static final String MYTYPENAME = "ExtensionData";
    private static final int MYTYPEID = ExtensionDataTransfer.registerType((String)"ExtensionData");
    private static ExtensionDataTransfer _instance = new ExtensionDataTransfer();

    public static ExtensionDataTransfer getInstance() {
        return _instance;
    }

    protected String[] getTypeNames() {
        return new String[]{MYTYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{MYTYPEID};
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkMyType(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        BaseData[] myTypes = (BaseData[])object;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (DataOutputStream writeOut = new DataOutputStream(out);){
                BaseData[] baseDataArray = myTypes;
                int n = myTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    BaseData bd = baseDataArray[n2];
                    boolean separator = bd instanceof SeparatorData;
                    writeOut.writeBoolean(separator);
                    byte[] buffer = bd.getId().getBytes();
                    writeOut.writeInt(bd.getId().length());
                    writeOut.write(buffer);
                    if (bd instanceof ExtensionData) {
                        ExtensionData ed = (ExtensionData)bd;
                        writeOut.writeInt(ed.getName().length());
                        buffer = ed.getName().getBytes();
                        writeOut.write(buffer);
                        writeOut.writeInt(ed.getImportance());
                    }
                    ++n2;
                }
                byte[] buffer = out.toByteArray();
                super.javaToNative((Object)buffer, transferData);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            BaseData[] myData = new BaseData[]{};
            ByteArrayInputStream in = new ByteArrayInputStream(buffer);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (DataInputStream readIn = new DataInputStream(in);){
                    while (readIn.available() > 4) {
                        int importance = 0;
                        String name = null;
                        boolean separator = readIn.readBoolean();
                        int size = readIn.readInt();
                        byte[] buff = new byte[size];
                        readIn.read(buff);
                        String id = new String(buff);
                        if (!separator) {
                            size = readIn.readInt();
                            buff = new byte[size];
                            readIn.read(buff);
                            name = new String(buff);
                            importance = readIn.readInt();
                        }
                        BaseData[] newMyData = new BaseData[myData.length + 1];
                        System.arraycopy(myData, 0, newMyData, 0, myData.length);
                        newMyData[myData.length] = separator ? new SeparatorData(id) : new ExtensionData(id, name, importance);
                        myData = newMyData;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                return null;
            }
            return myData;
        }
        return null;
    }

    boolean checkMyType(Object object) {
        BaseData[] myTypes;
        if (object == null || !(object instanceof BaseData[]) || (myTypes = (BaseData[])object).length == 0) {
            return false;
        }
        BaseData[] baseDataArray = myTypes;
        int n = myTypes.length;
        int n2 = 0;
        while (n2 < n) {
            BaseData myType = baseDataArray[n2];
            if (myType == null || myType.getId() == null || myType instanceof ExtensionData && ((ExtensionData)myType).getName() == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkMyType(object);
    }
}

