/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.validation.internal.ReferencialFileValidatorExtension;
import org.eclipse.wst.validation.internal.operations.ReferencialFileValidator;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ReferencialFileValidatorRegistryReader {
    static ReferencialFileValidatorRegistryReader instance;
    private static final String Id = "id";
    private static final String ExtensionPoint = "referencialFileValidator";
    protected List<ReferencialFileValidatorExtension> referencialFileValidationExtensions;

    public void readRegistry() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(Id, ExtensionPoint);
        if (point == null) {
            return;
        }
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            this.internalReadElement(elements[i]);
            ++i;
        }
    }

    private void internalReadElement(IConfigurationElement element) {
        boolean recognized = this.readElement(element);
        if (!recognized) {
            this.logError(element, "Error processing extension: " + String.valueOf(element));
        }
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getContributor().getName() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        ValidationPlugin.getPlugin().logMessage(4, buf.toString());
    }

    public boolean readElement(IConfigurationElement element) {
        if (ExtensionPoint.equals(element.getName())) {
            this.addExtension(element);
            return true;
        }
        return false;
    }

    protected void addExtension(IConfigurationElement newExtension) {
        boolean containsExt = true;
        for (ReferencialFileValidatorExtension ext : this.getReferencialFileValidationExtensions()) {
            if (ext.getElement().getAttribute(Id).equals(newExtension.getAttribute(Id))) continue;
            containsExt = false;
        }
        if (!containsExt || this.getReferencialFileValidationExtensions().isEmpty()) {
            this.getReferencialFileValidationExtensions().add(new ReferencialFileValidatorExtension(newExtension));
        }
        this.getReferencialFileValidationExtensions().add(new ReferencialFileValidatorExtension(newExtension));
    }

    protected void addExtensionPoint(ReferencialFileValidatorExtension newExtension) {
        if (this.referencialFileValidationExtensions == null) {
            this.referencialFileValidationExtensions = new ArrayList<ReferencialFileValidatorExtension>();
        }
        this.referencialFileValidationExtensions.add(newExtension);
    }

    public ReferencialFileValidator getReferencialFileValidator() {
        Iterator<ReferencialFileValidatorExtension> iterator = this.getReferencialFileValidationExtensions().iterator();
        if (iterator.hasNext()) {
            ReferencialFileValidatorExtension refFileValExt = iterator.next();
            return refFileValExt.getInstance();
        }
        return null;
    }

    public static ReferencialFileValidatorRegistryReader getInstance() {
        if (instance == null) {
            instance = new ReferencialFileValidatorRegistryReader();
            instance.readRegistry();
        }
        return instance;
    }

    protected List<ReferencialFileValidatorExtension> getReferencialFileValidationExtensions() {
        if (this.referencialFileValidationExtensions == null) {
            this.referencialFileValidationExtensions = new ArrayList<ReferencialFileValidatorExtension>();
        }
        return this.referencialFileValidationExtensions;
    }
}

