/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.progress.UIJob;
import org.eclipse.e4.ui.progress.internal.ContentProviderFactory;
import org.eclipse.e4.ui.progress.internal.FinishedJobs;
import org.eclipse.e4.ui.progress.internal.Preferences;
import org.eclipse.e4.ui.progress.internal.ProgressManager;
import org.eclipse.e4.ui.progress.internal.ProgressManagerUtil;
import org.eclipse.e4.ui.progress.internal.ProgressMessages;
import org.eclipse.e4.ui.progress.internal.ProgressMonitorFocusJobDialog;
import org.eclipse.e4.ui.progress.internal.ProgressMonitorJobsDialog;
import org.eclipse.e4.ui.progress.internal.Services;
import org.eclipse.e4.ui.progress.internal.legacy.EventLoopProgressMonitor;
import org.eclipse.e4.ui.progress.internal.legacy.PlatformUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ProgressServiceImpl
implements IProgressService {
    private static final String IMAGE_KEY = "org.eclipse.ui.progress.images";
    private Hashtable<Object, String> imageKeyTable = new Hashtable();
    @Inject
    @Optional
    ProgressManager progressManager;
    @Inject
    FinishedJobs finishedJobs;
    @Inject
    @Optional
    ContentProviderFactory contentProviderFactory;
    @Inject
    @Optional
    UISynchronize uiSynchronize;

    @Override
    public int getLongOperationTime() {
        return 800;
    }

    @Override
    public void registerIconForFamily(ImageDescriptor icon, Object family) {
        String key = IMAGE_KEY + this.imageKeyTable.size();
        this.imageKeyTable.put(family, key);
        ImageRegistry registry = JFaceResources.getImageRegistry();
        if (registry.getDescriptor(key) == null) {
            registry.put(key, icon);
        }
    }

    @Override
    public void runInUI(IRunnableContext context, IRunnableWithProgress runnable, ISchedulingRule rule) throws InvocationTargetException, InterruptedException {
        RunnableWithStatus runnableWithStatus = new RunnableWithStatus(context, runnable, rule);
        this.uiSynchronize.syncExec(() -> BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)runnableWithStatus));
        IStatus status = runnableWithStatus.getStatus();
        if (!status.isOK()) {
            Throwable exception = status.getException();
            if (exception instanceof InvocationTargetException) {
                throw (InvocationTargetException)exception;
            }
            if (exception instanceof InterruptedException) {
                throw (InterruptedException)exception;
            }
            throw new InterruptedException(exception.getMessage());
        }
    }

    @Override
    public Image getIconFor(Job job) {
        Enumeration<Object> families = this.imageKeyTable.keys();
        while (families.hasMoreElements()) {
            Object next = families.nextElement();
            if (!job.belongsTo(next)) continue;
            return JFaceResources.getImageRegistry().get(this.imageKeyTable.get(next));
        }
        return null;
    }

    @Override
    public void busyCursorWhile(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        ProgressMonitorJobsDialog dialog = new ProgressMonitorJobsDialog(ProgressManagerUtil.getDefaultParent(), this, this.progressManager, this.contentProviderFactory, this.finishedJobs);
        dialog.setOpenOnRun(false);
        InvocationTargetException[] invokes = new InvocationTargetException[1];
        InterruptedException[] interrupt = new InterruptedException[1];
        Runnable dialogWaitRunnable = () -> {
            try {
                try {
                    dialog.setOpenOnRun(false);
                    this.setUserInterfaceActive(false);
                    dialog.run(true, true, runnable);
                }
                catch (InvocationTargetException e1) {
                    invocationTargetExceptionArray[0] = e1;
                    this.setUserInterfaceActive(true);
                }
                catch (InterruptedException e2) {
                    interruptedExceptionArray[0] = e2;
                    this.setUserInterfaceActive(true);
                }
            }
            finally {
                this.setUserInterfaceActive(true);
            }
        };
        this.busyCursorWhile(dialogWaitRunnable, dialog);
        if (invokes[0] != null) {
            throw invokes[0];
        }
        if (interrupt[0] != null) {
            throw interrupt[0];
        }
    }

    @Override
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (!fork || !cancelable) {
            ProgressMonitorJobsDialog dialog = new ProgressMonitorJobsDialog(null, this, this.progressManager, this.contentProviderFactory, this.finishedJobs);
            dialog.run(fork, cancelable, runnable);
            return;
        }
        this.busyCursorWhile(runnable);
    }

    @Override
    public void showInDialog(Shell shell, Job job) {
        if (this.shouldRunInBackground()) {
            return;
        }
        ProgressMonitorFocusJobDialog dialog = new ProgressMonitorFocusJobDialog(shell, this, this.progressManager, this.contentProviderFactory, this.finishedJobs);
        dialog.show(job, shell);
    }

    protected boolean shouldRunInBackground() {
        return Preferences.getBoolean("RUN_IN_BACKGROUND");
    }

    private void busyCursorWhile(Runnable dialogWaitRunnable, ProgressMonitorJobsDialog dialog) {
        this.scheduleProgressMonitorJob(dialog);
        Display display = this.getDisplay();
        if (display == null) {
            return;
        }
        BusyIndicator.showWhile((Display)display, (Runnable)dialogWaitRunnable);
    }

    private void scheduleProgressMonitorJob(ProgressMonitorJobsDialog dialog) {
        UIJob updateJob = UIJob.create(ProgressMessages.ProgressManager_openJobName, monitor -> {
            this.setUserInterfaceActive(true);
            if (ProgressManagerUtil.safeToOpen(dialog, null)) {
                dialog.open();
            }
        });
        updateJob.setSystem(true);
        updateJob.schedule(this.getLongOperationTime());
    }

    private void setUserInterfaceActive(boolean active) {
        Shell[] shells = this.getDisplay().getShells();
        if (active) {
            Shell[] shellArray = shells;
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                if (!shell.isDisposed()) {
                    shell.setEnabled(active);
                }
                ++n2;
            }
        } else {
            int i = shells.length - 1;
            while (i >= 0) {
                if (!shells[i].isDisposed()) {
                    shells[i].setEnabled(active);
                }
                --i;
            }
        }
    }

    protected Display getDisplay() {
        return Services.getInstance().getDisplay();
    }

    private static class RunnableWithStatus
    implements Runnable {
        IStatus status = Status.OK_STATUS;
        private final IRunnableContext context;
        private final IRunnableWithProgress runnable;
        private final ISchedulingRule rule;

        public RunnableWithStatus(IRunnableContext context, IRunnableWithProgress runnable, ISchedulingRule rule) {
            this.context = context;
            this.runnable = runnable;
            this.rule = rule;
        }

        @Override
        public void run() {
            IJobManager manager = Job.getJobManager();
            try {
                try {
                    manager.beginRule(this.rule, this.getEventLoopMonitor());
                    this.context.run(false, false, this.runnable);
                }
                catch (InterruptedException | InvocationTargetException | OperationCanceledException e) {
                    this.status = new Status(4, "org.eclipse.e4.ui.progress", e.getMessage(), e);
                    manager.endRule(this.rule);
                }
            }
            finally {
                manager.endRule(this.rule);
            }
        }

        private IProgressMonitor getEventLoopMonitor() {
            if (PlatformUI.isWorkbenchStarting()) {
                return new NullProgressMonitor();
            }
            return new EventLoopProgressMonitor((IProgressMonitor)new NullProgressMonitor()){

                @Override
                public void setBlocked(IStatus reason) {
                    Dialog.getBlockedHandler().showBlocked(ProgressManagerUtil.getDefaultParent(), (IProgressMonitor)this, reason, this.getTaskName());
                }
            };
        }

        public IStatus getStatus() {
            return this.status;
        }
    }
}

