/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace;

import org.eclipse.ui.internal.findandreplace.FindReplaceMessages;
import org.eclipse.ui.internal.findandreplace.status.FindAllStatus;
import org.eclipse.ui.internal.findandreplace.status.FindStatus;
import org.eclipse.ui.internal.findandreplace.status.IFindReplaceStatus;
import org.eclipse.ui.internal.findandreplace.status.IFindReplaceStatusVisitor;
import org.eclipse.ui.internal.findandreplace.status.InvalidRegExStatus;
import org.eclipse.ui.internal.findandreplace.status.NoStatus;
import org.eclipse.ui.internal.findandreplace.status.ReplaceAllStatus;
import org.eclipse.ui.internal.texteditor.NLSUtility;

public class FindReplaceLogicMessageGenerator
implements IFindReplaceStatusVisitor<String> {
    @Override
    public String visit(IFindReplaceStatus status) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String visit(ReplaceAllStatus status) {
        int replaceCount = status.getReplaceCount();
        if (replaceCount == 1) {
            return FindReplaceMessages.FindReplace_Status_replacement_label;
        }
        return NLSUtility.format(FindReplaceMessages.FindReplace_Status_replacements_label, replaceCount);
    }

    @Override
    public String visit(FindStatus status) {
        FindStatus.StatusCode messageCode = status.getMessageCode();
        return switch (messageCode) {
            case FindStatus.StatusCode.NO_MATCH -> FindReplaceMessages.FindReplace_Status_noMatch_label;
            case FindStatus.StatusCode.WRAPPED -> FindReplaceMessages.FindReplace_Status_wrapped_label;
            case FindStatus.StatusCode.READONLY -> FindReplaceMessages.FindReplaceDialog_read_only;
            default -> "";
        };
    }

    @Override
    public String visit(InvalidRegExStatus status) {
        return status.getMessage();
    }

    @Override
    public String visit(FindAllStatus status) {
        int selectCount = status.getSelectCount();
        if (selectCount == 1) {
            return FindReplaceMessages.FindReplace_Status_selection_label;
        }
        return NLSUtility.format(FindReplaceMessages.FindReplace_Status_selections_label, selectCount);
    }

    @Override
    public String visit(NoStatus status) {
        return "";
    }
}

