/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application.addons;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.URIHelper;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.event.Event;

public class ModelCleanupAddon {
    private static final int BUNDLECLASS_SCHEMA_LENGTH = 14;
    private static final String COMPATIBILITY_EDITOR_URI = "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor";
    private static final String COMPATIBILITY_VIEW_URI = "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView";
    @Inject
    @Optional
    private MApplication application;
    @Inject
    @Optional
    private EModelService modelService;
    @Inject
    @Optional
    private Logger logger;
    private BundleContext bundleContext;

    @Inject
    @Optional
    public void applicationStartUp(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event, MApplication app, UISynchronize uiSync) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        this.bundleContext = bundle.getBundleContext();
        this.cleanUnavailablePartDescriptors(app, uiSync);
        this.cleanUnavailableHandlers(app, uiSync);
        this.cleanHiddenCompatibilityEditors();
    }

    private void cleanUnavailablePartDescriptors(MApplication app, UISynchronize uiSync) {
        ArrayList descriptors = new ArrayList(app.getDescriptors());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        CompletableFuture.supplyAsync(() -> this.getObsoletePartDescriptors(descriptors), executor).thenAccept(d -> uiSync.asyncExec(() -> this.iteratorRemove(app.getDescriptors(), (List<?>)d)));
    }

    private void cleanUnavailableHandlers(MApplication app, UISynchronize uiSync) {
        ArrayList handlers = new ArrayList(app.getHandlers());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        CompletableFuture.supplyAsync(() -> this.getObsoleteHandlers(handlers), executor).thenAccept(d -> uiSync.asyncExec(() -> this.iteratorRemove(app.getHandlers(), (List<?>)d)));
    }

    private List<MPartDescriptor> getObsoletePartDescriptors(List<MPartDescriptor> partDescriptors) {
        Iterator<MPartDescriptor> iterator = partDescriptors.iterator();
        while (iterator.hasNext()) {
            MPartDescriptor appElement = iterator.next();
            boolean validAppElement = this.isValidPartDescriptor(appElement);
            if (validAppElement) {
                iterator.remove();
                continue;
            }
            this.logMissingClassWarning((MApplicationElement)appElement);
        }
        return partDescriptors;
    }

    private List<MHandler> getObsoleteHandlers(List<MHandler> handlers) {
        Iterator<MHandler> iterator = handlers.iterator();
        while (iterator.hasNext()) {
            MHandler appElement = iterator.next();
            boolean validAppElement = this.isValidHandler(appElement);
            if (validAppElement) {
                iterator.remove();
                continue;
            }
            this.logMissingClassWarning((MApplicationElement)appElement);
        }
        return handlers;
    }

    private void iteratorRemove(List<?> list, List<?> elementsToBeRemoved) {
        if (elementsToBeRemoved.isEmpty()) {
            return;
        }
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!elementsToBeRemoved.contains(object)) continue;
            iterator.remove();
        }
    }

    private void logMissingClassWarning(MApplicationElement appElement) {
        StringBuilder sb = new StringBuilder();
        sb.append("Removing ");
        sb.append(appElement.getClass().getSimpleName());
        sb.append(" with the \"");
        sb.append(appElement.getElementId());
        sb.append("\" id");
        if (appElement instanceof MUILabel) {
            sb.append(" and the \"");
            sb.append(((MUILabel)appElement).getLocalizedLabel());
            sb.append("\" label");
        }
        sb.append(".");
        sb.append("It points to the non available \"");
        sb.append(this.getContributionUri(appElement));
        sb.append("\" class. Bundle might have been uninstalled");
        this.logger.warn(sb.toString());
    }

    private String getContributionUri(MApplicationElement appElement) {
        if (appElement instanceof MPartDescriptor) {
            return ((MPartDescriptor)appElement).getContributionURI();
        }
        if (appElement instanceof MAddon) {
            return ((MAddon)appElement).getContributionURI();
        }
        if (appElement instanceof MHandler) {
            return ((MHandler)appElement).getContributionURI();
        }
        return null;
    }

    private void cleanHiddenCompatibilityEditors() {
        List compatEditors = this.modelService.findElements((MUIElement)this.application, "org.eclipse.e4.ui.compatibility.editor", MPart.class);
        for (MPart editor : compatEditors) {
            if (editor.isToBeRendered()) continue;
            editor.getParent().getChildren().remove(editor);
        }
    }

    private boolean isValidPartDescriptor(MPartDescriptor partDescriptor) {
        String contributionURI = partDescriptor.getContributionURI();
        if (!URIHelper.isBundleClassUri((String)contributionURI)) {
            return false;
        }
        String originalCompatibilityViewClass = (String)partDescriptor.getPersistedState().get("originalCompatibilityViewClass");
        if (COMPATIBILITY_VIEW_URI.equals(contributionURI) && originalCompatibilityViewClass != null) {
            String originalCompatibilityViewBundle = (String)partDescriptor.getPersistedState().get("originalCompatibilityViewBundle");
            return this.checkPartDescriptorByBundleSymbolicNameAndClass(this.bundleContext, originalCompatibilityViewBundle, originalCompatibilityViewClass);
        }
        if (!COMPATIBILITY_EDITOR_URI.equals(contributionURI)) {
            String[] bundleClass = contributionURI.substring(14).split("/");
            String bundleSymbolicName = bundleClass[0];
            String className = bundleClass[1];
            return this.checkPartDescriptorByBundleSymbolicNameAndClass(this.bundleContext, bundleSymbolicName, className);
        }
        return true;
    }

    private boolean isValidHandler(MHandler handler) {
        String contributionURI = handler.getContributionURI();
        if (!URIHelper.isBundleClassUri((String)contributionURI)) {
            return false;
        }
        String[] bundleClass = contributionURI.substring(14).split("/");
        String bundleSymbolicName = bundleClass[0];
        String className = bundleClass[1];
        return this.checkPartDescriptorByBundleSymbolicNameAndClass(this.bundleContext, bundleSymbolicName, className);
    }

    private boolean checkPartDescriptorByBundleSymbolicNameAndClass(BundleContext bundleContext, String bundleSymbolicName, String className) {
        Collection<BundleWiring> wirings = this.findWirings(bundleSymbolicName, bundleContext);
        return this.isPartDescriptorClassAvailable(wirings, className);
    }

    private boolean isPartDescriptorClassAvailable(Collection<BundleWiring> wirings, String className) {
        Object classResourceName;
        Object classPackageName;
        if (wirings.isEmpty()) {
            return false;
        }
        int indexLastDot = className.lastIndexOf(46);
        if (indexLastDot < 0) {
            classPackageName = "/";
            classResourceName = className;
        } else {
            classPackageName = "/" + className.substring(0, indexLastDot).replace('.', '/');
            classResourceName = className.substring(indexLastDot + 1) + ".class";
        }
        for (BundleWiring bundleWiring : wirings) {
            if (this.checkClassResource((String)classPackageName, (String)classResourceName, bundleWiring)) continue;
            return false;
        }
        return true;
    }

    private Collection<BundleWiring> findWirings(final String bundleSymbolicName, BundleContext bundleContext) {
        Requirement req = new Requirement(){

            public Resource getResource() {
                return null;
            }

            public String getNamespace() {
                return "osgi.identity";
            }

            public Map<String, String> getDirectives() {
                return Collections.singletonMap("filter", "(osgi.identity=" + bundleSymbolicName + ")");
            }

            public Map<String, Object> getAttributes() {
                return Collections.emptyMap();
            }
        };
        Collection identities = ((FrameworkWiring)bundleContext.getBundle("System Bundle").adapt(FrameworkWiring.class)).findProviders(req);
        ArrayList<BundleWiring> result = new ArrayList<BundleWiring>(1);
        for (BundleCapability identity : identities) {
            BundleRevision revision = identity.getRevision();
            BundleWiring wiring = revision.getWiring();
            if (wiring == null) continue;
            if ((revision.getTypes() & 1) != 0) {
                wiring = ((BundleWire)wiring.getRequiredWires("osgi.wiring.host").get(0)).getProviderWiring();
            }
            result.add(wiring);
        }
        return result;
    }

    private boolean checkClassResource(String classPackageName, String classFileName, BundleWiring wiring) {
        Collection classResourcePaths;
        if (wiring == null) {
            return false;
        }
        if ((wiring.getRevision().getTypes() & 1) != 0) {
            wiring = ((BundleWire)wiring.getRequiredWires("osgi.wiring.host").get(0)).getProviderWiring();
        }
        return (classResourcePaths = wiring.listResources(classPackageName, classFileName, 0)) != null && !classResourcePaths.isEmpty();
    }
}

