/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.OpenPerspectiveAction;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class PerspectiveMenu
extends ContributionItem {
    @Deprecated
    protected static final String SHOW_PERSP_ID = "org.eclipse.ui.perspectives.showPerspective";
    private IPerspectiveRegistry reg;
    private IWorkbenchWindow window;
    private boolean showActive = false;
    private boolean dirty = true;
    private IMenuListener menuListener = manager -> {
        manager.markDirty();
        this.dirty = true;
    };
    private Comparator<IPerspectiveDescriptor> comparator = new Comparator<IPerspectiveDescriptor>(){
        private Collator collator = Collator.getInstance();

        @Override
        public int compare(IPerspectiveDescriptor ob1, IPerspectiveDescriptor ob2) {
            return this.collator.compare(ob1.getLabel(), ob2.getLabel());
        }
    };
    private static final String NO_TARGETS_MSG = WorkbenchMessages.Workbench_showInNoPerspectives;
    private Map<String, IAction> actions = new HashMap<String, IAction>();
    private Action openOtherAction = new Action(WorkbenchMessages.PerspectiveMenu_otherItem){

        public final void runWithEvent(Event event) {
            PerspectiveMenu.this.runOther(new SelectionEvent(event));
        }
    };

    public PerspectiveMenu(IWorkbenchWindow window, String id) {
        super(id);
        this.window = window;
        this.reg = window.getWorkbench().getPerspectiveRegistry();
        this.openOtherAction.setActionDefinitionId(SHOW_PERSP_ID);
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu(manager);
        IContributionItem[] items = manager.getItems();
        if (items.length == 0) {
            MenuItem item = new MenuItem(menu, 0, index++);
            item.setText(NO_TARGETS_MSG);
            item.setEnabled(false);
        } else {
            IContributionItem[] iContributionItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                item.fill(menu, index++);
                ++n2;
            }
        }
        this.dirty = false;
    }

    private final void fillMenu(MenuManager manager) {
        manager.removeAll();
        ArrayList<IPerspectiveDescriptor> persps = this.getPerspectiveItems();
        persps.sort(this.comparator);
        ArrayList<IAction> actions = new ArrayList<IAction>(persps.size());
        for (IPerspectiveDescriptor descriptor : persps) {
            IAction action = this.getAction(descriptor.getId());
            if (action == null || WorkbenchActivityHelper.filterItem(action)) continue;
            actions.add(action);
        }
        for (IAction action : actions) {
            manager.add(action);
        }
        if (PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_OTHER_IN_PERSPECTIVE_MENU")) {
            if (actions.size() > 0) {
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)this.openOtherAction);
        }
    }

    private final IAction getAction(String id) {
        IPerspectiveDescriptor descriptor;
        Object action = this.actions.get(id);
        if (action == null && (descriptor = this.reg.findPerspectiveWithId(id)) != null) {
            action = new OpenPerspectiveAction(this.window, descriptor, this);
            action.setActionDefinitionId(id);
            this.actions.put(id, (IAction)action);
        }
        return action;
    }

    private ArrayList<IPerspectiveDescriptor> getPerspectiveShortcuts() {
        String[] ids;
        ArrayList<IPerspectiveDescriptor> list = new ArrayList<IPerspectiveDescriptor>();
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return list;
        }
        String[] stringArray = ids = page.getPerspectiveShortcuts();
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String perspectiveId = stringArray[n2];
            IPerspectiveDescriptor desc = this.reg.findPerspectiveWithId(perspectiveId);
            if (desc != null && !list.contains(desc) && !WorkbenchActivityHelper.filterItem(desc)) {
                list.add(desc);
            }
            ++n2;
        }
        return list;
    }

    protected ArrayList<IPerspectiveDescriptor> getPerspectiveItems() {
        ArrayList<IPerspectiveDescriptor> shortcuts = this.getPerspectiveShortcuts();
        ArrayList<IPerspectiveDescriptor> list = new ArrayList<IPerspectiveDescriptor>(shortcuts.size());
        int size = shortcuts.size();
        int i = 0;
        while (i < size) {
            if (!list.contains(shortcuts.get(i))) {
                list.add(shortcuts.get(i));
            }
            ++i;
        }
        return list;
    }

    protected boolean getShowActive() {
        return this.showActive;
    }

    protected IWorkbenchWindow getWindow() {
        return this.window;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    protected abstract void run(IPerspectiveDescriptor var1);

    protected void run(IPerspectiveDescriptor desc, SelectionEvent event) {
        this.run(desc);
    }

    void runOther(SelectionEvent event) {
        IHandlerService handlerService = (IHandlerService)this.window.getService(IHandlerService.class);
        try {
            handlerService.executeCommand(SHOW_PERSP_ID, null);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Failed to execute org.eclipse.ui.perspectives.showPerspective", e));
        }
    }

    protected void showActive(boolean b) {
        this.showActive = b;
    }

    public void dispose() {
        this.window = null;
        super.dispose();
    }
}

