/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.intro.impl.util.DialogUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;

public class Util {
    public static void handleException(String msg, Exception e, Object[] variables) {
        if (msg == null) {
            return;
        }
        if (variables != null) {
            msg = NLS.bind((String)msg, (Object[])variables);
        }
        Log.error(msg, e);
    }

    public static void handleExceptionWithPopUp(Shell parent, String msg, Exception e) {
        if (e instanceof CoreException) {
            if (parent == null) {
                parent = DialogUtil.getActiveShell();
            }
            DialogUtil.displayCoreErrorDialog(parent, msg, (CoreException)((Object)e));
            return;
        }
        if (msg == null) {
            msg = e.getMessage();
        }
        if (parent == null) {
            parent = DialogUtil.getActiveShell();
        }
        DialogUtil.displayErrorMessage(parent, msg, e);
    }

    public static Listener addDebugListener(Control control) {
        Listener listener = e -> {
            switch (e.type) {
                case 13: {
                    System.out.println("Selection EVENT: " + e.toString());
                    break;
                }
                case 12: {
                    System.out.println("Dispose EVENT: " + e.toString());
                    break;
                }
                case 9: {
                    System.out.println("Paint EVENT: " + e.toString());
                    break;
                }
                case 11: {
                    System.out.println("Resize EVENT: " + e.toString());
                    break;
                }
                case 8: {
                    System.out.println("MouseDoubleClick EVENT: " + e.toString());
                    break;
                }
                case 3: {
                    System.out.println("MouseDown EVENT: " + e.toString());
                    break;
                }
                case 4: {
                    System.out.println("MouseUp EVENT: " + e.toString());
                    break;
                }
                case 5: {
                    System.out.println("MouseMove EVENT: " + e.toString());
                    break;
                }
                case 6: {
                    System.out.println("MouseEnter EVENT: " + e.toString());
                    break;
                }
                case 7: {
                    System.out.println("MouseExit EVENT: " + e.toString());
                    break;
                }
                case 32: {
                    System.out.println("MouseHover EVENT: " + e.toString());
                    break;
                }
                case 15: {
                    System.out.println("FocusIn EVENT: " + e.toString());
                    break;
                }
                case 16: {
                    System.out.println("FocusOut EVENT: " + e.toString());
                    break;
                }
                case 1: {
                    System.out.println("KeyDown EVENT: " + e.toString());
                    break;
                }
                case 2: {
                    System.out.println("KeyUp EVENT: " + e.toString());
                    break;
                }
                case 31: {
                    System.out.println("Traverse EVENT: " + e.toString());
                    break;
                }
                case 22: {
                    System.out.println("Show EVENT: " + e.toString());
                    break;
                }
                case 23: {
                    System.out.println("Hide EVENT: " + e.toString());
                    break;
                }
                default: {
                    System.out.println(e.toString());
                }
            }
        };
        int[] allEvents = new int[]{13, 12, 9, 11, 8, 3, 4, 6, 7, 32, 15, 16, 1, 2, 31, 22, 23};
        int i = 0;
        while (i < allEvents.length) {
            control.addListener(allEvents[i], listener);
            ++i;
        }
        return listener;
    }

    public static void sleep(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void highlight(Control control, int color) {
        control.setBackground(control.getDisplay().getSystemColor(color));
    }

    public static void highlightFocusControl() {
        Control control = Display.getCurrent().getFocusControl();
        if (control != null) {
            control.setBackground(Display.getCurrent().getSystemColor(4));
        }
    }

    public static boolean openBrowser(String href) {
        try {
            URL url = new URL(href);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(url);
            return true;
        }
        catch (PartInitException e) {
            Log.error("Intro failed to get Browser support.", e);
            return false;
        }
        catch (MalformedURLException e) {
            Log.error("Intro failed to display: " + href, e);
            return false;
        }
    }

    public static void logPerformanceTime(String message, long startTime) {
        long endTime = System.currentTimeMillis();
        Log.forcedInfo("Intro Performance - " + message + (endTime - startTime) + "ms");
    }

    public static void logPerformanceMessage(String message, long time) {
        Log.forcedInfo("Intro Performance - " + message + " " + time + "ms");
    }
}

