/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application.dialogs;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.dialogs.StartupPreferencePage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class IDEStartupPreferencePage
extends StartupPreferencePage
implements IWorkbenchPreferencePage {
    private Button refreshButton;
    private Button showProblemsButton;
    private Button exitPromptButton;

    protected void createExtraContent(Composite composite) {
        this.refreshButton = this.createCheckBox(IDEWorkbenchMessages.StartupPreferencePage_refreshButton, "REFRESH_WORKSPACE_ON_STARTUP", composite);
        this.showProblemsButton = this.createCheckBox(IDEWorkbenchMessages.StartupPreferencePage_showProblemsButton, "SHOW_PROBLEMS_VIEW_DECORATIONS_ON_STARTUP", composite);
        this.exitPromptButton = this.createCheckBox(IDEWorkbenchMessages.StartupPreferencePage_exitPromptButton, "EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", composite);
        super.createExtraContent(composite);
    }

    protected void performDefaults() {
        IPreferenceStore store = IDEStartupPreferencePage.getIDEPreferenceStore();
        this.refreshButton.setSelection(store.getDefaultBoolean("REFRESH_WORKSPACE_ON_STARTUP"));
        this.showProblemsButton.setSelection(store.getDefaultBoolean("SHOW_PROBLEMS_VIEW_DECORATIONS_ON_STARTUP"));
        this.exitPromptButton.setSelection(store.getDefaultBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW"));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = IDEStartupPreferencePage.getIDEPreferenceStore();
        store.setValue("REFRESH_WORKSPACE_ON_STARTUP", this.refreshButton.getSelection());
        store.setValue("SHOW_PROBLEMS_VIEW_DECORATIONS_ON_STARTUP", this.showProblemsButton.getSelection());
        store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", this.exitPromptButton.getSelection());
        IDEWorkbenchPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    private Button createCheckBox(String text, String preferenceKey, Composite composite) {
        return IDEStartupPreferencePage.createCheckBox((String)text, (boolean)IDEStartupPreferencePage.getIDEPreferenceStore().getBoolean(preferenceKey), (Composite)composite);
    }

    private static IPreferenceStore getIDEPreferenceStore() {
        return IDEWorkbenchPlugin.getDefault().getPreferenceStore();
    }
}

