/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.IDataAspect;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.ITypedDataAspect;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.Messages;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataTypeUtils;

public final class SegmentStoreStatisticsAspects {
    private Function<Number, String> fMapper = e -> String.format("%s", DataTypeUtils.getFormat((DataType)DataType.DURATION, (String)"").format(e));
    private Function<String, String> fLabelMapper = e -> e;
    private List<IDataAspect<NamedStatistics>> fAspects;

    public SegmentStoreStatisticsAspects() {
        this(Collections.emptyList());
    }

    public SegmentStoreStatisticsAspects(List<IDataAspect<NamedStatistics>> userDefinedAspects) {
        this.fAspects = this.createAspects(userDefinedAspects);
    }

    protected synchronized void setMapper(Function<Number, String> mapper) {
        this.fMapper = mapper;
    }

    protected synchronized void setLabelMapper(UnaryOperator<String> mapper) {
        this.fLabelMapper = mapper;
    }

    public synchronized List<IDataAspect<NamedStatistics>> getAspects() {
        return this.fAspects;
    }

    private List<IDataAspect<NamedStatistics>> createAspects(List<IDataAspect<NamedStatistics>> userDefinedAspects) {
        ImmutableList.Builder aspectsBuilder = new ImmutableList.Builder();
        aspectsBuilder.add((Object)new IDataAspect<NamedStatistics>(){

            @Override
            public String getName() {
                return Objects.requireNonNull(Messages.SegmentStoreStatistics_Label);
            }

            @Override
            public @Nullable Object apply(NamedStatistics input) {
                return SegmentStoreStatisticsAspects.this.fLabelMapper.apply(input.getName());
            }
        });
        aspectsBuilder.add((Object)new IDataAspect<NamedStatistics>(){

            @Override
            public String getName() {
                return Objects.requireNonNull(Objects.requireNonNull(Messages.SegmentStoreStatistics_MinLabel));
            }

            @Override
            public @Nullable Object apply(NamedStatistics input) {
                IStatistics<ISegment> statistics = input.getStatistics();
                return statistics.getNbElements() != 0L ? SegmentStoreStatisticsAspects.this.fMapper.apply(statistics.getMinNumber()) : null;
            }
        });
        aspectsBuilder.add((Object)new IDataAspect<NamedStatistics>(){

            @Override
            public String getName() {
                return Objects.requireNonNull(Objects.requireNonNull(Messages.SegmentStoreStatistics_MaxLabel));
            }

            @Override
            public @Nullable Object apply(NamedStatistics input) {
                IStatistics<ISegment> statistics = input.getStatistics();
                return statistics.getNbElements() != 0L ? SegmentStoreStatisticsAspects.this.fMapper.apply(statistics.getMaxNumber()) : null;
            }
        });
        aspectsBuilder.add((Object)new IDataAspect<NamedStatistics>(){

            @Override
            public String getName() {
                return Objects.requireNonNull(Objects.requireNonNull(Messages.SegmentStoreStatistics_AverageLabel));
            }

            @Override
            public @Nullable Object apply(NamedStatistics input) {
                IStatistics<ISegment> statistics = input.getStatistics();
                return statistics.getNbElements() != 0L ? SegmentStoreStatisticsAspects.this.fMapper.apply(statistics.getMean()) : null;
            }
        });
        aspectsBuilder.add((Object)new IDataAspect<NamedStatistics>(){

            @Override
            public String getName() {
                return Objects.requireNonNull(Objects.requireNonNull(Messages.SegmentStoreStatistics_StandardDeviationLabel));
            }

            @Override
            public @Nullable Object apply(NamedStatistics input) {
                IStatistics<ISegment> statistics = input.getStatistics();
                return statistics.getNbElements() != 0L ? SegmentStoreStatisticsAspects.this.fMapper.apply(statistics.getStdDev()) : null;
            }
        });
        aspectsBuilder.add((Object)new IDataAspect<NamedStatistics>(){

            @Override
            public String getName() {
                return Objects.requireNonNull(Objects.requireNonNull(Messages.SegmentStoreStatistics_CountLabel));
            }

            @Override
            public @Nullable Object apply(NamedStatistics input) {
                return String.valueOf(input.getStatistics().getNbElements());
            }
        });
        aspectsBuilder.add((Object)new IDataAspect<NamedStatistics>(){

            @Override
            public String getName() {
                return Objects.requireNonNull(Objects.requireNonNull(Messages.SegmentStoreStatistics_TotalLabel));
            }

            @Override
            public @Nullable Object apply(NamedStatistics input) {
                IStatistics<ISegment> statistics = input.getStatistics();
                return statistics.getNbElements() != 0L ? SegmentStoreStatisticsAspects.this.fMapper.apply(statistics.getTotal()) : null;
            }
        });
        aspectsBuilder.add((Object)new ITypedDataAspect<NamedStatistics>(){

            @Override
            public String getName() {
                return Objects.requireNonNull(Messages.SegmentStoreStatistics_MinTimeRangeLabel);
            }

            @Override
            public @Nullable String apply(NamedStatistics input) {
                ISegment min = input.getStatistics().getMinObject();
                if (min != null) {
                    return DataTypeUtils.toRangeString((long)min.getStart(), (long)min.getEnd());
                }
                return null;
            }

            @Override
            public DataType getDataType() {
                return DataType.TIME_RANGE;
            }
        });
        aspectsBuilder.add((Object)new ITypedDataAspect<NamedStatistics>(){

            @Override
            public String getName() {
                return Objects.requireNonNull(Messages.SegmentStoreStatistics_MaxTimeRangeLabel);
            }

            @Override
            public @Nullable String apply(NamedStatistics input) {
                ISegment max = input.getStatistics().getMaxObject();
                if (max != null) {
                    return DataTypeUtils.toRangeString((long)max.getStart(), (long)max.getEnd());
                }
                return null;
            }

            @Override
            public DataType getDataType() {
                return DataType.TIME_RANGE;
            }
        });
        aspectsBuilder.addAll(userDefinedAspects);
        return aspectsBuilder.build();
    }

    public static class NamedStatistics {
        private String fName;
        private IStatistics<ISegment> fStatistics;

        public NamedStatistics(String name, IStatistics<ISegment> statistics) {
            this.fName = name;
            this.fStatistics = statistics;
        }

        public String getName() {
            return this.fName;
        }

        public IStatistics<ISegment> getStatistics() {
            return this.fStatistics;
        }
    }
}

