/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace.overlay;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.findandreplace.overlay.FindReplaceOverlayAction;

public final class FindReplaceShortcutUtil {
    private FindReplaceShortcutUtil() {
    }

    static void registerActionShortcutsAtControl(FindReplaceOverlayAction action, Control control) {
        control.addKeyListener(KeyListener.keyPressedAdapter(event -> {
            KeyStroke actualStroke = FindReplaceShortcutUtil.extractKeyStroke(event);
            if (action.executeIfMatching(actualStroke)) {
                event.doit = false;
            }
        }));
    }

    private static KeyStroke extractKeyStroke(KeyEvent e) {
        boolean ctrlDown;
        int character = e.character;
        boolean bl = ctrlDown = (e.stateMask & 0x40000) != 0;
        if (ctrlDown && e.character != e.keyCode && e.character < ' ' && (e.keyCode & 0x1000000) == 0) {
            character = (char)(character + 64);
        }
        KeyStroke actualStroke = KeyStroke.getInstance((int)(e.stateMask & (SWT.MOD1 | 0x20000)), (int)(character == 0 ? e.keyCode : character));
        return actualStroke;
    }
}

