/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module;

import java.io.File;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;

public class TmfXmlUtilsTest {
    private static final @NonNull String ANALYSIS_ID = "kernel.linux.sp";

    @Test
    public void testGetElementInFile() {
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        Assert.assertNotNull((String)"XML test file does not exist", (Object)testXmlFile);
        Assert.assertTrue((String)"XML test file does not exist", (boolean)testXmlFile.exists());
        Element analysis = TmfXmlUtils.getElementInFile((String)testXmlFile.getAbsolutePath(), (String)"stateProvider", (String)ANALYSIS_ID);
        Assert.assertNotNull((Object)analysis);
    }

    @Test
    public void testGetChildElements() {
        File testXmlFile = TmfXmlTestFiles.VALID_FILE.getFile();
        if (testXmlFile == null || !testXmlFile.exists()) {
            Assert.fail((String)"XML test file does not exist");
        }
        if (testXmlFile == null) {
            return;
        }
        Element analysis = TmfXmlUtils.getElementInFile((String)testXmlFile.getAbsolutePath(), (String)"stateProvider", (String)ANALYSIS_ID);
        List values = TmfXmlUtils.getChildElements((Element)analysis, (String)"location");
        Assert.assertEquals((long)5L, (long)values.size());
        Element aLocation = (Element)values.get(0);
        List attributes = TmfXmlUtils.getChildElements((Element)aLocation, (String)"stateAttribute");
        Assert.assertEquals((long)2L, (long)attributes.size());
        values = TmfXmlUtils.getChildElements((Element)analysis, (String)"head");
        Assert.assertEquals((long)1L, (long)values.size());
    }
}

