/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.ArrayResult;
import org.eclipse.swtbot.swt.finder.results.IntResult;
import org.eclipse.swtbot.swt.finder.results.ListResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.TableCollection;
import org.eclipse.swtbot.swt.finder.utils.TableRow;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;

public class SWTBotTimeGraph
extends AbstractSWTBotControl<TimeGraphControl> {
    public SWTBotTimeGraph(TimeGraphControl w) throws WidgetNotFoundException {
        super((Control)w);
    }

    public SWTBotTimeGraph(SWTBot bot) throws WidgetNotFoundException {
        super((Control)((TimeGraphControl)bot.widget(WidgetOfType.widgetOfType(TimeGraphControl.class))));
    }

    public SWTBotTimeGraphEntry[] getEntries() {
        return (SWTBotTimeGraphEntry[])this.syncExec((ArrayResult)new ArrayResult<SWTBotTimeGraphEntry>(){

            public SWTBotTimeGraphEntry[] run() {
                ArrayList<SWTBotTimeGraphEntry> entries = new ArrayList<SWTBotTimeGraphEntry>();
                ITimeGraphEntry[] iTimeGraphEntryArray = ((TimeGraphControl)SWTBotTimeGraph.this.widget).getExpandedElements();
                int n = iTimeGraphEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITimeGraphEntry entry = iTimeGraphEntryArray[n2];
                    if (entry.getParent() == null) {
                        entries.add(new SWTBotTimeGraphEntry((TimeGraphControl)SWTBotTimeGraph.this.widget, entry));
                    }
                    ++n2;
                }
                return entries.toArray(new SWTBotTimeGraphEntry[0]);
            }
        });
    }

    public SWTBotTimeGraphEntry getEntry(String ... names) throws WidgetNotFoundException {
        AtomicReference parent = new AtomicReference();
        AtomicReference missing = new AtomicReference();
        SWTBotUtils.waitUntil(timegraph -> {
            List entries = this.syncExec((ListResult)new ListResult<ITimeGraphEntry>(){

                public List<ITimeGraphEntry> run() {
                    return Arrays.asList(timegraph.getExpandedElements());
                }
            });
            ITableLabelProvider labelProvider = timegraph.getLabelProvider();
            parent.set(null);
            String[] stringArray2 = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray2[n2];
                boolean found = false;
                for (ITimeGraphEntry entry : entries) {
                    String label;
                    String string = label = labelProvider == null ? entry.getName() : labelProvider.getColumnText((Object)entry, 0);
                    if (!Objects.equals(entry.getParent(), parent.get()) || !name.equals(label)) continue;
                    parent.set(entry);
                    found = true;
                    break;
                }
                if (!found) {
                    missing.set(name);
                    return false;
                }
                ++n2;
            }
            return true;
        }, (TimeGraphControl)this.widget, () -> "Timed out waiting for time graph entry " + (String)missing.get() + " of parent " + String.valueOf(parent.get()));
        return new SWTBotTimeGraphEntry((TimeGraphControl)this.widget, (ITimeGraphEntry)parent.get());
    }

    public void drag(Point pDown, Point pUp, int mouseMask) {
        int buttonMask;
        int button;
        ArrayList<Integer> buttons = new ArrayList<Integer>();
        ArrayList<Integer> masks = new ArrayList<Integer>();
        masks.add(0);
        if ((mouseMask & 0x80000) != 0) {
            buttons.add(1);
            masks.add((Integer)masks.get(masks.size() - 1) | 0x80000);
        }
        if ((mouseMask & 0x100000) != 0) {
            buttons.add(2);
            masks.add((Integer)masks.get(masks.size() - 1) | 0x100000);
        }
        if ((mouseMask & 0x200000) != 0) {
            buttons.add(3);
            masks.add((Integer)masks.get(masks.size() - 1) | 0x200000);
        }
        if ((mouseMask & 0x800000) != 0) {
            buttons.add(4);
            masks.add((Integer)masks.get(masks.size() - 1) | 0x800000);
        }
        if ((mouseMask & 0x2000000) != 0) {
            buttons.add(5);
            masks.add((Integer)masks.get(masks.size() - 1) | 0x2000000);
        }
        this.notify(6);
        this.notify(5, this.createMouseEvent(pDown.x, pDown.y, 0, 0, 0));
        this.notify(26);
        this.notify(15);
        int buttonIndex = 0;
        while (buttonIndex < buttons.size()) {
            button = (Integer)buttons.get(buttonIndex);
            buttonMask = (Integer)masks.get(buttonIndex);
            this.notify(3, this.createMouseEvent(pDown.x, pDown.y, button, buttonMask, 1));
            ++buttonIndex;
        }
        if (!Objects.equals(pUp, pDown)) {
            this.notify(5, this.createMouseEvent(pUp.x, pUp.y, 0, mouseMask, 0));
        }
        buttonIndex = buttons.size() - 1;
        while (buttonIndex >= 0) {
            button = (Integer)buttons.get(buttonIndex);
            buttonMask = (Integer)masks.get(buttonIndex + 1);
            this.notify(4, this.createMouseEvent(pUp.x, pUp.y, button, buttonMask, 1));
            --buttonIndex;
        }
        this.notify(5, this.createMouseEvent(pUp.x, pUp.y, 0, 0, 0));
        this.notify(7);
        this.notify(27);
        this.notify(16);
    }

    public void expandEntry(boolean expanded, String ... names) {
        SWTBotTimeGraphEntry entryBot = this.getEntry(names);
        if (expanded) {
            entryBot.expand();
        } else {
            entryBot.collapse();
        }
    }

    public int getExpandedElementCount() {
        return this.syncExec(() -> ((TimeGraphControl)((TimeGraphControl)this.widget)).getExpandedElementCount());
    }

    public void expandAll() {
        this.syncExec(() -> ((TimeGraphControl)((TimeGraphControl)this.widget)).expandAll());
    }

    public void collapseAll() {
        this.syncExec(() -> ((TimeGraphControl)((TimeGraphControl)this.widget)).collapseAll());
    }

    public TableCollection selection() {
        return (TableCollection)this.syncExec((Result)new Result<TableCollection>(){

            public TableCollection run() {
                Object element;
                TableCollection collection = new TableCollection();
                ISelection selection = ((TimeGraphControl)SWTBotTimeGraph.this.widget).getSelection();
                if (!selection.isEmpty() && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ITimeGraphEntry) {
                    TableRow tableRow = new TableRow();
                    SWTBotTimeGraphEntry entry = new SWTBotTimeGraphEntry((TimeGraphControl)SWTBotTimeGraph.this.widget, (ITimeGraphEntry)element);
                    int i = 0;
                    while (i < ((TimeGraphControl)SWTBotTimeGraph.this.widget).getTree().getColumnCount()) {
                        tableRow.add(entry.getText(i));
                        ++i;
                    }
                    collection.add(tableRow);
                }
                return collection;
            }
        });
    }

    public int getNameSpace() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((TimeGraphControl)SWTBotTimeGraph.this.widget).getTimeDataProvider().getNameSpace();
            }
        });
    }

    public void setNameSpace(int nameSpace) {
        int x = ((TimeGraphControl)this.widget).getTimeDataProvider().getNameSpace();
        Rectangle bounds = (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                return ((TimeGraphControl)SWTBotTimeGraph.this.widget).getBounds();
            }
        });
        int y = bounds.y + bounds.height / 2;
        this.notify(6);
        this.notify(5, this.createMouseEvent(x, y, 0, 0, 0));
        this.notify(26);
        this.notify(15);
        this.notify(3, this.createMouseEvent(x, y, 1, 0, 1));
        this.notify(29, this.createMouseEvent(nameSpace, y, 0, 0, 0));
        this.notify(5, this.createMouseEvent(nameSpace, y, 1, 524288, 1));
        this.notify(4, this.createMouseEvent(nameSpace, y, 1, 524288, 1));
        this.notify(5, this.createMouseEvent(0, y, 0, 0, 0));
        this.notify(7);
        this.notify(27);
        this.notify(16);
    }

    public AbstractSWTBotControl<TimeGraphControl> moveMouseToWidget() {
        return super.moveMouseToWidget();
    }
}

