/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.parser;

import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.util.Utilities;

public class ForeignRegion
extends ContextRegion {
    private String language = null;
    private String surroundingTag = null;

    public ForeignRegion(String newContext, int newStart, int newTextLength, int newLength) {
        super(newContext, newStart, newTextLength, newLength);
    }

    public ForeignRegion(String newContext, int newStart, int newTextLength, int newLength, String newLanguage) {
        super(newContext, newStart, newTextLength, newLength);
        this.setLanguage(newLanguage);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getSurroundingTag() {
        return this.surroundingTag;
    }

    public void setLanguage(String newLanguage) {
        this.language = newLanguage;
    }

    public void setSurroundingTag(String newSurroundingTag) {
        this.surroundingTag = newSurroundingTag;
    }

    @Override
    public String toString() {
        return "FOREIGN: " + super.toString();
    }

    @Override
    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion flatnode, String changes, int requestStart, int lengthToReplace) {
        RegionChangedEvent result = null;
        int lengthDifference = Utilities.calculateLengthDifference(changes, lengthToReplace);
        this.fLength += lengthDifference;
        this.fTextLength += lengthDifference;
        result = new RegionChangedEvent(flatnode.getParentDocument(), requester, flatnode, this, changes, requestStart, lengthToReplace);
        return result;
    }
}

