/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.annotations;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.internal.tmf.core.annotations.PeriodicAnnotationProvider;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.tmf.core.markers.ITimeReference;
import org.eclipse.tracecompass.tmf.core.markers.TimeReference;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.junit.Assert;
import org.junit.Test;

public class PeriodicAnnotationProviderTest {
    private static final @NonNull String CATEGORY = "Category";
    private static final @NonNull RGBAColor COLOR = new RGBAColor(255, 0, 0, 64);
    private static final @NonNull RGBAColor ODD_COLOR = new RGBAColor(0, 255, 0, 64);
    private static final @NonNull RGBAColor EVEN_COLOR = new RGBAColor(0, 0, 255, 64);
    private static final @NonNull OutputElementStyle COLOR_STYLE = PeriodicAnnotationProviderTest.createStyle(COLOR);
    private static final @NonNull OutputElementStyle ODD_COLOR_STYLE = PeriodicAnnotationProviderTest.createStyle(ODD_COLOR);
    private static final @NonNull OutputElementStyle EVEN_COLOR_STYLE = PeriodicAnnotationProviderTest.createStyle(EVEN_COLOR);

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidPeriod() {
        new PeriodicAnnotationProvider(CATEGORY, ITimeReference.ZERO, 0.0, 0L, COLOR, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRollover() {
        new PeriodicAnnotationProvider(CATEGORY, ITimeReference.ZERO, 100.0, -1L, COLOR, null);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testCategories() {
        PeriodicAnnotationProvider provider = new PeriodicAnnotationProvider(CATEGORY, ITimeReference.ZERO, 100.0, 0L, COLOR, null);
        @NonNull TmfModelResponse response = provider.fetchAnnotationCategories(Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
        AnnotationCategoriesModel model = (AnnotationCategoriesModel)response.getModel();
        Assert.assertNotNull((Object)model);
        Assert.assertEquals(Arrays.asList(CATEGORY), (Object)model.getAnnotationCategories());
    }

    @Test
    public void testLineAnnotationSource() {
        PeriodicAnnotationProvider provider = new PeriodicAnnotationProvider(CATEGORY, ITimeReference.ZERO, 100.0, 0L, COLOR, null);
        ImmutableMap expected = ImmutableMap.of((Object)CATEGORY, Arrays.asList(new Annotation(0L, 0L, -1L, "0", COLOR_STYLE), new Annotation(100L, 0L, -1L, "1", COLOR_STYLE), new Annotation(200L, 0L, -1L, "2", COLOR_STYLE), new Annotation(300L, 0L, -1L, "3", COLOR_STYLE)));
        ImmutableMap fetchParameters = ImmutableMap.of((Object)"requested_times", (Object)StateSystemUtils.getTimes((long)50L, (long)250L, (long)1L));
        PeriodicAnnotationProviderTest.assertAnnotationModelResponse((Map<String, List<Annotation>>)expected, (TmfModelResponse<AnnotationModel>)provider.fetchAnnotations((Map)fetchParameters, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testAlternateShadingAnnotationSource() {
        PeriodicAnnotationProvider provider = new PeriodicAnnotationProvider(CATEGORY, ITimeReference.ZERO, 100.0, 0L, EVEN_COLOR, ODD_COLOR);
        ImmutableMap expected = ImmutableMap.of((Object)CATEGORY, Arrays.asList(new Annotation(-100L, 100L, -1L, "-1", ODD_COLOR_STYLE), new Annotation(0L, 100L, -1L, "0", EVEN_COLOR_STYLE), new Annotation(100L, 100L, -1L, "1", ODD_COLOR_STYLE), new Annotation(200L, 100L, -1L, "2", EVEN_COLOR_STYLE), new Annotation(300L, 100L, -1L, "3", ODD_COLOR_STYLE)));
        ImmutableMap fetchParameters = ImmutableMap.of((Object)"requested_times", (Object)StateSystemUtils.getTimes((long)50L, (long)250L, (long)1L));
        PeriodicAnnotationProviderTest.assertAnnotationModelResponse((Map<String, List<Annotation>>)expected, (TmfModelResponse<AnnotationModel>)provider.fetchAnnotations((Map)fetchParameters, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testNextPreviousIncluded() {
        PeriodicAnnotationProvider provider = new PeriodicAnnotationProvider(CATEGORY, ITimeReference.ZERO, 100.0, 0L, COLOR, null);
        ImmutableMap expected = ImmutableMap.of((Object)CATEGORY, Arrays.asList(new Annotation(-100L, 0L, -1L, "-1", COLOR_STYLE), new Annotation(0L, 0L, -1L, "0", COLOR_STYLE), new Annotation(100L, 0L, -1L, "1", COLOR_STYLE), new Annotation(200L, 0L, -1L, "2", COLOR_STYLE), new Annotation(300L, 0L, -1L, "3", COLOR_STYLE), new Annotation(400L, 0L, -1L, "4", COLOR_STYLE)));
        ImmutableMap fetchParameters = ImmutableMap.of((Object)"requested_times", (Object)StateSystemUtils.getTimes((long)0L, (long)300L, (long)1L));
        PeriodicAnnotationProviderTest.assertAnnotationModelResponse((Map<String, List<Annotation>>)expected, (TmfModelResponse<AnnotationModel>)provider.fetchAnnotations((Map)fetchParameters, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testRollover() {
        PeriodicAnnotationProvider provider = new PeriodicAnnotationProvider(CATEGORY, ITimeReference.ZERO, 100.0, 4L, COLOR, null);
        ImmutableMap expected = ImmutableMap.of((Object)CATEGORY, Arrays.asList(new Annotation(-100L, 0L, -1L, "3", COLOR_STYLE), new Annotation(0L, 0L, -1L, "0", COLOR_STYLE), new Annotation(100L, 0L, -1L, "1", COLOR_STYLE), new Annotation(200L, 0L, -1L, "2", COLOR_STYLE), new Annotation(300L, 0L, -1L, "3", COLOR_STYLE), new Annotation(400L, 0L, -1L, "0", COLOR_STYLE)));
        ImmutableMap fetchParameters = ImmutableMap.of((Object)"requested_times", (Object)StateSystemUtils.getTimes((long)0L, (long)300L, (long)1L));
        PeriodicAnnotationProviderTest.assertAnnotationModelResponse((Map<String, List<Annotation>>)expected, (TmfModelResponse<AnnotationModel>)provider.fetchAnnotations((Map)fetchParameters, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testFractionalPeriod() {
        PeriodicAnnotationProvider provider = new PeriodicAnnotationProvider(CATEGORY, ITimeReference.ZERO, 33.333333333333336, 0L, EVEN_COLOR, ODD_COLOR);
        ImmutableMap expected = ImmutableMap.of((Object)CATEGORY, Arrays.asList(new Annotation(-33L, 33L, -1L, "-1", ODD_COLOR_STYLE), new Annotation(0L, 33L, -1L, "0", EVEN_COLOR_STYLE), new Annotation(33L, 34L, -1L, "1", ODD_COLOR_STYLE), new Annotation(67L, 33L, -1L, "2", EVEN_COLOR_STYLE), new Annotation(100L, 33L, -1L, "3", ODD_COLOR_STYLE), new Annotation(133L, 34L, -1L, "4", EVEN_COLOR_STYLE)));
        ImmutableMap fetchParameters = ImmutableMap.of((Object)"requested_times", (Object)StateSystemUtils.getTimes((long)0L, (long)100L, (long)1L));
        PeriodicAnnotationProviderTest.assertAnnotationModelResponse((Map<String, List<Annotation>>)expected, (TmfModelResponse<AnnotationModel>)provider.fetchAnnotations((Map)fetchParameters, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testSmallPeriod() {
        PeriodicAnnotationProvider provider = new PeriodicAnnotationProvider(CATEGORY, ITimeReference.ZERO, 0.3333333333333333, 0L, EVEN_COLOR, ODD_COLOR);
        ImmutableMap expected = ImmutableMap.of((Object)CATEGORY, Arrays.asList(new Annotation(-1L, 0L, -1L, "-3", ODD_COLOR_STYLE), new Annotation(0L, 0L, -1L, "0", EVEN_COLOR_STYLE), new Annotation(1L, 0L, -1L, "3", ODD_COLOR_STYLE), new Annotation(2L, 0L, -1L, "6", EVEN_COLOR_STYLE), new Annotation(3L, 0L, -1L, "9", ODD_COLOR_STYLE)));
        ImmutableMap fetchParameters = ImmutableMap.of((Object)"requested_times", (Object)StateSystemUtils.getTimes((long)0L, (long)2L, (long)1L));
        PeriodicAnnotationProviderTest.assertAnnotationModelResponse((Map<String, List<Annotation>>)expected, (TmfModelResponse<AnnotationModel>)provider.fetchAnnotations((Map)fetchParameters, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testReference() {
        TimeReference reference = new TimeReference(250L, 10L);
        PeriodicAnnotationProvider provider = new PeriodicAnnotationProvider(CATEGORY, (ITimeReference)reference, 100.0, 0L, COLOR, null);
        ImmutableMap expected = ImmutableMap.of((Object)CATEGORY, Arrays.asList(new Annotation(-50L, 0L, -1L, "7", COLOR_STYLE), new Annotation(50L, 0L, -1L, "8", COLOR_STYLE), new Annotation(150L, 0L, -1L, "9", COLOR_STYLE), new Annotation(250L, 0L, -1L, "10", COLOR_STYLE), new Annotation(350L, 0L, -1L, "11", COLOR_STYLE)));
        ImmutableMap fetchParameters = ImmutableMap.of((Object)"requested_times", (Object)StateSystemUtils.getTimes((long)0L, (long)300L, (long)1L));
        PeriodicAnnotationProviderTest.assertAnnotationModelResponse((Map<String, List<Annotation>>)expected, (TmfModelResponse<AnnotationModel>)provider.fetchAnnotations((Map)fetchParameters, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testResolution() {
        PeriodicAnnotationProvider provider = new PeriodicAnnotationProvider(CATEGORY, ITimeReference.ZERO, 10.0, 0L, EVEN_COLOR, ODD_COLOR);
        ImmutableMap expected = ImmutableMap.of((Object)CATEGORY, Arrays.asList(new Annotation(-20L, 10L, -1L, "-2", EVEN_COLOR_STYLE), new Annotation(0L, 10L, -1L, "0", EVEN_COLOR_STYLE), new Annotation(30L, 10L, -1L, "3", ODD_COLOR_STYLE), new Annotation(50L, 10L, -1L, "5", ODD_COLOR_STYLE), new Annotation(80L, 10L, -1L, "8", EVEN_COLOR_STYLE), new Annotation(100L, 10L, -1L, "10", EVEN_COLOR_STYLE), new Annotation(130L, 10L, -1L, "13", ODD_COLOR_STYLE)));
        ImmutableMap fetchParameters = ImmutableMap.of((Object)"requested_times", (Object)StateSystemUtils.getTimes((long)0L, (long)100L, (long)25L));
        PeriodicAnnotationProviderTest.assertAnnotationModelResponse((Map<String, List<Annotation>>)expected, (TmfModelResponse<AnnotationModel>)provider.fetchAnnotations((Map)fetchParameters, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testIsApplicable() {
        PeriodicAnnotationProvider provider = new PeriodicAnnotationProvider(CATEGORY, ITimeReference.ZERO, 100.0, 0L, COLOR, null){

            public boolean isApplicable(long index) {
                return index % 2L == 0L;
            }
        };
        ImmutableMap expected = ImmutableMap.of((Object)CATEGORY, Arrays.asList(new Annotation(0L, 0L, -1L, "0", COLOR_STYLE), new Annotation(200L, 0L, -1L, "2", COLOR_STYLE), new Annotation(400L, 0L, -1L, "4", COLOR_STYLE), new Annotation(600L, 0L, -1L, "6", COLOR_STYLE), new Annotation(800L, 0L, -1L, "8", COLOR_STYLE), new Annotation(1000L, 0L, -1L, "10", COLOR_STYLE)));
        ImmutableMap fetchParameters = ImmutableMap.of((Object)"requested_times", (Object)StateSystemUtils.getTimes((long)0L, (long)1000L, (long)1L));
        PeriodicAnnotationProviderTest.assertAnnotationModelResponse((Map<String, List<Annotation>>)expected, (TmfModelResponse<AnnotationModel>)provider.fetchAnnotations((Map)fetchParameters, (IProgressMonitor)new NullProgressMonitor()));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void assertAnnotationModelResponse(Map<String, List<Annotation>> expectedMap, TmfModelResponse<AnnotationModel> response) {
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
        AnnotationModel model = (AnnotationModel)response.getModel();
        Assert.assertNotNull((Object)model);
        for (Map.Entry<String, List<Annotation>> entry : expectedMap.entrySet()) {
            String category = entry.getKey();
            List<Annotation> expectedList = entry.getValue();
            @NonNull Collection actualCollection = (Collection)model.getAnnotations().get(category);
            Assert.assertNotNull((Object)actualCollection);
            Assert.assertEquals((long)expectedList.size(), (long)actualCollection.size());
            ArrayList actualList = new ArrayList(actualCollection);
            int i = 0;
            while (i < expectedList.size()) {
                Annotation expected = expectedList.get(i);
                Annotation actual = (Annotation)actualList.get(i);
                Assert.assertEquals((String)("Time comparison for index " + i + " " + actual.toString()), (long)expected.getTime(), (long)actual.getTime());
                Assert.assertEquals((String)("Duration comparison for index " + i + " " + actual.toString()), (long)expected.getDuration(), (long)actual.getDuration());
                Assert.assertEquals((String)("EntryId comparison for index " + i + " " + actual.toString()), (long)expected.getEntryId(), (long)actual.getEntryId());
                Assert.assertEquals((String)("Label comparison for index " + i + " " + actual.toString()), (Object)expected.getLabel(), (Object)actual.getLabel());
                Assert.assertEquals((String)("Style comparison for index " + i + " " + actual.toString()), (Object)expected.getStyle(), (Object)actual.getStyle());
                ++i;
            }
        }
    }

    private static OutputElementStyle createStyle(RGBAColor color) {
        String colorString = color.toString().substring(0, 7);
        return new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)colorString, (Object)"color", (Object)colorString, (Object)"opacity", (Object)Float.valueOf((float)((double)color.getAlpha() / 255.0))));
    }
}

