/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.datastore.core.historytree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.exceptions.RangeException;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.IHTNode;

public class HTNode<E extends IHTInterval>
implements IHTNode<E> {
    @VisibleForTesting
    public static final int COMMON_HEADER_SIZE = 30;
    private static final IntPredicate ALWAYS_TRUE = i -> true;
    private final Comparator<E> fDefaultIntervalComparator = Comparator.comparingLong(IHTInterval::getEnd).thenComparingLong(IHTInterval::getStart);
    private final int fBlockSize;
    private final int fMaxChildren;
    private final long fNodeStart;
    private long fNodeEnd;
    private final int fSequenceNumber;
    private int fParentSequenceNumber;
    private int fSizeOfContentSection;
    private volatile boolean fIsOnDisk;
    private final List<E> fIntervals;
    private final ReentrantReadWriteLock fRwl = new ReentrantReadWriteLock(false);
    private final @Nullable CoreNodeData fExtraData;

    public HTNode(IHTNode.NodeType type, int blockSize, int maxChildren, int seqNumber, int parentSeqNumber, long start) {
        this.fBlockSize = blockSize;
        this.fMaxChildren = maxChildren;
        this.fNodeStart = start;
        this.fSequenceNumber = seqNumber;
        this.fParentSequenceNumber = parentSeqNumber;
        this.fSizeOfContentSection = 0;
        this.fIsOnDisk = false;
        this.fIntervals = new ArrayList();
        this.fExtraData = this.createNodeExtraData(type);
    }

    public static final <E extends IHTInterval, N extends HTNode<E>> N readNode(int blockSize, int maxChildren, FileChannel fc, IHTIntervalReader<E> objectReader, AbstractHistoryTree.IHTNodeFactory<E, N> nodeFactory) throws IOException {
        N newNode;
        ByteBuffer buffer = ByteBuffer.allocate(blockSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.clear();
        int res = fc.read(buffer);
        if (res != blockSize) {
            throw new IOException("The block for the HTNode is not the right size: " + res);
        }
        buffer.flip();
        byte typeByte = buffer.get();
        IHTNode.NodeType type = IHTNode.NodeType.fromByte(typeByte);
        long start = buffer.getLong();
        long end = buffer.getLong();
        int seqNb = buffer.getInt();
        int parentSeqNb = buffer.getInt();
        int intervalCount = buffer.getInt();
        buffer.get();
        switch (type) {
            case CORE: 
            case LEAF: {
                newNode = nodeFactory.createNode(type, blockSize, maxChildren, seqNb, parentSeqNb, start);
                ((HTNode)newNode).readSpecificHeader(buffer);
                break;
            }
            default: {
                throw new IOException();
            }
        }
        ISafeByteBufferReader readBuffer = SafeByteBufferFactory.wrapReader(buffer, res - buffer.position());
        int i = 0;
        while (i < intervalCount) {
            E interval = objectReader.readInterval(readBuffer);
            ((HTNode)newNode).addNoCheck(interval);
            ++i;
        }
        ((HTNode)newNode).setNodeEnd(end);
        ((HTNode)newNode).setOnDisk();
        return newNode;
    }

    protected @Nullable CoreNodeData createNodeExtraData(IHTNode.NodeType type) {
        if (type == IHTNode.NodeType.CORE) {
            return new CoreNodeData(this);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void writeSelf(FileChannel fc) throws IOException {
        this.fRwl.readLock().lock();
        try {
            blockSize = this.getBlockSize();
            buffer = ByteBuffer.allocate(blockSize);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.clear();
            buffer.put(this.getNodeType().toByte());
            buffer.putLong(this.fNodeStart);
            buffer.putLong(this.fNodeEnd);
            buffer.putInt(this.fSequenceNumber);
            buffer.putInt(this.fParentSequenceNumber);
            buffer.putInt(this.fIntervals.size());
            buffer.put((byte)1);
            this.writeSpecificHeader(buffer);
            this.fIntervals.forEach((Consumer<IHTInterval>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$3(java.nio.ByteBuffer org.eclipse.tracecompass.datastore.core.interval.IHTInterval ), (Lorg/eclipse/tracecompass/datastore/core/interval/IHTInterval;)V)((ByteBuffer)buffer));
            if (blockSize - buffer.position() == this.getNodeFreeSpace()) ** GOTO lbl29
            throw new IllegalStateException("Wrong free space: Actual: " + (blockSize - buffer.position()) + ", Expected: " + this.getNodeFreeSpace());
lbl-1000:
            // 1 sources

            {
                buffer.put((byte)0);
lbl29:
                // 2 sources

                ** while (buffer.position() < blockSize)
            }
lbl30:
            // 1 sources

            buffer.flip();
            res = fc.write(buffer);
            if (res != blockSize) {
                throw new IllegalStateException("Wrong size of block written: Actual: " + res + ", Expected: " + blockSize);
            }
        }
        finally {
            this.fRwl.readLock().unlock();
        }
        this.fIsOnDisk = true;
    }

    protected final int getBlockSize() {
        return this.fBlockSize;
    }

    protected final int getMaxChildren() {
        return this.fMaxChildren;
    }

    protected Comparator<E> getIntervalComparator() {
        return this.fDefaultIntervalComparator;
    }

    @Override
    public long getNodeStart() {
        return this.fNodeStart;
    }

    @Override
    public long getNodeEnd() {
        if (this.fIsOnDisk) {
            return this.fNodeEnd;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public int getSequenceNumber() {
        return this.fSequenceNumber;
    }

    @Override
    public int getParentSequenceNumber() {
        return this.fParentSequenceNumber;
    }

    @Override
    public void setParentSequenceNumber(int newParent) {
        this.fParentSequenceNumber = newParent;
    }

    @Override
    public boolean isOnDisk() {
        return this.fIsOnDisk;
    }

    protected @Nullable CoreNodeData getCoreNodeData() {
        return this.fExtraData;
    }

    protected List<E> getIntervals() {
        return ImmutableList.copyOf(this.fIntervals);
    }

    protected void setNodeEnd(long end) {
        this.fNodeEnd = end;
    }

    protected void setOnDisk() {
        this.fIsOnDisk = true;
    }

    @Override
    public void add(E newInterval) {
        this.fRwl.writeLock().lock();
        try {
            int objSize = newInterval.getSizeOnDisk();
            if (objSize > this.getNodeFreeSpace()) {
                throw new IllegalArgumentException("The interval to insert (" + objSize + ") is larger than available space (" + this.getNodeFreeSpace() + ")");
            }
            int insertPoint = Collections.binarySearch(this.fIntervals, newInterval, this.getIntervalComparator());
            insertPoint = insertPoint >= 0 ? insertPoint : -insertPoint - 1;
            this.fIntervals.add(insertPoint, newInterval);
            this.fSizeOfContentSection += objSize;
        }
        finally {
            this.fRwl.writeLock().unlock();
        }
    }

    void addNoCheck(E newInterval) {
        this.fIntervals.add(newInterval);
    }

    @Override
    public Collection<E> getMatchingIntervals(TimeRangeCondition timeCondition, Predicate<E> extraPredicate) {
        if (this.isOnDisk()) {
            return this.doGetMatchingIntervals(timeCondition, extraPredicate);
        }
        this.takeReadLock();
        try {
            Collection<E> collection = this.doGetMatchingIntervals(timeCondition, extraPredicate);
            return collection;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public @Nullable E getMatchingInterval(TimeRangeCondition timeCondition, Predicate<E> extraPredicate) {
        if (this.isOnDisk()) {
            return this.doGetMatchingInterval(timeCondition, extraPredicate);
        }
        this.takeReadLock();
        try {
            E e = this.doGetMatchingInterval(timeCondition, extraPredicate);
            return e;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private Collection<E> doGetMatchingIntervals(TimeRangeCondition timeCondition, Predicate<E> extraPredicate) {
        ArrayList<IHTInterval> list = new ArrayList<IHTInterval>();
        int i = this.getStartIndexFor(timeCondition, extraPredicate);
        while (i < this.fIntervals.size()) {
            IHTInterval curInterval = (IHTInterval)this.fIntervals.get(i);
            if (timeCondition.intersects(curInterval.getStart(), curInterval.getEnd()) && extraPredicate.test(curInterval)) {
                list.add(curInterval);
            }
            ++i;
        }
        return list;
    }

    private @Nullable E doGetMatchingInterval(TimeRangeCondition timeCondition, Predicate<E> extraPredicate) {
        int i = this.getStartIndexFor(timeCondition, extraPredicate);
        while (i < this.fIntervals.size()) {
            IHTInterval curInterval = (IHTInterval)this.fIntervals.get(i);
            if (timeCondition.intersects(curInterval.getStart(), curInterval.getEnd()) && extraPredicate.test(curInterval)) {
                return (E)curInterval;
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected int getStartIndexFor(TimeRangeCondition timeCondition, Predicate<E> extraPredicate) {
        if (this.fIntervals.isEmpty()) {
            return 0;
        }
        low = 0;
        high = this.fIntervals.size() - 1;
        target = timeCondition.min();
        while (low <= high) {
            mid = low + high >>> 1;
            midVal = (IHTInterval)this.fIntervals.get(mid);
            end = midVal.getEnd();
            if (end < target) {
                low = mid + 1;
                continue;
            }
            if (end <= target) ** GOTO lbl18
            high = mid - 1;
            continue;
lbl-1000:
            // 1 sources

            {
                midVal = (IHTInterval)this.fIntervals.get(--mid);
                end = midVal.getEnd();
lbl18:
                // 2 sources

                ** while (end == target && mid > 0)
            }
lbl19:
            // 1 sources

            return end == target ? mid : mid + 1;
        }
        return low;
    }

    public IntPredicate getCoreDataPredicate(Predicate<E> predicate) {
        return ALWAYS_TRUE;
    }

    @Override
    public void closeThisNode(long endtime) {
        this.fRwl.writeLock().lock();
        try {
            if (!this.fIntervals.isEmpty() && endtime < ((IHTInterval)this.fIntervals.get(this.fIntervals.size() - 1)).getEnd()) {
                throw new IllegalArgumentException("Closing end time should be greater than or equal to the end time of the objects of this node");
            }
            this.fNodeEnd = endtime;
        }
        finally {
            this.fRwl.writeLock().unlock();
        }
    }

    @Override
    public final int getTotalHeaderSize() {
        return 30 + this.getSpecificHeaderSize();
    }

    private int getDataSectionEndOffset() {
        return this.getTotalHeaderSize() + this.fSizeOfContentSection;
    }

    @Override
    public int getNodeFreeSpace() {
        this.fRwl.readLock().lock();
        try {
            int ret;
            int n = ret = this.getBlockSize() - this.getDataSectionEndOffset();
            return n;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    @Override
    public long getNodeUsagePercent() {
        this.fRwl.readLock().lock();
        try {
            int blockSize = this.getBlockSize();
            float freePercent = (float)this.getNodeFreeSpace() / (float)(blockSize - this.getTotalHeaderSize()) * 100.0f;
            long l = (long)(100.0f - freePercent);
            return l;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    @Override
    public IHTNode.NodeType getNodeType() {
        @Nullable CoreNodeData extraData = this.getCoreNodeData();
        if (extraData == null) {
            return IHTNode.NodeType.LEAF;
        }
        return IHTNode.NodeType.CORE;
    }

    protected int getSpecificHeaderSize() {
        CoreNodeData extraData = this.fExtraData;
        if (extraData != null) {
            return extraData.getSpecificHeaderSize();
        }
        return 0;
    }

    protected void readSpecificHeader(ByteBuffer buffer) {
        CoreNodeData extraData = this.fExtraData;
        if (extraData != null) {
            extraData.readSpecificHeader(buffer);
        }
    }

    protected void writeSpecificHeader(ByteBuffer buffer) {
        CoreNodeData extraData = this.fExtraData;
        if (extraData != null) {
            extraData.writeSpecificHeader(buffer);
        }
    }

    protected String toStringSpecific() {
        return "";
    }

    @Override
    public boolean isEmpty() {
        return this.fIntervals.isEmpty();
    }

    @Override
    public int getNbChildren() {
        CoreNodeData extraData = this.fExtraData;
        if (extraData != null) {
            return extraData.getNbChildren();
        }
        return IHTNode.super.getNbChildren();
    }

    @Override
    public int getChild(int index) {
        CoreNodeData extraData = this.fExtraData;
        if (extraData != null) {
            return extraData.getChild(index);
        }
        return IHTNode.super.getChild(index);
    }

    @Override
    public int getLatestChild() {
        CoreNodeData extraData = this.fExtraData;
        if (extraData != null) {
            return extraData.getLatestChild();
        }
        return IHTNode.super.getLatestChild();
    }

    @Override
    public void linkNewChild(@NonNull IHTNode<E> childNode) {
        CoreNodeData extraData = this.fExtraData;
        if (extraData != null) {
            extraData.linkNewChild(childNode);
            return;
        }
        IHTNode.super.linkNewChild(childNode);
    }

    @Override
    public Collection<Integer> selectNextChildren(TimeRangeCondition timeCondition) throws RangeException {
        CoreNodeData extraData = this.fExtraData;
        if (extraData != null) {
            return extraData.selectNextChildren(timeCondition);
        }
        return IHTNode.super.selectNextChildren(timeCondition);
    }

    protected Collection<Integer> selectNextChildren(TimeRangeCondition timeCondition, IntPredicate extraPredicate) throws RangeException {
        CoreNodeData extraData = this.fExtraData;
        if (extraData != null) {
            return extraData.selectNextChildren(timeCondition, extraPredicate);
        }
        return IHTNode.super.selectNextChildren(timeCondition);
    }

    protected void takeReadLock() {
        this.fRwl.readLock().lock();
    }

    protected void releaseReadLock() {
        this.fRwl.readLock().unlock();
    }

    protected void takeWriteLock() {
        this.fRwl.writeLock().lock();
    }

    protected void releaseWriteLock() {
        this.fRwl.writeLock().unlock();
    }

    public String toString() {
        return String.format("Node #%d, %s, %s, %d intervals (%d%% used), [%d - %s]", this.fSequenceNumber, this.fParentSequenceNumber == -1 ? "Root" : "Parent #" + this.fParentSequenceNumber, this.toStringSpecific(), this.fIntervals.size(), this.getNodeUsagePercent(), this.fNodeStart, this.fIsOnDisk || this.fNodeEnd != 0L ? Long.valueOf(this.fNodeEnd) : "...");
    }

    public int hashCode() {
        return Objects.hash(this.fBlockSize, this.fMaxChildren, this.fNodeStart, this.fNodeEnd, this.fSequenceNumber, this.fParentSequenceNumber, this.fExtraData);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HTNode other = (HTNode)obj;
        return this.fBlockSize == other.fBlockSize && this.fMaxChildren == other.fMaxChildren && this.fNodeStart == other.fNodeStart && this.fNodeEnd == other.fNodeEnd && this.fSequenceNumber == other.fSequenceNumber && this.fParentSequenceNumber == other.fParentSequenceNumber && Objects.equals(this.fExtraData, other.fExtraData);
    }

    @VisibleForTesting
    public void debugPrintIntervals(PrintStream writer) {
        this.getIntervals().forEach(writer::println);
    }

    private static /* synthetic */ void lambda$3(ByteBuffer byteBuffer, IHTInterval i) {
        i.writeSegment(SafeByteBufferFactory.wrapWriter(byteBuffer, i.getSizeOnDisk()));
    }

    protected static class CoreNodeData {
        private final HTNode<?> fNode;
        private final int[] fChildren;
        private int fNbChildren;

        public CoreNodeData(HTNode<?> node) {
            this.fNode = node;
            this.fNbChildren = 0;
            this.fChildren = new int[this.fNode.fMaxChildren];
        }

        protected HTNode<?> getNode() {
            return this.fNode;
        }

        protected void readSpecificHeader(ByteBuffer buffer) {
            this.fNode.takeWriteLock();
            try {
                int size = this.fNode.getMaxChildren();
                this.fNbChildren = buffer.getInt();
                int i = 0;
                while (i < this.fNbChildren) {
                    this.fChildren[i] = buffer.getInt();
                    ++i;
                }
                i = this.fNbChildren;
                while (i < size) {
                    buffer.getInt();
                    ++i;
                }
            }
            finally {
                this.fNode.releaseWriteLock();
            }
        }

        protected void writeSpecificHeader(ByteBuffer buffer) {
            this.fNode.takeReadLock();
            try {
                buffer.putInt(this.fNbChildren);
                int i = 0;
                while (i < this.fNbChildren) {
                    buffer.putInt(this.fChildren[i]);
                    ++i;
                }
                i = this.fNbChildren;
                while (i < this.fNode.getMaxChildren()) {
                    buffer.putInt(0);
                    ++i;
                }
            }
            finally {
                this.fNode.releaseReadLock();
            }
        }

        public int getNbChildren() {
            this.fNode.takeReadLock();
            try {
                int n = this.fNbChildren;
                return n;
            }
            finally {
                this.fNode.releaseReadLock();
            }
        }

        public int getChild(int index) {
            this.fNode.takeReadLock();
            try {
                if (index >= this.fNbChildren) {
                    throw new IndexOutOfBoundsException("The child at index " + index + " does not exist");
                }
                int n = this.fChildren[index];
                return n;
            }
            finally {
                this.fNode.releaseReadLock();
            }
        }

        public int getLatestChild() {
            this.fNode.takeReadLock();
            try {
                int n = this.fChildren[this.fNbChildren - 1];
                return n;
            }
            finally {
                this.fNode.releaseReadLock();
            }
        }

        public void linkNewChild(IHTNode<?> childNode) {
            this.fNode.takeWriteLock();
            try {
                if (this.fNbChildren >= this.fNode.getMaxChildren()) {
                    throw new IllegalStateException("Asked to link another child but parent already has maximum number of children");
                }
                this.fChildren[this.fNbChildren] = childNode.getSequenceNumber();
                ++this.fNbChildren;
            }
            finally {
                this.fNode.releaseWriteLock();
            }
        }

        protected int getSpecificHeaderSize() {
            int maxChildren = this.fNode.getMaxChildren();
            int specificSize = 4 + 4 * maxChildren;
            return specificSize;
        }

        public String toString() {
            return String.format("Core Node, %d children %s", this.fNbChildren, Arrays.toString(Arrays.copyOf(this.fChildren, this.fNbChildren)));
        }

        public final Collection<Integer> selectNextChildren(TimeRangeCondition timeCondition) {
            return this.selectNextChildren(timeCondition, ALWAYS_TRUE);
        }

        public final Collection<Integer> selectNextChildren(TimeRangeCondition timeCondition, IntPredicate extraPredicate) {
            this.fNode.takeReadLock();
            try {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int index : this.selectNextIndices(timeCondition)) {
                    if (!extraPredicate.test(index)) continue;
                    list.add(this.fChildren[index]);
                }
                ArrayList<Integer> arrayList = list;
                return arrayList;
            }
            finally {
                this.fNode.releaseReadLock();
            }
        }

        protected Collection<Integer> selectNextIndices(TimeRangeCondition timeCondition) {
            ArrayList<Integer> childList = new ArrayList<Integer>();
            int i = 0;
            while (i < this.fNbChildren) {
                childList.add(i);
                ++i;
            }
            return childList;
        }

        public int hashCode() {
            return Objects.hash(this.fNbChildren, this.fChildren);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            CoreNodeData other = (CoreNodeData)obj;
            return this.fNbChildren == other.fNbChildren && Arrays.equals(this.fChildren, other.fChildren);
        }
    }
}

