/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlLocationCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlMappingGroupCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateSystemPathCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionStateChange;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueConstant;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueEventField;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueEventName;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValuePool;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueQuery;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueScript;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueSelf;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueStackPeek;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueTypedWrapper;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public class TmfXmlStateValueCu
implements IDataDrivenCompilationUnit {
    private final Supplier<DataDrivenValue> fGenerator;
    private static final String CURRENT_SCENARIO = "#CurrentScenario";
    public static final TmfXmlStateValueCu CURRENT_SCENARIO_QUARK = new TmfXmlStateValueCu(() -> {
        throw new UnsupportedOperationException("This should never do anything");
    });

    TmfXmlStateValueCu(Supplier<DataDrivenValue> generator) {
        this.fGenerator = generator;
    }

    @Override
    public DataDrivenValue generate() {
        return Objects.requireNonNull(this.fGenerator.get());
    }

    public static @Nullable List<TmfXmlStateValueCu> compileAttribute(AnalysisCompilationData analysisData, Element valueEl) {
        String type = valueEl.getAttribute("type");
        ITmfStateValue.Type forcedType = ITmfStateValue.Type.NULL;
        switch (type) {
            case "constant": {
                String name = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                if (name == null || name.isEmpty()) {
                    Activator.logError("The value of a constant attribute should not be empty");
                    return null;
                }
                if (name.equals(CURRENT_SCENARIO)) {
                    return Collections.singletonList(CURRENT_SCENARIO_QUARK);
                }
                TmfXmlStateValueCu tmfXmlStateValueCu = new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(null, forcedType, name));
                return Collections.singletonList(tmfXmlStateValueCu);
            }
            case "eventField": {
                String name = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                if (name == null || name.isEmpty()) {
                    Activator.logError("The value of an event field attribute should not be null");
                    return null;
                }
                return Collections.singletonList(new TmfXmlStateValueCu(() -> new DataDrivenValueEventField(null, forcedType, name)));
            }
            case "location": {
                String name = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                if (name == null || name.isEmpty()) {
                    Activator.logError("The value of a location attribute should not be null");
                    return null;
                }
                TmfXmlLocationCu location = analysisData.getLocation(name);
                if (location == null) {
                    Activator.logError("Location " + name + " does not exist");
                    return null;
                }
                return location.getValues();
            }
            case "query": {
                List<Element> childElements = TmfXmlUtils.getChildElements(valueEl, "stateAttribute");
                if (childElements.isEmpty()) {
                    Activator.logError("A query state attribute should have children attributes");
                    return null;
                }
                TmfXmlStateSystemPathCu path = TmfXmlStateSystemPathCu.compile(analysisData, childElements);
                if (path == null) {
                    return null;
                }
                return Collections.singletonList(new TmfXmlStateValueCu(new StateValueQueryGenerator(path, null, forcedType)));
            }
            case "eventName": {
                return Collections.singletonList(new TmfXmlStateValueCu(() -> new DataDrivenValueEventName(null)));
            }
            case "null": {
                return Collections.singletonList(new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(null, forcedType, null)));
            }
            case "self": {
                return Collections.singletonList(new TmfXmlStateValueCu(() -> new DataDrivenValueSelf(forcedType)));
            }
            case "pool": {
                return Collections.singletonList(new TmfXmlStateValueCu(() -> DataDrivenValuePool.getInstance()));
            }
        }
        Activator.logError("Compiling state value: The XML element is not of the right type " + type);
        return null;
    }

    private static @Nullable String getValueString(AnalysisCompilationData analysisContent, Element attribute) {
        return analysisContent.getStringValue(attribute.getAttribute("value"));
    }

    public static @Nullable TmfXmlStateValueCu compileValue(AnalysisCompilationData analysisData, Element valueEl) {
        ITmfStateValue.Type forcedType;
        String type = valueEl.getAttribute("type");
        String stack = valueEl.getAttribute("stack");
        DataDrivenActionStateChange.StackAction stackAction = DataDrivenActionStateChange.StackAction.getTypeFromString(stack);
        if (stackAction == DataDrivenActionStateChange.StackAction.PEEK) {
            type = "peek";
        }
        String mapGroupAttrib = valueEl.getAttribute("mappingGroup");
        TmfXmlMappingGroupCu mappingGroup = analysisData.getMappingGroup(mapGroupAttrib);
        if (!mapGroupAttrib.isEmpty() && mappingGroup == null) {
            Activator.logError("The mapping group " + mapGroupAttrib + " does not exist in this analysis");
            return null;
        }
        String mappingGroupId = mapGroupAttrib.isEmpty() ? null : mapGroupAttrib;
        String forcedTypeName = valueEl.getAttribute("forcedType");
        ITmfStateValue.Type type2 = forcedType = forcedTypeName.isEmpty() ? ITmfStateValue.Type.NULL : TmfXmlUtils.getTmfStateValueByName(forcedTypeName);
        if (forcedType == null) {
            Activator.logError("The given type name \"" + forcedType + "\" does not correspond to any ITmfStateValue.Type");
            return null;
        }
        switch (type) {
            case "int": {
                String value;
                if (mappingGroup != null) {
                    Activator.logWarning("state value is type int but a mappingGroup is specified");
                }
                if ((value = TmfXmlStateValueCu.getValueString(analysisData, valueEl)) == null) {
                    return null;
                }
                Object intValue = TmfXmlStateValueCu.convertValueToType(value, ITmfStateValue.Type.INTEGER);
                if (intValue == null) {
                    return null;
                }
                return new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(mappingGroupId, forcedType, intValue));
            }
            case "long": {
                String value;
                if (mappingGroup != null) {
                    Activator.logWarning("state value is type long but a mappingGroup is specified");
                }
                if ((value = TmfXmlStateValueCu.getValueString(analysisData, valueEl)) == null) {
                    return null;
                }
                Object longValue = TmfXmlStateValueCu.convertValueToType(value, ITmfStateValue.Type.LONG);
                if (longValue == null) {
                    return null;
                }
                return new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(mappingGroupId, forcedType, longValue));
            }
            case "string": {
                String value = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                return new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(mappingGroupId, forcedType, value));
            }
            case "null": {
                if (mappingGroup != null) {
                    Activator.logWarning("state value is type null but a mappingGroup is specified");
                }
                return new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(mappingGroupId, forcedType, null));
            }
            case "eventField": {
                String name = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                if (name == null || name.isEmpty()) {
                    Activator.logError("The value of an event field attribute should not be null");
                    return null;
                }
                return new TmfXmlStateValueCu(() -> new DataDrivenValueEventField(mappingGroupId, forcedType, name));
            }
            case "eventName": {
                return new TmfXmlStateValueCu(() -> new DataDrivenValueEventName(mappingGroupId));
            }
            case "delete": {
                if (mappingGroup != null) {
                    Activator.logWarning("state value is type delete but a mappingGroup is specified");
                }
                return new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(mappingGroupId, forcedType, null));
            }
            case "query": {
                List<Element> childElements = TmfXmlUtils.getChildElements(valueEl, "stateAttribute");
                if (childElements.isEmpty()) {
                    Activator.logError("A query state value should have children attributes");
                    return null;
                }
                TmfXmlStateSystemPathCu path = TmfXmlStateSystemPathCu.compile(analysisData, childElements);
                if (path == null) {
                    return null;
                }
                return new TmfXmlStateValueCu(new StateValueQueryGenerator(path, mappingGroupId, forcedType));
            }
            case "script": {
                List<Element> childElements = TmfXmlUtils.getChildElements(valueEl, "stateValue");
                HashMap<String, TmfXmlStateValueCu> values = new HashMap<String, TmfXmlStateValueCu>();
                for (Element subAttributeNode : childElements) {
                    String valueId = subAttributeNode.getAttribute("id");
                    TmfXmlStateValueCu subAttrib = TmfXmlStateValueCu.compileValue(analysisData, subAttributeNode);
                    if (subAttrib == null) {
                        return null;
                    }
                    values.put(valueId, subAttrib);
                }
                String script = TmfXmlStateValueCu.getValueString(analysisData, valueEl);
                if (script == null) {
                    Activator.logError("The script resolves to null");
                    return null;
                }
                String scriptEngine = valueEl.getAttribute("scriptEngine");
                if (scriptEngine.isEmpty()) {
                    scriptEngine = "rhino";
                }
                return new TmfXmlStateValueCu(new StateValueScriptGenerator(values, script, scriptEngine, mappingGroupId, forcedType));
            }
            case "peek": {
                TmfXmlStateSystemPathCu path;
                List<Element> childElements = TmfXmlUtils.getChildElements(valueEl, "stateAttribute");
                if (childElements.isEmpty()) {
                    Activator.logWarning("Compiling state value: Stack peek should have children state attributes");
                }
                if ((path = TmfXmlStateSystemPathCu.compile(analysisData, childElements)) == null) {
                    return null;
                }
                return new TmfXmlStateValueCu(new StateValueStackPeekGenerator(path, mappingGroupId, forcedType));
            }
        }
        Activator.logError("Compiling state value: The XML element is not of the right type " + type);
        return null;
    }

    public static @Nullable TmfXmlStateValueCu compileField(AnalysisCompilationData analysisData, Element fieldEl) {
        String name = analysisData.getStringValue(fieldEl.getAttribute("name"));
        if (name == null || name.isEmpty()) {
            Activator.logError("The value of an event field attribute should not be null");
            return null;
        }
        return new TmfXmlStateValueCu(() -> new DataDrivenValueEventField(null, ITmfStateValue.Type.NULL, name));
    }

    public static TmfXmlStateValueCu compileAsQuery(TmfXmlStateSystemPathCu path) {
        return new TmfXmlStateValueCu(new StateValueQueryGenerator(path, null, ITmfStateValue.Type.NULL));
    }

    public static @Nullable TmfXmlStateValueCu compileSegmentField(AnalysisCompilationData analysisData, Element element) {
        Object value;
        String typeStr = element.getAttribute("type");
        String name = element.getAttribute("name");
        if (typeStr.isEmpty()) {
            Activator.logError("Segment field: missing 'type' attribute for field " + name);
            return null;
        }
        ITmfStateValue.Type type = TmfXmlUtils.getTmfStateValueByName(typeStr);
        if (type == null) {
            Activator.logError("The given type name \"" + typeStr + "\" does not correspond to any ITmfStateValue.Type");
            return null;
        }
        String constantValue = TmfXmlStateValueCu.getValueString(analysisData, element);
        List<Element> childElements = TmfXmlUtils.getChildElements(element, "stateValue");
        if (type.equals((Object)ITmfStateValue.Type.NULL)) {
            if (constantValue != null && !constantValue.isEmpty()) {
                Activator.logWarning("Segment field: type is null, the constant value will be ignored");
            }
            if (!childElements.isEmpty()) {
                Activator.logWarning("Segment field: type is null, the <stateValue> element will be ignored");
            }
            return new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(null, type, null));
        }
        if (constantValue == null || constantValue.isEmpty()) {
            TmfXmlStateValueCu valueCu;
            if (childElements.isEmpty()) {
                Activator.logError("Segment field: there should be either a 'value' attribute or <stateValue> element for type " + typeStr);
                return null;
            }
            if (childElements.size() > 1) {
                Activator.logWarning("Segment field: there should be only one <stateValue> element under the field");
            }
            if ((valueCu = TmfXmlStateValueCu.compileValue(analysisData, Objects.requireNonNull(childElements.get(0)))) == null) {
                return null;
            }
            return new TmfXmlStateValueCu(new ValueWrapperGenerator(valueCu, type));
        }
        if (!childElements.isEmpty()) {
            Activator.logWarning("Segment field: type is null, the <stateValue> element will be ignored");
        }
        if ((value = TmfXmlStateValueCu.convertValueToType(constantValue, type)) == null) {
            return null;
        }
        return new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(null, type, value));
    }

    private static @Nullable Object convertValueToType(String value, ITmfStateValue.Type type) {
        switch (type) {
            case DOUBLE: {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    Activator.logError("Compiling value: value is not a parseable double: " + value);
                    return null;
                }
            }
            case INTEGER: {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    Activator.logError("Compiling value: value is not a parseable integer: " + value);
                    return null;
                }
            }
            case LONG: {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    Activator.logError("Compiling value: value is not a parseable integer: " + value);
                    return null;
                }
            }
        }
        return value;
    }

    private static class StateValueQueryGenerator
    implements Supplier<DataDrivenValue> {
        private final TmfXmlStateSystemPathCu fPath;
        private final @Nullable String fMappingGroupId;
        private final ITmfStateValue.Type fForcedType;

        StateValueQueryGenerator(TmfXmlStateSystemPathCu ssPath, @Nullable String mappingGroup, ITmfStateValue.Type forcedType) {
            this.fPath = ssPath;
            this.fMappingGroupId = mappingGroup;
            this.fForcedType = forcedType;
        }

        @Override
        public DataDrivenValue get() {
            DataDrivenStateSystemPath path = this.fPath.generate();
            return new DataDrivenValueQuery(this.fMappingGroupId, this.fForcedType, path);
        }
    }

    private static class StateValueScriptGenerator
    implements Supplier<DataDrivenValue> {
        private final Map<String, TmfXmlStateValueCu> fMap;
        private final String fScript;
        private final String fScriptEngine;
        private final @Nullable String fMappingGroupId;
        private final ITmfStateValue.Type fForcedType;

        StateValueScriptGenerator(Map<String, TmfXmlStateValueCu> list, String script, String scriptEngine, @Nullable String mappingGroup, ITmfStateValue.Type forcedType) {
            this.fMap = list;
            this.fScript = script;
            this.fScriptEngine = scriptEngine;
            this.fMappingGroupId = mappingGroup;
            this.fForcedType = forcedType;
        }

        @Override
        public DataDrivenValue get() {
            HashMap<String, DataDrivenValue> values = new HashMap<String, DataDrivenValue>();
            this.fMap.entrySet().forEach(entry -> {
                DataDrivenValue dataDrivenValue = values.put((String)entry.getKey(), Objects.requireNonNull((TmfXmlStateValueCu)entry.getValue()).generate());
            });
            return new DataDrivenValueScript(this.fMappingGroupId, this.fForcedType, values, this.fScript, this.fScriptEngine);
        }
    }

    private static class StateValueStackPeekGenerator
    implements Supplier<DataDrivenValue> {
        private final TmfXmlStateSystemPathCu fPath;
        private final @Nullable String fMappingGroupId;
        private final ITmfStateValue.Type fForcedType;

        StateValueStackPeekGenerator(TmfXmlStateSystemPathCu path, @Nullable String mappingGroup, ITmfStateValue.Type forcedType) {
            this.fPath = path;
            this.fMappingGroupId = mappingGroup;
            this.fForcedType = forcedType;
        }

        @Override
        public DataDrivenValue get() {
            DataDrivenStateSystemPath path = this.fPath.generate();
            return new DataDrivenValueStackPeek(this.fMappingGroupId, this.fForcedType, path);
        }
    }

    public static class ValueWrapperGenerator
    implements Supplier<DataDrivenValue> {
        private final ITmfStateValue.Type fType;
        private final TmfXmlStateValueCu fValue;

        public ValueWrapperGenerator(TmfXmlStateValueCu valueCu, ITmfStateValue.Type type) {
            this.fType = type;
            this.fValue = valueCu;
        }

        @Override
        public DataDrivenValue get() {
            DataDrivenValue value = this.fValue.generate();
            return new DataDrivenValueTypedWrapper(value, this.fType);
        }
    }
}

