/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CtfCoreTestPlugin
extends Plugin {
    private static final String TEMP_DIR_NAME = ".temp";
    public static final String PLUGIN_ID = "org.eclipse.tracecompass.ctf.core.tests";
    private static CtfCoreTestPlugin fPlugin;

    public CtfCoreTestPlugin() {
        CtfCoreTestPlugin.setDefault(this);
    }

    public static CtfCoreTestPlugin getDefault() {
        return fPlugin;
    }

    private static void setDefault(CtfCoreTestPlugin plugin) {
        fPlugin = plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        CtfCoreTestPlugin.setDefault(this);
    }

    public void stop(BundleContext context) throws Exception {
        CtfCoreTestPlugin.setDefault(null);
        super.stop(context);
    }

    public static String getTemporaryDirPath() {
        String property = System.getProperty("osgi.instance.area");
        if (property != null) {
            try {
                File dir = URIUtil.toFile((URI)URIUtil.fromString((String)property));
                dir = new File(dir.getAbsolutePath() + File.separator + TEMP_DIR_NAME);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                return dir.getAbsolutePath();
            }
            catch (URISyntaxException e) {
                Activator.logError((String)e.getLocalizedMessage(), (Exception)e);
            }
        }
        return System.getProperty("java.io.tmpdir");
    }

    public static IPath getAbsoluteFilePath(String relativePath) {
        CtfCoreTestPlugin plugin = CtfCoreTestPlugin.getDefault();
        if (plugin == null) {
            throw new IllegalStateException();
        }
        URL location = FileLocator.find((Bundle)plugin.getBundle(), (IPath)new Path(relativePath), null);
        try {
            return new Path(FileLocator.toFileURL((URL)location).getPath());
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }
}

