/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.model.config;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSource;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSourceType;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigParamDescriptor;
import org.eclipse.tracecompass.tmf.core.config.TmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigurationSourceType;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfConfigurationException;

@NonNullByDefault
public class TestConfigurationSource
implements ITmfConfigurationSource {
    private static final ITmfConfigurationSourceType fType;
    private int fInstanceId = 0;
    public static final String STUB_ANALYSIS_TYPE_ID = "org.eclipse.tracecompass.tmf.tests.stubs.model.config.testsourcetype";
    public static final String NAME = "Stub Configuration Source";
    public static final String DESCRIPTION = "Sub Configuration Source description";
    public static final String DESCRIPTION_PREFIX = "Stub Configuration: ";
    public static final String PATH_KEY = "path";
    public static final String PATH_DESCRIPTION = "path";
    private Map<String, ITmfConfiguration> fConfigurations = new ConcurrentHashMap<String, ITmfConfiguration>();

    static {
        TmfConfigParamDescriptor.Builder descBuilder = new TmfConfigParamDescriptor.Builder();
        descBuilder.setKeyName("path").setDescription("path");
        fType = new TmfConfigurationSourceType.Builder().setId(STUB_ANALYSIS_TYPE_ID).setDescription(DESCRIPTION).setName(NAME).setConfigParamDescriptors((List)ImmutableList.of((Object)descBuilder.build())).build();
    }

    public ITmfConfigurationSourceType getConfigurationSourceType() {
        return Objects.requireNonNull(fType);
    }

    public ITmfConfiguration create(Map<String, Object> parameters) throws TmfConfigurationException {
        String path = (String)parameters.get("path");
        if (path == null) {
            throw new TmfConfigurationException("Missing path parameter");
        }
        TmfConfiguration.Builder builder = new TmfConfiguration.Builder().setName(path).setId(path + this.fInstanceId++).setDescription(DESCRIPTION_PREFIX + path).setSourceTypeId(STUB_ANALYSIS_TYPE_ID);
        ITmfConfiguration config = builder.build();
        this.fConfigurations.put(config.getId(), config);
        return config;
    }

    public ITmfConfiguration update(String id, Map<String, Object> parameters) throws TmfConfigurationException {
        ITmfConfiguration config = this.fConfigurations.get(id);
        if (config == null) {
            throw new TmfConfigurationException("Configuration doesn't exist");
        }
        return config;
    }

    public @Nullable ITmfConfiguration remove(String id) {
        return this.fConfigurations.remove(id);
    }

    public boolean contains(String id) {
        return this.fConfigurations.containsKey(id);
    }

    public List<ITmfConfiguration> getConfigurations() {
        return Collections.emptyList();
    }

    public @Nullable ITmfConfiguration get(String id) {
        return this.fConfigurations.get(id);
    }

    public void dispose() {
        this.fConfigurations.clear();
    }
}

