/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTestSegmentStore {
    protected final ISegmentStore<@NonNull TestSegment> fSegmentStore = this.getSegmentStore();
    private static final @NonNull TestSegment SEGMENT_2_6 = new TestSegment(2L, 6L, "test");
    private static final @NonNull TestSegment SEGMENT_4_6 = new TestSegment(4L, 6L, "test2");
    private static final @NonNull TestSegment SEGMENT_4_8 = new TestSegment(4L, 8L, "test3");
    private static final @NonNull TestSegment SEGMENT_6_8 = new TestSegment(6L, 8L, "test");
    private static final @NonNull TestSegment SEGMENT_10_14 = new TestSegment(10L, 14L, "test");
    protected static final List<@NonNull TestSegment> SEGMENTS = ImmutableList.of((Object)SEGMENT_2_6, (Object)SEGMENT_4_6, (Object)SEGMENT_4_8, (Object)SEGMENT_6_8, (Object)SEGMENT_10_14);
    private static final List<@NonNull TestSegment> REVERSE_SEGMENTS = Lists.reverse(SEGMENTS);

    protected abstract ISegmentStore<@NonNull TestSegment> getSegmentStore();

    protected abstract ISegmentStore<@NonNull TestSegment> getSegmentStore(@NonNull TestSegment @NonNull [] var1);

    protected void assertSegmentsEqual(ISegment expected, ISegment actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Before
    public void setup() {
        for (TestSegment segment : SEGMENTS) {
            this.fSegmentStore.add((Object)segment);
        }
    }

    @After
    public void teardown() {
        this.fSegmentStore.dispose();
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)SEGMENTS.size(), (long)this.fSegmentStore.size());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertFalse((boolean)this.fSegmentStore.isEmpty());
        this.fSegmentStore.clear();
        Assert.assertTrue((boolean)this.fSegmentStore.isEmpty());
    }

    @Test
    public void testAddAll() {
        Assert.assertFalse((boolean)this.fSegmentStore.isEmpty());
        this.fSegmentStore.clear();
        Assert.assertTrue((boolean)this.fSegmentStore.isEmpty());
        this.fSegmentStore.addAll(SEGMENTS);
        Assert.assertTrue((boolean)this.fSegmentStore.containsAll(SEGMENTS));
    }

    @Test
    public void testAddAllConstructor() {
        ISegmentStore<@NonNull TestSegment> other = this.getSegmentStore((TestSegment[])this.fSegmentStore.toArray((Object[])new TestSegment[this.fSegmentStore.size()]));
        Assert.assertTrue((boolean)this.fSegmentStore.containsAll(other));
        Assert.assertTrue((boolean)other.containsAll(this.fSegmentStore));
    }

    @Test
    public void testAddAllConstructorOutOfOrder() {
        ISegmentStore<@NonNull TestSegment> other = this.getSegmentStore(REVERSE_SEGMENTS.toArray(new TestSegment[this.fSegmentStore.size()]));
        Assert.assertTrue((boolean)this.fSegmentStore.containsAll(other));
        Assert.assertTrue((boolean)other.containsAll(this.fSegmentStore));
    }

    @Test
    public void testAddAllOutOfOrder() {
        Assert.assertFalse((boolean)this.fSegmentStore.isEmpty());
        this.fSegmentStore.clear();
        Assert.assertTrue((boolean)this.fSegmentStore.isEmpty());
        this.fSegmentStore.addAll(REVERSE_SEGMENTS);
        Assert.assertTrue((boolean)this.fSegmentStore.containsAll(SEGMENTS));
    }

    @Test
    public void testContains() {
        BasicSegment otherSegment = new BasicSegment(0L, 20L);
        Assert.assertTrue((boolean)this.fSegmentStore.contains((Object)SEGMENT_2_6));
        Assert.assertTrue((boolean)this.fSegmentStore.contains((Object)SEGMENT_4_8));
        Assert.assertFalse((boolean)this.fSegmentStore.contains((Object)otherSegment));
    }

    public void testContainsAll() {
        ISegmentStore<@NonNull TestSegment> store = this.getSegmentStore();
        store.add((Object)SEGMENT_2_6);
        Assert.assertTrue((boolean)store.containsAll(Collections.emptyList()));
        Assert.assertTrue((boolean)store.containsAll(Collections.singleton(SEGMENT_2_6)));
        Assert.assertFalse((boolean)store.containsAll(Collections.singleton(SEGMENT_4_6)));
    }

    @Test
    public void testToObjectArray() {
        Object[] array = this.fSegmentStore.toArray();
        Assert.assertEquals((long)SEGMENTS.size(), (long)array.length);
        Assert.assertTrue((boolean)Arrays.asList(array).containsAll(SEGMENTS));
    }

    @Test
    public void testToSpecificArray() {
        ISegment[] array = (ISegment[])this.fSegmentStore.toArray((Object[])new ISegment[0]);
        Assert.assertEquals((long)SEGMENTS.size(), (long)array.length);
        Assert.assertTrue((boolean)Arrays.asList(array).containsAll(SEGMENTS));
    }

    @Test
    public void testToSpecifyArraySubtype() {
        ISegmentStore<@NonNull TestSegment> tms2 = this.getSegmentStore();
        TestSegment otherSegment = new TestSegment(2L, 6L, "test");
        tms2.add((Object)otherSegment);
        TestSegment[] array = (TestSegment[])tms2.toArray((Object[])new TestSegment[0]);
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)Arrays.asList(array).contains(otherSegment));
        tms2.dispose();
    }

    @Test
    public void testIterationOrder() {
        int i = 0;
        for (ISegment segment : this.fSegmentStore) {
            this.assertSegmentsEqual(SEGMENTS.get(i++), segment);
        }
    }

    @Test
    public void testIterationOrderNonSortedInsertion() {
        ISegmentStore<@NonNull TestSegment> store = this.getSegmentStore();
        for (TestSegment segment : REVERSE_SEGMENTS) {
            store.add((Object)((TestSegment)NonNullUtils.checkNotNull((Object)segment)));
        }
        int i = 0;
        for (TestSegment segment : store) {
            this.assertSegmentsEqual(SEGMENTS.get(i++), segment);
        }
        store.dispose();
    }

    @Test
    public void testGetIntersectingElementsRange() {
        Iterable intersectingElements = this.fSegmentStore.getIntersectingElements(16L, 20L);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)intersectingElements));
        intersectingElements = this.fSegmentStore.getIntersectingElements(1L, 15L);
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)intersectingElements));
        intersectingElements = this.fSegmentStore.getIntersectingElements(2L, 14L);
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)intersectingElements));
        intersectingElements = this.fSegmentStore.getIntersectingElements(11L, 13L);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)intersectingElements));
        this.assertSegmentsEqual(SEGMENT_10_14, (ISegment)Iterables.getOnlyElement((Iterable)intersectingElements));
        intersectingElements = this.fSegmentStore.getIntersectingElements(10L, 14L);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)intersectingElements));
        this.assertSegmentsEqual(SEGMENT_10_14, (ISegment)Iterables.getOnlyElement((Iterable)intersectingElements));
        intersectingElements = this.fSegmentStore.getIntersectingElements(14L, 18L);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)intersectingElements));
        this.assertSegmentsEqual(SEGMENT_10_14, (ISegment)Iterables.getOnlyElement((Iterable)intersectingElements));
        intersectingElements = this.fSegmentStore.getIntersectingElements(1L, 2L);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)intersectingElements));
        this.assertSegmentsEqual(SEGMENT_2_6, (ISegment)Iterables.getOnlyElement((Iterable)intersectingElements));
    }

    @Test
    public void testGetIntersectingElementsTime() {
        Iterable intersectingElements = this.fSegmentStore.getIntersectingElements(3L);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)intersectingElements));
        this.assertSegmentsEqual(SEGMENT_2_6, (ISegment)Iterables.getOnlyElement((Iterable)intersectingElements));
        intersectingElements = this.fSegmentStore.getIntersectingElements(2L);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)intersectingElements));
        this.assertSegmentsEqual(SEGMENT_2_6, (ISegment)Iterables.getOnlyElement((Iterable)intersectingElements));
        intersectingElements = this.fSegmentStore.getIntersectingElements(14L);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)intersectingElements));
        this.assertSegmentsEqual(SEGMENT_10_14, (ISegment)Iterables.getOnlyElement((Iterable)intersectingElements));
        intersectingElements = this.fSegmentStore.getIntersectingElements(6L);
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)intersectingElements));
        intersectingElements = this.fSegmentStore.getIntersectingElements(9L);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)intersectingElements));
        intersectingElements = this.fSegmentStore.getIntersectingElements(1L);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)intersectingElements));
        intersectingElements = this.fSegmentStore.getIntersectingElements(15L);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)intersectingElements));
    }

    @Test
    public void testDispose() {
        ISegmentStore<@NonNull TestSegment> store = this.getSegmentStore();
        store.add((Object)SEGMENT_2_6);
        store.dispose();
        Assert.assertEquals((long)0L, (long)store.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testIterator() {
        @NonNull ImmutableList beforeExpected = ImmutableList.of((Object)SEGMENT_2_6);
        @NonNull ImmutableList afterExpected = ImmutableList.of((Object)SEGMENT_2_6, (Object)SEGMENT_4_8);
        @NonNull ImmutableList lastExpected = ImmutableList.of((Object)SEGMENT_2_6, (Object)SEGMENT_4_8, (Object)SEGMENT_6_8);
        ArrayList<@NonNull TestSegment> fixture = new ArrayList<TestSegment>();
        ISegmentStore<@NonNull TestSegment> store = this.getSegmentStore();
        store.add((Object)SEGMENT_2_6);
        for (TestSegment item : store) {
            fixture.add(item);
        }
        Assert.assertEquals((Object)beforeExpected, fixture);
        fixture.clear();
        store.add((Object)SEGMENT_4_8);
        for (TestSegment item : store) {
            fixture.add(item);
        }
        Assert.assertEquals((Object)afterExpected, fixture);
        fixture.clear();
        @NonNull Iterator iter = store.iterator();
        store.add((Object)SEGMENT_6_8);
        @NonNull Iterator iter2 = store.iterator();
        fixture.clear();
        while (iter.hasNext()) {
            fixture.add((TestSegment)iter.next());
        }
        Assert.assertTrue((fixture.size() >= 2 ? 1 : 0) != 0);
        fixture.clear();
        while (iter2.hasNext()) {
            fixture.add((TestSegment)iter2.next());
        }
        Assert.assertEquals((Object)lastExpected, fixture);
    }

    @Test
    public void testSortedIterator() {
        LinkedList<@NonNull Comparator> comparators = new LinkedList<Comparator>();
        comparators.add(SegmentComparators.INTERVAL_END_COMPARATOR);
        comparators.add((Comparator)NonNullUtils.checkNotNull(SegmentComparators.INTERVAL_END_COMPARATOR.reversed()));
        comparators.add(SegmentComparators.INTERVAL_START_COMPARATOR);
        comparators.add((Comparator)NonNullUtils.checkNotNull(SegmentComparators.INTERVAL_START_COMPARATOR.reversed()));
        comparators.add(SegmentComparators.INTERVAL_LENGTH_COMPARATOR);
        comparators.add((Comparator)NonNullUtils.checkNotNull(SegmentComparators.INTERVAL_LENGTH_COMPARATOR.reversed()));
        for (Comparator comparator : comparators) {
            Iterable iterable = this.fSegmentStore.iterator(comparator);
            AbstractTestSegmentStore.verifySortedIterable(iterable, 5, comparator);
            iterable = this.fSegmentStore.getIntersectingElements(5L, comparator);
            AbstractTestSegmentStore.verifySortedIterable(iterable, 3, comparator);
            iterable = this.fSegmentStore.getIntersectingElements(7L, 14L, comparator);
            AbstractTestSegmentStore.verifySortedIterable(iterable, 3, comparator);
        }
    }

    private static void verifySortedIterable(Iterable<TestSegment> iterable, int expectedSize, Comparator<ISegment> comparator) {
        Assert.assertEquals((long)expectedSize, (long)Iterables.size(iterable));
        Iterator<TestSegment> iterator = iterable.iterator();
        ISegment current = iterator.next();
        while (iterator.hasNext()) {
            ISegment prev = current;
            Assert.assertTrue((comparator.compare(prev, current = (ISegment)iterator.next()) <= 0 ? 1 : 0) != 0);
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRetainAll() {
        ISegmentStore<@NonNull TestSegment> store = this.getSegmentStore();
        store.add((Object)SEGMENT_2_6);
        store.retainAll(Collections.emptyList());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove() {
        ISegmentStore<@NonNull TestSegment> store = this.getSegmentStore();
        store.add((Object)SEGMENT_2_6);
        store.remove((Object)SEGMENT_2_6);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveAll() {
        ISegmentStore<@NonNull TestSegment> store = this.getSegmentStore();
        store.add((Object)SEGMENT_2_6);
        store.removeAll(Collections.emptyList());
    }

    protected static final class TestSegment
    implements ISegment {
        public static final @NonNull IHTIntervalReader<@NonNull TestSegment> DESERIALISER = buffer -> new TestSegment(buffer.getLong(), buffer.getLong(), buffer.getString());
        private static final long serialVersionUID = -2242452053089575887L;
        private final long fStart;
        private final long fEnd;
        private final @NonNull String fPayload;

        public TestSegment(long start, long end, @NonNull String payload) {
            this.fStart = start;
            this.fEnd = end;
            this.fPayload = payload;
        }

        public long getStart() {
            return this.fStart;
        }

        public long getEnd() {
            return this.fEnd;
        }

        public String getPayload() {
            return this.fPayload;
        }

        public int getSizeOnDisk() {
            return 16 + SafeByteBufferFactory.getStringSizeInBuffer((String)this.fPayload);
        }

        public void writeSegment(@NonNull ISafeByteBufferWriter buffer) {
            buffer.putLong(this.fStart);
            buffer.putLong(this.fEnd);
            buffer.putString(this.fPayload);
        }
    }
}

